/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.UFC;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class FlowControlTest
extends ReceiverAdapter {
    protected JChannel ch;
    protected byte[] buf = new byte[50000];

    public void start(String props, String name) throws Exception {
        this.ch = new JChannel(props);
        this.ch.setName(name);
        this.ch.setReceiver(this);
        this.ch.connect("FlowControlTest");
        this.loop();
        Util.close((Closeable)this.ch);
    }

    @Override
    public void receive(Message msg) {
        System.out.println("<< " + msg.getLength() + " bytes from " + msg.getSrc());
    }

    @Override
    public void viewAccepted(View view) {
        System.out.println("view = " + view);
    }

    protected void loop() {
        block14: while (true) {
            int key = Util.keyPress("[1] Send multicast message [2] Send unicast message [3] Set message size [4] Print credits MFC [5] Print credits UFC [q] quit");
            switch (key) {
                case 49: {
                    Message msg = new Message(null, this.buf);
                    try {
                        this.ch.send(msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block14;
                }
                case 50: {
                    Address target = this.getReceiver();
                    Message msg = new Message(target, this.buf);
                    try {
                        this.ch.send(msg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block14;
                }
                case 51: {
                    try {
                        int msg_size = Util.readIntFromStdin("New message size: ");
                        this.buf = new byte[msg_size];
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block14;
                }
                case 52: {
                    MFC mfc = (MFC)this.ch.getProtocolStack().findProtocol((Class<? extends Protocol>)MFC.class);
                    if (mfc == null) {
                        System.err.println("MFC not found");
                        break;
                    }
                    System.out.println(mfc.printCredits());
                    break;
                }
                case 53: {
                    UFC ufc = (UFC)this.ch.getProtocolStack().findProtocol((Class<? extends Protocol>)UFC.class);
                    if (ufc == null) {
                        System.err.println("UFC not found");
                        break;
                    }
                    System.out.println(ufc.printCredits());
                    break;
                }
                case -1: 
                case 81: 
                case 113: 
                case 120: {
                    return;
                }
            }
        }
    }

    private Address getReceiver() {
        List<Address> mbrs = null;
        try {
            mbrs = this.ch.getView().getMembers();
            System.out.println("pick the target from the following members:");
            int i = 0;
            for (Address mbr : mbrs) {
                if (mbr.equals(this.ch.getAddress())) {
                    System.out.println("[" + i + "]: " + mbr + " (self)");
                } else {
                    System.out.println("[" + i + "]: " + mbr);
                }
                ++i;
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String tmp = reader.readLine().trim();
            int index = Integer.parseInt(tmp);
            return mbrs.get(index);
        }
        catch (Exception e) {
            System.err.println("getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args2) throws Exception {
        String name = null;
        String props = null;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-name")) {
                name = args2[++i];
                continue;
            }
            if (args2[i].equals("-props")) {
                props = args2[++i];
                continue;
            }
            System.out.println("FlowControlTest [-props <properties>] [-name <name>]");
            return;
        }
        FlowControlTest test = new FlowControlTest();
        test.start(props, name);
    }
}

