/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.spi;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.xsite.spi.AlwaysRemoveXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.DefaultXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNonNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.SiteEntry;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;

public enum XSiteMergePolicy implements XSiteEntryMergePolicy<Object, Object>
{
    PREFER_NON_NULL{

        @Override
        public <K, V> XSiteEntryMergePolicy<K, V> getInstance() {
            return PreferNonNullXSiteEntryMergePolicy.getInstance();
        }
    }
    ,
    PREFER_NULL{

        @Override
        public <K, V> XSiteEntryMergePolicy<K, V> getInstance() {
            return PreferNullXSiteEntryMergePolicy.getInstance();
        }
    }
    ,
    ALWAYS_REMOVE{

        @Override
        public <K, V> XSiteEntryMergePolicy<K, V> getInstance() {
            return AlwaysRemoveXSiteEntryMergePolicy.getInstance();
        }
    }
    ,
    DEFAULT{

        @Override
        public <K, V> XSiteEntryMergePolicy<K, V> getInstance() {
            return DefaultXSiteEntryMergePolicy.getInstance();
        }
    };


    public static XSiteMergePolicy fromString(String str) {
        for (XSiteMergePolicy mergePolicy : XSiteMergePolicy.values()) {
            if (!mergePolicy.name().equalsIgnoreCase(str)) continue;
            return mergePolicy;
        }
        return null;
    }

    public static <K, V> XSiteMergePolicy fromInstance(XSiteEntryMergePolicy<K, V> r2) {
        for (XSiteMergePolicy mergePolicy : XSiteMergePolicy.values()) {
            XSiteEntryMergePolicy<K, V> r1 = mergePolicy.getInstance();
            if (!Objects.equals(r1, r2)) continue;
            return mergePolicy;
        }
        return null;
    }

    public static <T, U> XSiteEntryMergePolicy<T, U> instanceFromString(String value, ClassLoader classLoader) {
        XSiteMergePolicy mergePolicy = XSiteMergePolicy.fromString(value);
        return mergePolicy == null ? (XSiteEntryMergePolicy)Util.getInstance(value, classLoader) : mergePolicy.getInstance();
    }

    @Override
    public CompletionStage<SiteEntry<Object>> merge(Object key, SiteEntry<Object> localEntry, SiteEntry<Object> remoteEntry) {
        throw new UnsupportedOperationException();
    }

    public abstract <K, V> XSiteEntryMergePolicy<K, V> getInstance();
}

