/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.stat.SimpleStat;
import org.infinispan.commons.stat.SimpleStateWithTimer;
import org.infinispan.commons.stat.TimerTracker;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.xsite.metrics.XSiteMetricsCollector;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultXSiteMetricsCollector
implements XSiteMetricsCollector {
    private static final long NON_EXISTING = -1L;
    private final Map<String, SiteMetric> siteMetricMap = new ConcurrentHashMap<String, SiteMetric>();
    private final SimpleStat globalRequestsSent;

    public DefaultXSiteMetricsCollector(Configuration configuration) {
        configuration.sites().enabledBackupStream().forEach(c -> this.siteMetricMap.put(c.site(), new SiteMetric()));
        this.globalRequestsSent = new SimpleStateWithTimer();
    }

    private static SiteMetric newSiteMetric(String site) {
        return new SiteMetric();
    }

    private static long convert(long value, long defaultValue, TimeUnit timeUnit) {
        return value == -1L ? defaultValue : timeUnit.convert(value, TimeUnit.NANOSECONDS);
    }

    @Override
    public Collection<String> sites() {
        return Collections.unmodifiableCollection(this.siteMetricMap.keySet());
    }

    @Override
    public void recordRequestSent(String dstSite, long duration, TimeUnit timeUnit) {
        assert (duration > 0L);
        long durationNanos = timeUnit.toNanos(duration);
        this.getSiteMetricToRecord(dstSite).getRequestsSent().record(durationNanos);
        this.globalRequestsSent.record(durationNanos);
    }

    @Override
    public long getMinRequestSentDuration(String dstSite, long defaultValue, TimeUnit outTimeUnit) {
        SiteMetric metric = this.siteMetricMap.get(dstSite);
        if (metric == null) {
            return defaultValue;
        }
        long val = metric.getRequestsSent().getMin(-1L);
        return DefaultXSiteMetricsCollector.convert(val, defaultValue, outTimeUnit);
    }

    @Override
    public long getMinRequestSentDuration(long defaultValue, TimeUnit outTimeUnit) {
        long val = this.globalRequestsSent.getMin(-1L);
        return DefaultXSiteMetricsCollector.convert(val, defaultValue, outTimeUnit);
    }

    @Override
    public long getMaxRequestSentDuration(String dstSite, long defaultValue, TimeUnit outTimeUnit) {
        SiteMetric metric = this.siteMetricMap.get(dstSite);
        if (metric == null) {
            return defaultValue;
        }
        long val = metric.getRequestsSent().getMax(-1L);
        return DefaultXSiteMetricsCollector.convert(val, defaultValue, outTimeUnit);
    }

    @Override
    public long getMaxRequestSentDuration(long defaultValue, TimeUnit outTimeUnit) {
        long val = this.globalRequestsSent.getMax(-1L);
        return DefaultXSiteMetricsCollector.convert(val, defaultValue, outTimeUnit);
    }

    @Override
    public long getAvgRequestSentDuration(String dstSite, long defaultValue, TimeUnit outTimeUnit) {
        SiteMetric metric = this.siteMetricMap.get(dstSite);
        if (metric == null) {
            return defaultValue;
        }
        long val = metric.getRequestsSent().getAverage(-1L);
        return DefaultXSiteMetricsCollector.convert(val, defaultValue, outTimeUnit);
    }

    @Override
    public long getAvgRequestSentDuration(long defaultValue, TimeUnit outTimeUnit) {
        long val = this.globalRequestsSent.getAverage(-1L);
        return DefaultXSiteMetricsCollector.convert(val, defaultValue, outTimeUnit);
    }

    @Override
    public long countRequestsSent(String dstSite) {
        SiteMetric metric = this.siteMetricMap.get(dstSite);
        return metric == null ? 0L : metric.getRequestsSent().count();
    }

    @Override
    public long countRequestsSent() {
        return this.globalRequestsSent.count();
    }

    @Override
    public void resetRequestsSent() {
        this.globalRequestsSent.reset();
        this.siteMetricMap.values().forEach(siteMetric -> siteMetric.getRequestsSent().reset());
    }

    @Override
    public void registerTimer(String dstSite, TimerTracker timer) {
        this.getSiteMetricToRecord(dstSite).getRequestsSent().setTimer(timer);
    }

    @Override
    public void registerTimer(TimerTracker timer) {
        this.globalRequestsSent.setTimer(timer);
    }

    @Override
    public void recordRequestsReceived(String srcSite) {
        this.getSiteMetricToRecord(srcSite).getRequestsReceived().increment();
    }

    @Override
    public long countRequestsReceived(String srcSite) {
        SiteMetric metric = this.siteMetricMap.get(srcSite);
        return metric == null ? 0L : metric.getRequestsReceived().sum();
    }

    @Override
    public long countRequestsReceived() {
        return this.siteMetricMap.values().stream().map(SiteMetric::getRequestsReceived).map(LongAdder::sum).reduce(0L, Long::sum);
    }

    @Override
    public void resetRequestReceived() {
        this.siteMetricMap.values().forEach(siteMetric -> siteMetric.getRequestsReceived().reset());
    }

    private SiteMetric getSiteMetricToRecord(String dstSite) {
        return this.siteMetricMap.computeIfAbsent(dstSite, DefaultXSiteMetricsCollector::newSiteMetric);
    }

    private static class SiteMetric {
        private final SimpleStat requestsSent = new SimpleStateWithTimer();
        private final LongAdder requestsReceived = new LongAdder();

        private SiteMetric() {
        }

        public SimpleStat getRequestsSent() {
            return this.requestsSent;
        }

        public LongAdder getRequestsReceived() {
            return this.requestsReceived;
        }
    }
}

