/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.cluster.SecurityActions;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterListenerReplicateCallable<K, V>
implements Function<EmbeddedCacheManager, Void>,
BiConsumer<EmbeddedCacheManager, Cache<K, V>> {
    private static final Log log = LogFactory.getLog(ClusterListenerReplicateCallable.class);
    private final String cacheName;
    private final UUID identifier;
    private final CacheEventFilter<K, V> filter;
    private final CacheEventConverter<K, V, ?> converter;
    private final Address origin;
    private final boolean sync;
    private final Set<Class<? extends Annotation>> filterAnnotations;
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final boolean useStorageFormat;

    public ClusterListenerReplicateCallable(String cacheName, UUID identifier, Address origin, CacheEventFilter<K, V> filter, CacheEventConverter<K, V, ?> converter, boolean sync, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
        this.cacheName = cacheName;
        this.identifier = identifier;
        this.origin = origin;
        this.filter = filter;
        this.converter = converter;
        this.sync = sync;
        this.filterAnnotations = filterAnnotations;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
        this.useStorageFormat = useStorageFormat;
        if (log.isTraceEnabled()) {
            log.tracef("Created clustered listener replicate callable for: %s", (Object)filterAnnotations);
        }
    }

    @Override
    public Void apply(EmbeddedCacheManager cacheManager) {
        Cache cache = SecurityActions.getCache(cacheManager, this.cacheName);
        this.accept(cacheManager, cache);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(EmbeddedCacheManager cacheManager, Cache<K, V> cache) {
        ComponentRegistry componentRegistry = SecurityActions.getComponentRegistry(cache.getAdvancedCache());
        CacheNotifier cacheNotifier = componentRegistry.getComponent(CacheNotifier.class);
        CacheManagerNotifier cacheManagerNotifier = componentRegistry.getComponent(CacheManagerNotifier.class);
        Address ourAddress = cache.getCacheManager().getAddress();
        ClusterEventManager eventManager = componentRegistry.getComponent(ClusterEventManager.class);
        if (this.filter != null) {
            componentRegistry.wireDependencies(this.filter);
        }
        if (this.converter != null && this.converter != this.filter) {
            componentRegistry.wireDependencies(this.converter);
        }
        if (!ourAddress.equals(this.origin)) {
            if (cacheManager.getMembers().contains(this.origin)) {
                CacheNotifier cacheNotifier2 = cacheNotifier;
                synchronized (cacheNotifier2) {
                    boolean alreadyInstalled = false;
                    for (Object installedListener : cacheNotifier.getListeners()) {
                        if (!(installedListener instanceof RemoteClusterListener) || !this.identifier.equals(((RemoteClusterListener)installedListener).getId())) continue;
                        alreadyInstalled = true;
                        break;
                    }
                    if (!alreadyInstalled) {
                        RemoteClusterListener listener = new RemoteClusterListener(this.identifier, this.origin, cacheNotifier, cacheManagerNotifier, eventManager, this.sync);
                        ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion, this.useStorageFormat);
                        cacheNotifier.addFilteredListener(listenerHolder, this.filter, this.converter, this.filterAnnotations);
                        cacheManagerNotifier.addListener(listener);
                        if (!cacheManager.getMembers().contains(this.origin)) {
                            cacheNotifier.removeListener(listener);
                            cacheManagerNotifier.removeListener(listener);
                            if (log.isTraceEnabled()) {
                                log.tracef("Removing local cluster listener for remote cluster listener that was just registered, as the origin %s went away concurrently", (Object)this.origin);
                            }
                        } else if (log.isTraceEnabled()) {
                            log.tracef("Registered local cluster listener for remote cluster listener from origin %s with id %s", (Object)this.origin, (Object)this.identifier);
                        }
                    } else if (log.isTraceEnabled()) {
                        log.tracef("Local cluster listener from origin %s with id %s was already installed, ignoring", (Object)this.origin, (Object)this.identifier);
                    }
                }
            } else if (log.isTraceEnabled()) {
                log.tracef("Not registering local cluster listener for remote cluster listener from origin %s, as the origin went away", (Object)this.origin);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Not registering local cluster listener as we are the node who registered the cluster listener");
        }
    }

    public String toString() {
        return "ClusterListenerReplicateCallable{cacheName='" + this.cacheName + '\'' + ", identifier=" + this.identifier + ", origin=" + this.origin + ", sync=" + this.sync + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<ClusterListenerReplicateCallable> {
        @Override
        public Set<Class<? extends ClusterListenerReplicateCallable>> getTypeClasses() {
            return Collections.singleton(ClusterListenerReplicateCallable.class);
        }

        @Override
        public void writeObject(ObjectOutput output, ClusterListenerReplicateCallable object) throws IOException {
            output.writeObject(object.cacheName);
            output.writeObject(object.identifier);
            output.writeObject(object.origin);
            output.writeObject(object.filter);
            if (object.filter == object.converter && object.filter instanceof CacheEventFilterConverter) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
                output.writeObject(object.converter);
            }
            output.writeBoolean(object.sync);
            MarshallUtil.marshallCollection(object.filterAnnotations, output);
            DataConversion.writeTo(output, object.keyDataConversion);
            DataConversion.writeTo(output, object.valueDataConversion);
            output.writeBoolean(object.useStorageFormat);
        }

        @Override
        public ClusterListenerReplicateCallable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String cacheName = (String)input.readObject();
            UUID id = (UUID)input.readObject();
            Address address = (Address)input.readObject();
            CacheEventFilter filter = (CacheEventFilter)input.readObject();
            boolean sameConverter = input.readBoolean();
            CacheEventConverter converter = sameConverter ? (CacheEventFilterConverter)filter : (CacheEventConverter)input.readObject();
            boolean sync = input.readBoolean();
            Set filterAnnotations = MarshallUtil.unmarshallCollection(input, HashSet::new);
            DataConversion keyDataConversion = DataConversion.readFrom(input);
            DataConversion valueDataConversion = DataConversion.readFrom(input);
            boolean raw = input.readBoolean();
            return new ClusterListenerReplicateCallable(cacheName, id, address, filter, converter, sync, filterAnnotations, keyDataConversion, valueDataConversion, raw);
        }

        @Override
        public Integer getId() {
            return 68;
        }
    }
}

