/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.CustomMetricsSupplier;
import org.infinispan.metrics.impl.MetricsCollector;
import org.infinispan.metrics.impl.NameUtils;

@Scope(value=Scopes.NONE)
abstract class AbstractMetricsRegistration {
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    BasicComponentRegistry basicComponentRegistry;
    @Inject
    MetricsCollector metricsCollector;
    private String namePrefix;
    private Set<Object> metricIds;

    AbstractMetricsRegistration() {
    }

    @Start
    protected void start() {
        if (this.metricsEnabled()) {
            this.namePrefix = this.initNamePrefix();
            this.metricIds = Collections.synchronizedSet(new HashSet());
            try {
                this.processComponents();
            }
            catch (Exception e) {
                throw new CacheException("Failure while registering metrics", e);
            }
        }
    }

    @Stop
    protected void stop() {
        if (this.metricIds != null) {
            this.unregisterMetrics(this.metricIds);
            this.metricIds = null;
        }
    }

    public abstract boolean metricsEnabled();

    protected String initNamePrefix() {
        String prefix = this.globalConfig.metrics().namesAsTags() ? "" : "cache_manager_" + NameUtils.filterIllegalChars(this.globalConfig.cacheManagerName()) + '_';
        String globalPrefix = this.globalConfig.metrics().prefix();
        return globalPrefix != null && !globalPrefix.isEmpty() ? globalPrefix + '_' + prefix : prefix;
    }

    private void processComponents() {
        for (ComponentRef<?> component : this.basicComponentRegistry.getRegisteredComponents()) {
            MBeanMetadata beanMetadata;
            Object instance;
            if (component.isAlias() || (instance = component.wired()) == null || (beanMetadata = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName())) == null) continue;
            Set<Object> ids = this.registerMetrics(instance, beanMetadata.getJmxObjectName(), beanMetadata.getAttributes(), null, component.getName(), null);
            this.metricIds.addAll(ids);
            if (!(instance instanceof CustomMetricsSupplier)) continue;
            this.metricIds.addAll(this.registerMetrics(instance, beanMetadata.getJmxObjectName(), ((CustomMetricsSupplier)instance).getCustomMetrics(), null, component.getName(), null));
        }
    }

    private Set<Object> registerMetrics(Object instance, String jmxObjectName, Collection<MBeanMetadata.AttributeMetadata> attributes, String type, String componentName, String prefix) {
        if (jmxObjectName == null) {
            jmxObjectName = componentName;
        }
        if (jmxObjectName == null) {
            throw new IllegalArgumentException("No MBean name and no component name was specified");
        }
        String metricPrefix = this.namePrefix;
        if (!jmxObjectName.equals("Cache") && !jmxObjectName.equals("CacheManager")) {
            if (prefix != null) {
                metricPrefix = metricPrefix + NameUtils.decamelize(prefix) + '_';
            }
            if (type != null && !type.equals(jmxObjectName)) {
                metricPrefix = metricPrefix + NameUtils.decamelize(type) + '_';
            }
            metricPrefix = metricPrefix + NameUtils.decamelize(jmxObjectName) + '_';
        }
        return this.internalRegisterMetrics(instance, attributes, metricPrefix);
    }

    protected abstract Set<Object> internalRegisterMetrics(Object var1, Collection<MBeanMetadata.AttributeMetadata> var2, String var3);

    public void registerMetrics(Object instance, String type, String componentName) {
        if (this.metricsCollector == null) {
            throw new IllegalStateException("Microprofile metrics are not initialized");
        }
        MBeanMetadata beanMetadata = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName());
        if (beanMetadata == null) {
            throw new IllegalArgumentException("No MBean metadata available for " + instance.getClass().getName());
        }
        Set<Object> ids = this.registerMetrics(instance, beanMetadata.getJmxObjectName(), beanMetadata.getAttributes(), type, componentName, null);
        this.metricIds.addAll(ids);
    }

    public Set<Object> registerExternalMetrics(Object instance, String prefix) {
        if (this.metricsCollector == null) {
            throw new IllegalStateException("Microprofile metrics are not initialized");
        }
        MBeanMetadata beanMetadata = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName());
        if (beanMetadata == null) {
            throw new IllegalArgumentException("No MBean metadata available for " + instance.getClass().getName());
        }
        return this.registerMetrics(instance, beanMetadata.getJmxObjectName(), beanMetadata.getAttributes(), null, null, prefix);
    }

    public void unregisterMetrics(Set<Object> metricIds) {
        if (this.metricsCollector == null) {
            throw new IllegalStateException("Microprofile metrics are not initialized");
        }
        try {
            for (Object metricId : metricIds) {
                this.metricsCollector.unregisterMetric(metricId);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while unregistering metrics", e);
        }
    }
}

