/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.functional.MetaParam;

public final class MetaParamExternalizers {
    private MetaParamExternalizers() {
    }

    public static final class EntryVersionParamExternalizer
    extends AbstractExternalizer<MetaParam.MetaEntryVersion> {
        @Override
        public void writeObject(ObjectOutput output, MetaParam.MetaEntryVersion object) throws IOException {
            output.writeObject(object.get());
        }

        @Override
        public MetaParam.MetaEntryVersion readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            EntryVersion entryVersion = (EntryVersion)input.readObject();
            return new MetaParam.MetaEntryVersion(entryVersion);
        }

        @Override
        public Set<Class<? extends MetaParam.MetaEntryVersion>> getTypeClasses() {
            return Util.asSet(MetaParam.MetaEntryVersion.class);
        }

        @Override
        public Integer getId() {
            return 92;
        }
    }

    public static final class MaxIdleExternalizer
    extends AbstractExternalizer<MetaParam.MetaMaxIdle> {
        @Override
        public void writeObject(ObjectOutput output, MetaParam.MetaMaxIdle object) throws IOException {
            output.writeLong(object.get());
        }

        @Override
        public MetaParam.MetaMaxIdle readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new MetaParam.MetaMaxIdle(input.readLong());
        }

        @Override
        public Set<Class<? extends MetaParam.MetaMaxIdle>> getTypeClasses() {
            return Util.asSet(MetaParam.MetaMaxIdle.class);
        }

        @Override
        public Integer getId() {
            return 93;
        }
    }

    public static final class LifespanExternalizer
    extends AbstractExternalizer<MetaParam.MetaLifespan> {
        @Override
        public void writeObject(ObjectOutput output, MetaParam.MetaLifespan object) throws IOException {
            output.writeLong(object.get());
        }

        @Override
        public MetaParam.MetaLifespan readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new MetaParam.MetaLifespan(input.readLong());
        }

        @Override
        public Set<Class<? extends MetaParam.MetaLifespan>> getTypeClasses() {
            return Util.asSet(MetaParam.MetaLifespan.class);
        }

        @Override
        public Integer getId() {
            return 91;
        }
    }
}

