/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private static final Log log = LogFactory.getLog(PessimisticLockingInterceptor.class);
    private final InvocationSuccessFunction<LockControlCommand> localLockCommandWork = (rCtx, rCommand, rv) -> this.localLockCommandWork((TxInvocationContext)rCtx, (LockControlCommand)rCommand);
    private final InvocationSuccessAction<PrepareCommand> releaseLockOnCompletion = (rCtx, rCommand, rv) -> this.releaseLockOnTxCompletion((TxInvocationContext)rCtx);
    @Inject
    CommandsFactory cf;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected final Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        if (!this.readNeedsLock(ctx, command)) {
            return this.invokeNext(ctx, command);
        }
        if (!this.readNeedsLock(ctx, command)) {
            return this.invokeNext(ctx, command);
        }
        Object key = command.getKey();
        if (!this.needRemoteLocks(ctx, key, (FlagAffectedCommand)command)) {
            return this.acquireLocalLockAndInvokeNext(ctx, command);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
        lcc.setTopologyId(command.getTopologyId());
        return this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> this.acquireLocalLockAndInvokeNext(rCtx, command));
    }

    private boolean readNeedsLock(InvocationContext ctx, FlagAffectedCommand command) {
        return ctx.isInTxScope() && command.hasAnyFlag(FlagBitSets.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command);
    }

    private InvocationStage acquireLocalLock(InvocationContext ctx, DataCommand command) {
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        Object key = command.getKey();
        txContext.addAffectedKey(key);
        ((AbstractCacheTransaction)txContext.getCacheTransaction()).removeBackupLock(key);
        return this.lockOrRegisterBackupLock(txContext, command, key, this.getLockTimeoutMillis(command));
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys2) {
        Object maybeStage = !this.readNeedsLock(ctx, command) ? this.invokeNext(ctx, command) : this.lockAndRecordForManyKeysCommand(ctx, command, keys2);
        return maybeStage;
    }

    private InvocationStage acquireLocalLocks(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys2) {
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        txContext.addAllAffectedKeys(keys2);
        ((AbstractCacheTransaction)txContext.getCacheTransaction()).removeBackupLocks(keys2);
        return this.lockAllOrRegisterBackupLock(txContext, command, keys2, this.getLockTimeoutMillis(command));
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, this.releaseLockOnCompletion);
    }

    @Override
    protected <K> Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command, Collection<K> keys2, boolean forwarded) {
        Object maybeStage = this.hasSkipLocking(command) ? this.invokeNext(ctx, command) : this.lockAndRecordForManyKeysCommand(ctx, command, keys2);
        return maybeStage;
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        Object maybeStage;
        Object key = command.getKey();
        if (this.hasSkipLocking(command)) {
            if (ctx.isInTxScope()) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            maybeStage = this.invokeNext(ctx, command);
        } else if (!this.needRemoteLocks(ctx, key, (FlagAffectedCommand)command)) {
            maybeStage = this.acquireLocalLockAndInvokeNext(ctx, command);
        } else {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            lcc.setTopologyId(command.getTopologyId());
            return this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> this.acquireLocalLockAndInvokeNext(rCtx, command));
        }
        return maybeStage;
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("Locks should only be acquired within the scope of a transaction!");
        }
        boolean skipLocking = this.hasSkipLocking(command);
        if (skipLocking) {
            return false;
        }
        if (ctx.isOriginLocal()) {
            boolean needBackupLocks;
            boolean isSingleKeyAndLocal = !command.multipleKeys() && this.cdl.getCacheTopology().getDistribution(command.getSingleKey()).isPrimary();
            boolean bl = needBackupLocks = !isSingleKeyAndLocal || this.isStateTransferInProgress();
            if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
                if (localTx.getAffectedKeys().containsAll(command.getKeys())) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Already own locks on keys: %s, skipping remote call", (Object)command.getKeys());
                    }
                    return true;
                }
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("Single key %s and local, skipping remote call", command.getSingleKey());
                }
                return this.localLockCommandWork(ctx, command);
            }
        }
        return this.invokeNextThenApply(ctx, command, this.localLockCommandWork);
    }

    private Object localLockCommandWork(TxInvocationContext<?> ctx, LockControlCommand command) {
        if (ctx.isOriginLocal()) {
            ctx.addAllAffectedKeys(command.getKeys());
        }
        if (command.isUnlock()) {
            if (ctx.isOriginLocal()) {
                throw new AssertionError((Object)"There's no advancedCache.unlock so this must have originated remotely.");
            }
            return false;
        }
        ((AbstractCacheTransaction)ctx.getCacheTransaction()).removeBackupLocks(command.getKeys());
        return this.lockAllOrRegisterBackupLock(ctx, command, command.getKeys(), this.getLockTimeoutMillis(command)).thenApply(ctx, command, (rCtx, rCommand, rv) -> true);
    }

    private boolean needRemoteLocks(InvocationContext ctx, Collection<?> keys2, FlagAffectedCommand command) {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(keys2) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().containsAll(keys2);
            if (!needRemoteLock && log.isTraceEnabled()) {
                log.tracef("We already have lock for keys %s, skip remote lock acquisition", (Object)keys2);
            }
        }
        return needRemoteLock;
    }

    private boolean needRemoteLocks(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(key) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().contains(key);
            if (!needRemoteLock && log.isTraceEnabled()) {
                log.tracef("We already have lock for key %s, skip remote lock acquisition", key);
            }
        } else if (log.isTraceEnabled()) {
            log.tracef("Don't need backup locks for key %s", key);
        }
        return needRemoteLock;
    }

    private boolean isLockOwner(Collection<?> keys2) {
        for (Object key : keys2) {
            if (this.isLockOwner(key)) continue;
            return false;
        }
        return true;
    }

    private boolean isStateTransferInProgress() {
        return this.cdl.getCacheTopology().getPhase() == CacheTopology.Phase.READ_OLD_WRITE_ALL;
    }

    private Object lockAndRecordForManyKeysCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys2) {
        if (!this.needRemoteLocks(ctx, keys2, command)) {
            return this.acquireLocalLocksAndInvokeNext(ctx, command, keys2);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        LockControlCommand lcc = this.cf.buildLockControlCommand(keys2, command.getFlagsBitSet(), txContext.getGlobalTransaction());
        if (command instanceof TopologyAffectedCommand) {
            lcc.setTopologyId(((TopologyAffectedCommand)((Object)command)).getTopologyId());
        }
        return this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> this.acquireLocalLocksAndInvokeNext(rCtx, command, keys2));
    }

    private Object acquireLocalLocksAndInvokeNext(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys2) {
        InvocationStage lockStage = this.acquireLocalLocks(ctx, command, keys2);
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, lockStage);
    }

    private Object acquireLocalLockAndInvokeNext(InvocationContext ctx, DataCommand command) {
        InvocationStage lockStage = this.acquireLocalLock(ctx, command);
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, lockStage);
    }
}

