/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.TxReadOnlyKeyCommand;
import org.infinispan.commands.functional.TxReadOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.SpliteratorMapper;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.StatsEnvelope;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.reactive.publisher.PublisherReducers;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.SegmentedEntryStreamSupplier;
import org.infinispan.stream.impl.local.SegmentedKeyStreamSupplier;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.DataContainerRemoveIterator;
import org.infinispan.util.EntryWrapper;
import org.infinispan.util.UserRaisedFunctionalException;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class CallInterceptor
extends BaseAsyncInterceptor
implements Visitor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final int CLOCK_BUFFER = 100;
    @Inject
    ComponentRef<Cache> cacheRef;
    @Inject
    CacheNotifier cacheNotifier;
    @Inject
    TimeService timeService;
    @Inject
    VersionGenerator versionGenerator;
    @Inject
    InternalDataContainer<?, ?> dataContainer;
    @Inject
    DistributionManager distributionManager;
    @Inject
    InternalEntryFactory internalEntryFactory;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    GroupManager groupManager;
    @Inject
    ClusterPublisherManager clusterPublisherManager;
    @ComponentName(value="NoClusterPublisherManager")
    @Inject
    ClusterPublisherManager localClusterPublisherManager;
    @Inject
    ComponentRegistry componentRegistry;
    Cache unwrappedCache;
    private IncrementableEntryVersion nonExistentVersion;

    @Start
    public void start() {
        this.nonExistentVersion = this.versionGenerator.nonExistingVersion();
        this.unwrappedCache = AbstractDelegatingCache.unwrapCache(this.cacheRef.wired());
    }

    @Override
    public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (log.isTraceEnabled()) {
            log.tracef("Invoking: %s", (Object)command.getClass().getSimpleName());
        }
        return command.acceptVisitor(ctx, this);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object prevValue;
        ValueMatcher valueMatcher = command.getValueMatcher();
        if (valueMatcher == ValueMatcher.MATCH_NEVER) {
            command.fail();
            return null;
        }
        Object key = command.getKey();
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
        if (e == null) {
            throw new IllegalStateException("Not wrapped");
        }
        Object newValue = command.getValue();
        Metadata metadata = command.getMetadata();
        if (metadata instanceof InternalMetadataImpl) {
            InternalMetadataImpl internalMetadata = (InternalMetadataImpl)metadata;
            metadata = internalMetadata.actual();
            e.setCreated(internalMetadata.created());
            e.setLastUsed(internalMetadata.lastUsed());
        }
        if (!valueMatcher.matches(prevValue = e.getValue(), null, newValue)) {
            command.fail();
            return prevValue;
        }
        return this.performPut(e, ctx, valueMatcher, key, newValue, metadata, command, command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER | FlagBitSets.PUT_FOR_X_SITE_STATE_TRANSFER));
    }

    private Object performPut(MVCCEntry<Object, Object> e, InvocationContext ctx, ValueMatcher valueMatcher, Object key, Object value, Metadata metadata, FlagAffectedCommand command, boolean skipNotification) {
        Object entryValue = e.getValue();
        CompletionStage<Void> stage = null;
        if (!skipNotification) {
            stage = e.isCreated() ? this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, true, ctx, command) : this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, entryValue, e.getMetadata(), true, ctx, command);
        }
        e.updatePreviousValue();
        Object o = e.setValue(value);
        Metadatas.updateMetadata(e, metadata);
        if (e.isRemoved()) {
            e.setCreated(true);
            e.setExpired(false);
            e.setRemoved(false);
            o = null;
        }
        e.setChanged(true);
        this.updateStoreFlags(command, e);
        return CallInterceptor.delayedValue(stage, valueMatcher != ValueMatcher.MATCH_EXPECTED_OR_NEW ? o : null);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.visitRemoveCommand(ctx, command, true);
    }

    private Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command, boolean notifyRemove) throws Throwable {
        ValueMatcher valueMatcher = command.getValueMatcher();
        if (valueMatcher == ValueMatcher.MATCH_NEVER) {
            command.fail();
            return null;
        }
        Object key = command.getKey();
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
        Object prevValue = e.getValue();
        Object optionalValue = command.getValue();
        if (prevValue == null) {
            command.nonExistant();
            if (valueMatcher.matches(null, optionalValue, null)) {
                e.setChanged(true);
                e.setRemoved(true);
                e.setCreated(false);
                if (command instanceof EvictCommand) {
                    e.setEvicted(true);
                }
                e.setValue(null);
                this.updateStoreFlags(command, e);
                return command.isConditional() ? Boolean.valueOf(true) : null;
            }
            log.trace("Nothing to remove since the entry doesn't exist in the context or it is null");
            command.fail();
            return false;
        }
        if (!valueMatcher.matches(prevValue, optionalValue, null)) {
            command.fail();
            return false;
        }
        if (command instanceof EvictCommand) {
            e.setEvicted(true);
        }
        return this.performRemove(e, ctx, valueMatcher, key, prevValue, optionalValue, command.getMetadata(), notifyRemove, command);
    }

    protected Object performRemove(MVCCEntry<?, ?> e, InvocationContext ctx, ValueMatcher valueMatcher, Object key, Object prevValue, Object optionalValue, Metadata commandMetadata, boolean notifyRemove, DataWriteCommand command) {
        CompletionStage<Void> stage = notifyRemove ? this.cacheNotifier.notifyCacheEntryRemoved(key, prevValue, e.getMetadata(), true, ctx, command) : null;
        e.setRemoved(true);
        e.setChanged(true);
        e.setValue(null);
        if (commandMetadata != null) {
            e.setMetadata(commandMetadata);
        }
        Object returnValue = valueMatcher != ValueMatcher.MATCH_EXPECTED_OR_NEW ? (command.isConditional() ? Boolean.valueOf(true) : prevValue) : (command.isConditional() ? Boolean.valueOf(true) : optionalValue);
        this.updateStoreFlags(command, e);
        return CallInterceptor.delayedValue(stage, returnValue);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        Object key = command.getKey();
        ValueMatcher valueMatcher = command.getValueMatcher();
        Metadata metadata = command.getMetadata();
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
        if (e == null) {
            throw new IllegalStateException("Not wrapped");
        }
        return command.isRemove() ? this.performRemove(e, ctx, valueMatcher, key, null, null, metadata, true, command) : this.performPut(e, ctx, valueMatcher, key, command.getValue(), metadata, command, false);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        ValueMatcher valueMatcher = command.getValueMatcher();
        if (valueMatcher == ValueMatcher.MATCH_NEVER) {
            command.fail();
            return null;
        }
        Object key = command.getKey();
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
        Object prevValue = e.getValue();
        Object newValue = command.getNewValue();
        Object expectedValue = command.getOldValue();
        if (valueMatcher.matches(prevValue, expectedValue, newValue)) {
            e.setChanged(true);
            e.setValue(newValue);
            Metadata newMetadata = command.getMetadata();
            Metadata prevMetadata = e.getMetadata();
            CompletionStage<Void> stage = this.cacheNotifier.notifyCacheEntryModified(key, newValue, newMetadata, expectedValue == null ? prevValue : expectedValue, prevMetadata, true, ctx, command);
            Metadatas.updateMetadata(e, newMetadata);
            this.updateStoreFlags(command, e);
            return CallInterceptor.delayedValue(stage, expectedValue == null ? prevValue : Boolean.valueOf(true));
        }
        command.fail();
        return expectedValue == null ? prevValue : Boolean.valueOf(false);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        CompletionStage<Void> stage;
        Object newValue;
        Object key = command.getKey();
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
        if (e == null) {
            throw new IllegalStateException("Not wrapped");
        }
        Object oldValue = e.getValue();
        if (command.isComputeIfPresent() && oldValue == null) {
            command.fail();
            return null;
        }
        try {
            newValue = command.getRemappingBiFunction().apply(key, oldValue);
        }
        catch (RuntimeException ex) {
            throw new UserRaisedFunctionalException(ex);
        }
        if (oldValue == null && newValue == null) {
            return null;
        }
        Metadata metadata = command.getMetadata();
        if (oldValue != null) {
            if (newValue != null) {
                stage = this.cacheNotifier.notifyCacheEntryModified(key, newValue, metadata, oldValue, e.getMetadata(), true, ctx, command);
                e.setChanged(true);
                e.setValue(newValue);
                Metadatas.updateMetadata(e, metadata);
            } else {
                stage = this.cacheNotifier.notifyCacheEntryRemoved(key, oldValue, e.getMetadata(), true, ctx, command);
                e.setRemoved(true);
                e.setChanged(true);
                e.setValue(null);
            }
        } else {
            stage = this.cacheNotifier.notifyCacheEntryCreated(key, newValue, metadata, true, ctx, command);
            e.setValue(newValue);
            e.setChanged(true);
            Metadatas.updateMetadata(e, metadata);
            if (e.isRemoved()) {
                e.setCreated(true);
                e.setExpired(false);
                e.setRemoved(false);
            }
        }
        this.updateStoreFlags(command, e);
        return CallInterceptor.delayedValue(stage, newValue);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        Object key = command.getKey();
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
        if (e == null) {
            throw new IllegalStateException("Not wrapped");
        }
        Object value = e.getValue();
        CompletionStage<Void> stage = null;
        if (value == null) {
            try {
                value = command.getMappingFunction().apply(key);
            }
            catch (RuntimeException ex) {
                throw new UserRaisedFunctionalException(ex);
            }
            if (value != null) {
                e.setValue(value);
                Metadata metadata = command.getMetadata();
                Metadatas.updateMetadata(e, metadata);
                if (e.isCreated()) {
                    stage = this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, true, ctx, command);
                }
                if (e.isRemoved()) {
                    e.setCreated(true);
                    e.setExpired(false);
                    e.setRemoved(false);
                }
                e.setChanged(true);
            }
            this.updateStoreFlags(command, e);
        } else {
            command.fail();
        }
        return CallInterceptor.delayedValue(stage, value);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        if (this.cacheNotifier.hasListener(CacheEntryRemoved.class)) {
            aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            for (InternalCacheEntry e : this.dataContainer) {
                aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryRemoved(e.getKey(), e.getValue(), e.getMetadata(), true, ctx, command));
            }
        }
        return CallInterceptor.delayedNull(aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : null);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Map<Object, Object> inputMap = command.getMap();
        Metadata metadata = command.getMetadata();
        HashMap previousValues = command.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? null : new HashMap(inputMap.size());
        AggregateCompletionStage<Void> aggregateCompletionStage = this.cacheNotifier.hasListener(CacheEntryCreated.class) || this.cacheNotifier.hasListener(CacheEntryModified.class) ? CompletionStages.aggregateCompletionStage() : null;
        for (Map.Entry<Object, Object> e : inputMap.entrySet()) {
            Object key = e.getKey();
            MVCCEntry<Object, Object> contextEntry = this.lookupMvccEntry(ctx, key);
            if (contextEntry == null) continue;
            Object newValue = e.getValue();
            Object previousValue = contextEntry.getValue();
            Metadata previousMetadata = contextEntry.getMetadata();
            if (previousValues != null) {
                previousValues.put(key, previousValue);
            }
            if (aggregateCompletionStage != null) {
                if (contextEntry.isCreated()) {
                    aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryCreated(key, newValue, metadata, true, ctx, command));
                } else {
                    aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryModified(key, newValue, metadata, previousValue, previousMetadata, true, ctx, command));
                }
            }
            contextEntry.setValue(newValue);
            Metadatas.updateMetadata(contextEntry, metadata);
            contextEntry.setChanged(true);
            this.updateStoreFlags(command, contextEntry);
        }
        return CallInterceptor.delayedValue(aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : null, previousValues);
    }

    private MVCCEntry<Object, Object> lookupMvccEntry(InvocationContext ctx, Object key) {
        return (MVCCEntry)ctx.lookupEntry(key);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        this.visitRemoveCommand(ctx, command, false);
        return null;
    }

    @Override
    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) throws Throwable {
        Object key = command.getKey();
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
        Metadata metadata = command.getMetadata();
        if (command.hasAnyFlag(FlagBitSets.BACKUP_WRITE)) {
            if (log.isTraceEnabled()) {
                log.trace("Removing expired entry without checks as we are backup as primary already performed them");
            }
            e.setExpired(true);
            return this.performRemove(e, ctx, ValueMatcher.MATCH_ALWAYS, key, e.getValue() != null ? e.getValue() : null, command.getValue(), metadata, false, command);
        }
        if (e != null && !e.isRemoved()) {
            Object prevValue = e.getValue();
            Object optionalValue = command.getValue();
            Long lifespan = command.getLifespan();
            ValueMatcher valueMatcher = command.getValueMatcher();
            if (lifespan == null || command.hasAnyFlag(FlagBitSets.SKIP_SHARED_CACHE_STORE)) {
                if (valueMatcher.matches(prevValue, optionalValue, null)) {
                    e.setExpired(true);
                    return this.performRemove(e, ctx, valueMatcher, key, prevValue, optionalValue, metadata, false, command);
                }
            } else if (WriteSkewHelper.versionFromEntry(e) == this.nonExistentVersion) {
                if (optionalValue == null || valueMatcher.matches(prevValue, optionalValue, null)) {
                    e.setExpired(true);
                    return this.performRemove(e, ctx, valueMatcher, key, prevValue, optionalValue, metadata, false, command);
                }
            } else if (e.getLifespan() > 0L && e.getLifespan() == lifespan.longValue()) {
                if (valueMatcher.matches(prevValue, optionalValue, null)) {
                    if (ExpiryHelper.isExpiredMortal(lifespan, e.getCreated(), this.timeService.wallClockTime() + 100L)) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Removing entry as its lifespan and value match and it created on %s with a current time of %s", e.getCreated(), this.timeService.wallClockTime());
                        }
                        e.setExpired(true);
                        return this.performRemove(e, ctx, valueMatcher, key, prevValue, optionalValue, metadata, false, command);
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("Cannot remove entry due to it not being expired - this can be caused by different clocks on nodes or a concurrent write", new Object[0]);
                    }
                } else if (log.isTraceEnabled()) {
                    log.tracef("Cannot remove entry due to the value not being equal. Matcher: %s, PrevValue: %s, ExpectedValue: %s. Double check equality is working for the value", (Object)valueMatcher, prevValue, optionalValue);
                }
            } else if (log.isTraceEnabled()) {
                log.trace("Cannot remove entry as its lifespan or value do not match");
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Nothing to remove since the entry doesn't exist in the context or it is already removed - assume command was successful");
            }
            return true;
        }
        command.fail();
        return false;
    }

    private Cache cacheWithFlags(long flagBitSet) {
        if (flagBitSet != 0L) {
            return this.unwrappedCache.getAdvancedCache().withFlags((Flag[])EnumUtil.enumArrayOf((long)flagBitSet, Flag.class));
        }
        return this.unwrappedCache;
    }

    @Override
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        ClusterPublisherManager managerToUse = command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL) ? this.localClusterPublisherManager : this.clusterPublisherManager;
        return CallInterceptor.asyncValue(managerToUse.keyReduction(false, null, null, ctx, !command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), DeliveryGuarantee.EXACTLY_ONCE, PublisherReducers.count(), PublisherReducers.add()));
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        if (entry.isRemoved()) {
            if (log.isTraceEnabled()) {
                log.tracef("Entry has been deleted and is of type %s", (Object)entry.getClass().getSimpleName());
            }
            return null;
        }
        return entry.getValue();
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        if (entry.isNull() || entry.isRemoved()) {
            return null;
        }
        return this.internalEntryFactory.copy(entry);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        LinkedHashMap map = new LinkedHashMap();
        for (Object key : command.getKeys()) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry == null) {
                throw new IllegalStateException("Entry for key " + Util.toStr(key) + " not found");
            }
            if (entry.isNull()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Entry for key %s is null in current context", (Object)Util.toStr(key));
                }
                map.put(key, null);
                continue;
            }
            if (entry.isRemoved()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Entry for key %s has been deleted and is of type %s", (Object)Util.toStr(key), (Object)entry.getClass().getSimpleName());
                }
                map.put(key, null);
                continue;
            }
            if (command.isReturnEntries()) {
                CacheEntry copy = ctx.isOriginLocal() ? this.internalEntryFactory.copy(entry) : entry;
                if (log.isTraceEnabled()) {
                    log.tracef("Found entry %s -> %s", (Object)Util.toStr(key), (Object)entry);
                    log.tracef("Returning copied entry %s", (Object)copy);
                }
                map.put(key, copy);
                continue;
            }
            Object value = entry.getValue();
            if (log.isTraceEnabled()) {
                log.tracef("Found %s -> %s", (Object)Util.toStr(key), (Object)Util.toStr(value));
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        long flagBitSet = command.getFlagsBitSet();
        boolean isRemoteIteration = EnumUtil.containsAny(flagBitSet, FlagBitSets.REMOTE_ITERATION);
        return new BackingKeySet(this.cacheWithFlags(flagBitSet), this.dataContainer, this.keyPartitioner, isRemoteIteration);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        long flagsBitSet = command.getFlagsBitSet();
        boolean isRemoteIteration = EnumUtil.containsAny(flagsBitSet, FlagBitSets.REMOTE_ITERATION);
        Cache flagCache = this.cacheWithFlags(flagsBitSet);
        Object lockOwner = ctx.getLockOwner();
        if (ctx.getLockOwner() != null) {
            return new BackingEntrySet(flagCache.getAdvancedCache().lockAs(lockOwner), this.dataContainer, this.keyPartitioner, isRemoteIteration);
        }
        return new BackingEntrySet(flagCache, this.dataContainer, this.keyPartitioner, isRemoteIteration);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return null;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return null;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return null;
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand invalidateCommand) throws Throwable {
        Object[] keys2 = invalidateCommand.getKeys();
        if (log.isTraceEnabled()) {
            log.tracef("Invalidating keys %s", (Object)Util.toStr(Arrays.asList(keys2)));
        }
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        if (this.cacheNotifier.hasListener(CacheEntryInvalidated.class)) {
            aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        }
        for (Object key : keys2) {
            MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
            if (e == null) continue;
            e.setChanged(true);
            e.setRemoved(true);
            e.setCreated(false);
            if (aggregateCompletionStage == null) continue;
            aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryInvalidated(key, e.getValue(), e.getMetadata(), true, ctx, invalidateCommand));
        }
        return CallInterceptor.delayedNull(aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : null);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command invalidateL1Command) throws Throwable {
        Object[] keys2 = invalidateL1Command.getKeys();
        if (log.isTraceEnabled()) {
            log.tracef("Preparing to invalidate keys %s", (Object)Arrays.asList(keys2));
        }
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        if (this.cacheNotifier.hasListener(CacheEntryInvalidated.class)) {
            aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        }
        for (Object key : keys2) {
            InternalCacheEntry ice = this.dataContainer.peek(key);
            if (ice == null) continue;
            boolean isLocal = this.distributionManager.getCacheTopology().isWriteOwner(key);
            if (!isLocal) {
                if (log.isTraceEnabled()) {
                    log.tracef("Invalidating key %s.", key);
                }
                MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
                e.setRemoved(true);
                e.setChanged(true);
                e.setCreated(false);
                if (aggregateCompletionStage == null) continue;
                aggregateCompletionStage.dependsOn(this.cacheNotifier.notifyCacheEntryInvalidated(key, e.getValue(), e.getMetadata(), true, ctx, invalidateL1Command));
                continue;
            }
            log.tracef("Not invalidating key %s as it is local now", key);
        }
        return CallInterceptor.delayedNull(aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : null);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return null;
    }

    @Override
    public Object visitUnknownCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return command.invoke();
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        KeyValueCollector collector = ctx.isOriginLocal() ? new LocalContextKeyValueCollector() : new RemoteContextKeyValueCollector();
        Object groupName = command.getGroupName();
        ctx.forEachValue((key, entry) -> {
            if (groupName.equals(this.groupManager.getGroup(key))) {
                collector.addCacheEntry((CacheEntry)entry);
            }
        });
        return collector.getResult();
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        TxReadOnlyKeyCommand txReadOnlyKeyCommand;
        List<Mutation> mutations;
        if (command instanceof TxReadOnlyKeyCommand && (mutations = (txReadOnlyKeyCommand = (TxReadOnlyKeyCommand)command).getMutations()) != null && !mutations.isEmpty()) {
            return this.visitTxReadOnlyKeyCommand(ctx, txReadOnlyKeyCommand, mutations);
        }
        Object key = command.getKey();
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry == null) {
            throw new IllegalStateException();
        }
        DataConversion keyDataConversion = command.getKeyDataConversion();
        EntryView.ReadEntryView ro = entry.isNull() ? EntryViews.noValue(key, keyDataConversion) : EntryViews.readOnly(entry, keyDataConversion, command.getValueDataConversion());
        Object ret = EntryViews.snapshot(command.getFunction().apply(ro));
        return Param.StatisticsMode.isSkip(command.getParams()) ? ret : StatsEnvelope.create(ret, entry.isNull());
    }

    private Object visitTxReadOnlyKeyCommand(InvocationContext ctx, TxReadOnlyKeyCommand command, List<Mutation> mutations) {
        MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(command.getKey());
        EntryViews.AccessLoggingReadWriteView rw = EntryViews.readWrite(entry, command.getKeyDataConversion(), command.getValueDataConversion());
        StatsEnvelope ret = null;
        for (Mutation mutation : mutations) {
            entry.updatePreviousValue();
            ret = (StatsEnvelope)mutation.apply(rw);
        }
        Function function = command.getFunction();
        if (function != null) {
            ret = (StatsEnvelope)function.apply(rw);
        }
        ret = EntryViews.snapshot(ret);
        return Param.StatisticsMode.isSkip(command.getParams()) ? ret : StatsEnvelope.create(ret, entry.isNull());
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        TxReadOnlyManyCommand txReadOnlyManyCommand;
        List<List<Mutation>> mutations;
        if (command instanceof TxReadOnlyManyCommand && (mutations = (txReadOnlyManyCommand = (TxReadOnlyManyCommand)command).getMutations()) != null && !mutations.isEmpty()) {
            return this.visitTxReadOnlyCommand(ctx, (TxReadOnlyManyCommand)command, mutations);
        }
        Collection<?> keys2 = command.getKeys();
        ArrayList retvals = new ArrayList(keys2.size());
        boolean skipStats = Param.StatisticsMode.isSkip(command.getParams());
        DataConversion keyDataConversion = command.getKeyDataConversion();
        DataConversion valueDataConversion = command.getValueDataConversion();
        Function function = command.getFunction();
        for (Object k : keys2) {
            CacheEntry me = ctx.lookupEntry(k);
            EntryView.ReadEntryView view = me.isNull() ? EntryViews.noValue(k, keyDataConversion) : EntryViews.readOnly(me, keyDataConversion, valueDataConversion);
            Object ret = EntryViews.snapshot(function.apply(view));
            retvals.add(skipStats ? ret : StatsEnvelope.create(ret, me.isNull()));
        }
        return retvals.stream();
    }

    private Object visitTxReadOnlyCommand(InvocationContext ctx, TxReadOnlyManyCommand command, List<List<Mutation>> mutations) {
        Collection<?> keys2 = command.getKeys();
        ArrayList<StatsEnvelope> retvals = new ArrayList<StatsEnvelope>(keys2.size());
        Iterator<List<Mutation>> mutIt = mutations.iterator();
        boolean skipStats = Param.StatisticsMode.isSkip(command.getParams());
        Function function = command.getFunction();
        DataConversion keyDataConversion = command.getKeyDataConversion();
        DataConversion valueDataConversion = command.getValueDataConversion();
        for (Object k : keys2) {
            EntryView.ReadEntryView ro;
            List<Mutation> innerMutations = mutIt.next();
            MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(k);
            StatsEnvelope<Object> ret = null;
            if (mutations.isEmpty()) {
                ro = entry.isNull() ? EntryViews.noValue(k, keyDataConversion) : EntryViews.readOnly(entry, keyDataConversion, valueDataConversion);
            } else {
                EntryViews.AccessLoggingReadWriteView rw = EntryViews.readWrite(entry, keyDataConversion, valueDataConversion);
                for (Mutation mutation : innerMutations) {
                    entry.updatePreviousValue();
                    ret = mutation.apply(rw);
                }
                ro = rw;
            }
            if (function != null) {
                ret = (StatsEnvelope<Object>)function.apply(ro);
            }
            ret = EntryViews.snapshot(ret);
            retvals.add(skipStats ? ret : StatsEnvelope.create(ret, entry.isNull()));
        }
        return retvals.stream();
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        boolean exists = e.getValue() != null;
        command.getConsumer().accept(EntryViews.writeOnly(e, command.getValueDataConversion()));
        if (!e.isChanged() && !command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            command.fail();
        }
        this.updateStoreFlags(command, e);
        return Param.StatisticsMode.isSkip(command.getParams()) ? null : StatsEnvelope.create(null, e, exists, false);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        ValueMatcher valueMatcher = command.getValueMatcher();
        if (valueMatcher == ValueMatcher.MATCH_NEVER) {
            command.fail();
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        Object prevValue = command.getPrevValue();
        Metadata prevMetadata = command.getPrevMetadata();
        boolean hasCommandRetry = command.hasAnyFlag(FlagBitSets.COMMAND_RETRY);
        if (prevValue == null && !hasCommandRetry) {
            prevValue = e.getValue();
            prevMetadata = e.getMetadata();
            command.setPrevValueAndMetadata(prevValue, prevMetadata);
        }
        Object oldPrevValue = e.getValue();
        CacheEntry copy = e.clone();
        DataConversion valueDataConversion = command.getValueDataConversion();
        Object decodedArgument = valueDataConversion.fromStorage(command.getArgument());
        EntryViews.AccessLoggingReadWriteView view = EntryViews.readWrite((MVCCEntry)copy, prevValue, prevMetadata, command.getKeyDataConversion(), valueDataConversion);
        Object ret = EntryViews.snapshot(command.getBiFunction().apply(decodedArgument, view));
        if (valueMatcher.matches(oldPrevValue, prevValue, copy.getValue())) {
            log.tracef("Execute read-write function on previous value %s and previous metadata %s", prevValue, (Object)prevMetadata);
            e.setValue(copy.getValue());
            e.setMetadata(copy.getMetadata());
            e.setChanged(copy.isChanged());
            e.setRemoved(copy.isRemoved());
        }
        if (!e.isChanged() && !hasCommandRetry) {
            command.fail();
        }
        this.updateStoreFlags(command, e);
        return Param.StatisticsMode.isSkip(command.getParams()) ? ret : StatsEnvelope.create(ret, e, prevValue != null, view.isRead());
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        if (command.getValueMatcher() == ValueMatcher.MATCH_NEVER) {
            command.fail();
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        boolean exists = e.getValue() != null;
        EntryViews.AccessLoggingReadWriteView view = EntryViews.readWrite(e, command.getKeyDataConversion(), command.getValueDataConversion());
        Object ret = EntryViews.snapshot(command.getFunction().apply(view));
        if (!e.isChanged() && !command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            command.fail();
        }
        this.updateStoreFlags(command, e);
        return Param.StatisticsMode.isSkip(command.getParams()) ? ret : StatsEnvelope.create(ret, e, exists, view.isRead());
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        Map<?, ?> arguments = command.getArguments();
        DataConversion valueDataConversion = command.getValueDataConversion();
        for (Map.Entry<?, ?> entry : arguments.entrySet()) {
            MVCCEntry cacheEntry = (MVCCEntry)ctx.lookupEntry(entry.getKey());
            if (cacheEntry == null) {
                throw new IllegalStateException();
            }
            this.updateStoreFlags(command, cacheEntry);
            Object decodedValue = valueDataConversion.fromStorage(entry.getValue());
            command.getBiConsumer().accept(decodedValue, EntryViews.writeOnly(cacheEntry, valueDataConversion));
        }
        return null;
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        DataConversion valueDataConversion = command.getValueDataConversion();
        Object decodedArgument = valueDataConversion.fromStorage(command.getArgument());
        boolean exists = e.getValue() != null;
        command.getBiConsumer().accept(decodedArgument, EntryViews.writeOnly(e, valueDataConversion));
        if (!e.isChanged() && !command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            command.fail();
        }
        this.updateStoreFlags(command, e);
        return Param.StatisticsMode.isSkip(command.getParams()) ? null : StatsEnvelope.create(null, e, exists, false);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        Consumer consumer = command.getConsumer();
        DataConversion valueDataConversion = command.getValueDataConversion();
        for (Object k : command.getAffectedKeys()) {
            MVCCEntry cacheEntry = (MVCCEntry)ctx.lookupEntry(k);
            if (cacheEntry == null) {
                throw new IllegalStateException();
            }
            this.updateStoreFlags(command, cacheEntry);
            consumer.accept(EntryViews.writeOnly(cacheEntry, valueDataConversion));
        }
        return null;
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        Collection<?> keys2 = command.getAffectedKeys();
        ArrayList returns = new ArrayList(keys2.size());
        boolean skipStats = Param.StatisticsMode.isSkip(command.getParams());
        DataConversion keyDataConversion = command.getKeyDataConversion();
        DataConversion valueDataConversion = command.getValueDataConversion();
        Function function = command.getFunction();
        keys2.forEach(k -> {
            MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(k);
            boolean exists = entry.getValue() != null;
            EntryViews.AccessLoggingReadWriteView view = EntryViews.readWrite(entry, keyDataConversion, valueDataConversion);
            Object r = EntryViews.snapshot(function.apply(view));
            returns.add(skipStats ? r : StatsEnvelope.create(r, entry, exists, view.isRead()));
            this.updateStoreFlags(command, entry);
        });
        return returns;
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        Map<?, ?> arguments = command.getArguments();
        ArrayList returns = new ArrayList(arguments.size());
        boolean skipStats = Param.StatisticsMode.isSkip(command.getParams());
        BiFunction biFunction = command.getBiFunction();
        DataConversion keyDataConversion = command.getKeyDataConversion();
        DataConversion valueDataConversion = command.getValueDataConversion();
        arguments.forEach((k, arg) -> {
            MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(k);
            if (entry == null) {
                throw new IllegalStateException();
            }
            Object decodedArgument = valueDataConversion.fromStorage(arg);
            boolean exists = entry.getValue() != null;
            EntryViews.AccessLoggingReadWriteView view = EntryViews.readWrite(entry, keyDataConversion, valueDataConversion);
            Object r = EntryViews.snapshot(biFunction.apply(decodedArgument, view));
            returns.add(skipStats ? r : StatsEnvelope.create(r, entry, exists, view.isRead()));
            this.updateStoreFlags(command, entry);
        });
        return returns;
    }

    @Override
    public Object visitTouchCommand(InvocationContext ctx, TouchCommand command) throws Throwable {
        Object key;
        int segment = command.getSegment();
        InternalCacheEntry<?, ?> ice = this.dataContainer.peek(segment, key = command.getKey());
        if (ice == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Entry was not in the container to touch for key %s", key);
            }
            return Boolean.FALSE;
        }
        long currentTime = this.timeService.wallClockTime();
        if (command.isTouchEvenIfExpired() || !ice.isExpired(currentTime)) {
            boolean touched = this.dataContainer.touch(segment, key, currentTime);
            if (log.isTraceEnabled()) {
                log.tracef("Entry was touched: %s for key %s.", (Object)touched, key);
            }
            return touched;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Entry was expired for key %s and we could not touch it.", key);
        }
        return Boolean.FALSE;
    }

    private void updateStoreFlags(FlagAffectedCommand command, MVCCEntry e) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_SHARED_CACHE_STORE)) {
            e.setSkipSharedStore();
        }
    }

    private static class RemoteContextKeyValueCollector
    implements KeyValueCollector {
        private final List<CacheEntry> list = new LinkedList<CacheEntry>();

        private RemoteContextKeyValueCollector() {
        }

        @Override
        public void addCacheEntry(CacheEntry entry) {
            this.list.add(entry);
        }

        @Override
        public Object getResult() {
            return this.list;
        }
    }

    private static class LocalContextKeyValueCollector
    implements KeyValueCollector {
        private final Map<Object, Object> map = new HashMap<Object, Object>();

        private LocalContextKeyValueCollector() {
        }

        @Override
        public void addCacheEntry(CacheEntry entry) {
            this.map.put(entry.getKey(), entry.getValue());
        }

        @Override
        public Object getResult() {
            return this.map;
        }
    }

    private static interface KeyValueCollector {
        public void addCacheEntry(CacheEntry var1);

        public Object getResult();
    }

    private static class BackingKeySet<K, V>
    extends AbstractCollection<K>
    implements CacheSet<K> {
        private final boolean isRemoteIteration;
        private final Cache<K, V> cache;
        private final InternalDataContainer<K, V> dataContainer;
        private final KeyPartitioner keyPartitioner;

        BackingKeySet(Cache<K, V> cache, InternalDataContainer<K, V> dataContainer, KeyPartitioner keyPartitioner, boolean isRemoteIteration) {
            this.cache = cache;
            this.dataContainer = dataContainer;
            this.keyPartitioner = keyPartitioner;
            this.isRemoteIteration = isRemoteIteration;
        }

        @Override
        public CloseableIterator<K> iterator() {
            if (this.isRemoteIteration) {
                return new IteratorMapper<InternalCacheEntry, Object>(this.dataContainer.iterator(), Map.Entry::getKey);
            }
            return new IteratorMapper<CacheEntry, Object>(new DataContainerRemoveIterator<K, V>(this.cache, this.dataContainer), Map.Entry::getKey);
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return new SpliteratorMapper<InternalCacheEntry, Object>(this.dataContainer.spliterator(), Map.Entry::getKey);
        }

        @Override
        public int size() {
            return this.dataContainer.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.dataContainer.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.cache.remove(o) != null;
        }

        private CacheStream<K> doStream(boolean parallel) {
            return new LocalCacheStream<K>(new SegmentedKeyStreamSupplier<K, V>(this.cache, this.keyPartitioner, this.dataContainer), parallel, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<K> stream() {
            return this.doStream(false);
        }

        @Override
        public CacheStream<K> parallelStream() {
            return this.doStream(true);
        }

        @Override
        public Publisher<K> localPublisher(int segment) {
            return Flowable.fromPublisher(this.dataContainer.publisher(segment)).map(RxJavaInterop.entryToKeyFunction());
        }

        @Override
        public Publisher<K> localPublisher(IntSet segments) {
            return Flowable.fromPublisher(this.dataContainer.publisher(segments)).map(RxJavaInterop.entryToKeyFunction());
        }
    }

    static class BackingEntrySet<K, V>
    extends AbstractCollection<CacheEntry<K, V>>
    implements CacheSet<CacheEntry<K, V>> {
        private final boolean isRemoteIteration;
        private final Cache<K, V> cache;
        private final InternalDataContainer<K, V> dataContainer;
        private final KeyPartitioner keyPartitioner;

        BackingEntrySet(Cache<K, V> cache, InternalDataContainer<K, V> dataContainer, KeyPartitioner keyPartitioner, boolean isRemoteIteration) {
            this.cache = cache;
            this.dataContainer = dataContainer;
            this.keyPartitioner = keyPartitioner;
            this.isRemoteIteration = isRemoteIteration;
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            if (this.isRemoteIteration) {
                return Closeables.iterator(this.dataContainer.iterator());
            }
            DataContainerRemoveIterator<K, V> iterator2 = new DataContainerRemoveIterator<K, V>(this.cache, this.dataContainer);
            return new IteratorMapper<CacheEntry, CacheEntry>(iterator2, e -> new EntryWrapper<K, V>(this.cache, e));
        }

        static <K, V> CloseableSpliterator<CacheEntry<K, V>> closeableCast(Spliterator spliterator) {
            if (spliterator instanceof CloseableSpliterator) {
                return (CloseableSpliterator)spliterator;
            }
            return Closeables.spliterator(spliterator);
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return BackingEntrySet.closeableCast(this.dataContainer.spliterator());
        }

        @Override
        public int size() {
            return this.dataContainer.size();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                InternalCacheEntry<K, V> value = this.dataContainer.get(entry.getKey());
                return value != null && value.getValue().equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            return entry != null && this.cache.remove(entry.getKey(), entry.getValue());
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }

        private CacheStream<CacheEntry<K, V>> doStream(boolean parallel) {
            return new LocalCacheStream<CacheEntry<K, V>>(new SegmentedEntryStreamSupplier<K, V>(this.cache, this.keyPartitioner, this.dataContainer), parallel, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return this.doStream(false);
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return this.doStream(true);
        }

        @Override
        public Publisher<CacheEntry<K, V>> localPublisher(int segment) {
            return this.dataContainer.publisher(segment);
        }

        @Override
        public Publisher<CacheEntry<K, V>> localPublisher(IntSet segments) {
            return this.dataContainer.publisher(segments);
        }
    }
}

