/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.ArrayList;
import java.util.function.ToIntFunction;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.BloomFilter;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;

public class MurmurHash3BloomFilter
extends BloomFilter<byte[]> {
    MurmurHash3BloomFilter(int bitsToUse, IntSet intSet, int hashFunctions) {
        super(bitsToUse, intSet, MurmurHash3BloomFilter.functions(hashFunctions));
    }

    private static int defaultHashFunctionCount() {
        return Integer.parseInt(System.getProperty("infinispan.bloom-filter.hash-functions", "3"));
    }

    public static BloomFilter<byte[]> createFilter(int bitsToUse) {
        return MurmurHash3BloomFilter.createFilter(bitsToUse, MurmurHash3BloomFilter.defaultHashFunctionCount());
    }

    public static BloomFilter<byte[]> createFilter(int bitsToUse, int hashFunctions) {
        return new MurmurHash3BloomFilter(bitsToUse, IntSets.mutableEmptySet(bitsToUse), hashFunctions);
    }

    public static BloomFilter<byte[]> createConcurrentFilter(int bitsToUse) {
        return MurmurHash3BloomFilter.createConcurrentFilter(bitsToUse, MurmurHash3BloomFilter.defaultHashFunctionCount());
    }

    public static BloomFilter<byte[]> createConcurrentFilter(int bitsToUse, int hashFunctions) {
        return new MurmurHash3BloomFilter(bitsToUse, IntSets.concurrentSet(bitsToUse), hashFunctions);
    }

    private static Iterable<ToIntFunction<byte[]>> functions(int hashFunctions) {
        if (hashFunctions <= 0) {
            throw new IllegalArgumentException("Number of hash functions must be positive, received " + hashFunctions);
        }
        ArrayList<ToIntFunction<byte[]>> functions2 = new ArrayList<ToIntFunction<byte[]>>(hashFunctions);
        for (int i = 0; i < hashFunctions; ++i) {
            int prime = MurmurHash3BloomFilter.getPrime(i);
            functions2.add(bytes -> MurmurHash3.MurmurHash3_x64_32(bytes, prime));
        }
        return functions2;
    }

    private static int getPrime(int offset) {
        switch (offset) {
            case 0: {
                return 239;
            }
            case 1: {
                return 1847;
            }
            case 2: {
                return 2719;
            }
            case 3: {
                return 3989;
            }
            case 4: {
                return 4481;
            }
            case 5: {
                return 5407;
            }
            case 6: {
                return 6047;
            }
            case 7: {
                return 7537;
            }
            case 8: {
                return 8467;
            }
            case 9: {
                return 9973;
            }
        }
        throw new IllegalArgumentException("Only support up to 10 hash functions");
    }
}

