/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.json;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.infinispan.commons.configuration.io.AbstractConfigurationWriter;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationWriterException;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.dataconversion.internal.Json;

public class JsonConfigurationWriter
extends AbstractConfigurationWriter {
    private boolean attributes;
    private boolean openTag;
    private final Deque<Json> json = new ArrayDeque<Json>();

    public JsonConfigurationWriter(Writer writer, boolean prettyPrint, boolean clearTextSecrets) {
        super(writer, 2, prettyPrint, clearTextSecrets, NamingStrategy.KEBAB_CASE);
    }

    @Override
    public void writeStartDocument() {
        this.json.push(Json.object());
    }

    @Override
    public void writeStartElement(String name) {
        this.writeStartElement(name, true);
    }

    private void writeStartElement(String name, boolean convert) {
        if (convert) {
            name = this.naming.convert(name);
        }
        AbstractConfigurationWriter.Tag parentTag = (AbstractConfigurationWriter.Tag)this.tagStack.peek();
        this.tagStack.push(new AbstractConfigurationWriter.Tag(name, false, true, true));
        Json object = Json.object();
        Json parent = this.json.peek();
        if (parent.isArray()) {
            parent.add(object);
        } else if (parentTag != null && parentTag.isRepeating()) {
            if (parent.has(name)) {
                parent.at(name).add(object);
            } else {
                parent.set(name, Json.array(object));
            }
        } else {
            parent.set(name, object);
        }
        this.json.push(object);
        this.openTag = true;
        this.attributes = false;
    }

    @Override
    public void writeStartElement(String prefix, String namespace, String name) {
        this.writeStartElement(this.prefixName(prefix, namespace, name));
    }

    private String prefixName(String prefix, String namespace, String name) {
        if (prefix == null) {
            return name;
        }
        if (this.namespaces.containsKey(prefix)) {
            return prefix + ":" + name;
        }
        return namespace + ":" + name;
    }

    @Override
    public void writeStartArrayElement(String name) {
        this.tagStack.push(new AbstractConfigurationWriter.Tag(name, true, true, false));
        Json array = Json.array();
        this.json.peek().set(name, array);
        this.json.push(array);
        this.attributes = false;
    }

    @Override
    public void writeEndArrayElement() {
        this.tagStack.pop();
        this.json.pop();
    }

    @Override
    public void writeStartListElement(String name, boolean explicit) {
        this.tagStack.push(new AbstractConfigurationWriter.Tag(name, true, explicit, true));
        Json array = Json.array();
        this.json.peek().set(name, array);
        this.json.push(array);
        this.openTag = true;
        this.attributes = false;
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, String name, boolean explicit) {
        this.writeStartListElement(this.prefixName(prefix, namespace, name), explicit);
    }

    @Override
    public void writeEndListElement() {
        this.tagStack.pop();
        this.json.pop();
        this.openTag = false;
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeDefaultNamespace(String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeEndElement() {
        this.tagStack.pop();
        this.json.pop();
        this.openTag = false;
    }

    @Override
    public void writeEndDocument() {
        try {
            Json json = this.json.pop();
            this.writer.write(this.prettyPrint ? json.toPrettyString() : json.toString());
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, Iterable<String> values2) {
        Json parent = this.attributeParent();
        Json array = Json.array();
        for (String value : values2) {
            array.add(value);
        }
        parent.set(name, array);
    }

    private Json attributeParent() {
        this.attributes = true;
        Json parent = this.json.peek();
        if (parent.isArray()) {
            this.json.pop();
            parent = this.json.peek().replace(parent, Json.object());
            this.json.push(parent);
        }
        return parent;
    }

    @Override
    public void writeAttribute(String name, String value) {
        Json parent = this.attributeParent();
        parent.set(name, (Object)value);
    }

    @Override
    public void writeAttribute(String name, boolean value) {
        Json parent = this.attributeParent();
        parent.set(name, (Object)value);
    }

    @Override
    public void writeArrayElement(String outer, String inner, String attribute, Iterable<String> values2) {
        Json array = Json.array();
        values2.forEach(array::add);
        this.json.peek().set(outer, array);
    }

    @Override
    public void writeCharacters(String chars) {
    }

    @Override
    public void writeEmptyElement(String name) {
        this.json.peek().set(name, null);
    }

    @Override
    public void writeComment(String comment) {
    }

    @Override
    public void writeStartMap(String name) {
        this.writeStartElement(name);
    }

    @Override
    public void writeMapItem(String element, String name, String key, String value) {
        this.json.peek().set(key, (Object)value);
    }

    @Override
    public void writeMapItem(String element, String name, String key) {
        this.writeStartElement(key, false);
        this.writeStartElement(element);
    }

    @Override
    public void writeEndMapItem() {
        this.writeEndElement();
        this.writeEndElement();
    }

    @Override
    public void writeEndMap() {
        this.writeEndElement();
    }

    @Override
    public boolean hasFeature(ConfigurationFormatFeature feature) {
        return false;
    }
}

