/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;

public class CacheShutdownRequestCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 93;
    private String cacheName;

    public CacheShutdownRequestCommand() {
        super((byte)93);
    }

    public CacheShutdownRequestCommand(String cacheName) {
        super((byte)93);
        this.cacheName = cacheName;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getClusterTopologyManager().handleShutdownRequest(this.cacheName);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString(this.cacheName, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString(input);
    }

    public String toString() {
        return "ShutdownCacheRequestCommand{cacheName='" + this.cacheName + '\'' + '}';
    }
}

