/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CommonTags {
    ACTIONABLE,
    NULL;


    public static CommonTags fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("actionable".equals(codeString)) {
            return ACTIONABLE;
        }
        throw new FHIRException("Unknown CommonTags code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIONABLE: {
                return "actionable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/common-tags";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIONABLE: {
                return "This request is intended to be acted upon, not merely stored";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIONABLE: {
                return "Actionable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

