/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Schedule", profile="http://hl7.org/fhir/StructureDefinition/Schedule")
public class Schedule
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="External Ids for this item.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this schedule is in active use", formalDefinition="Whether this schedule record is in active use or should not be used (such as was entered in error).")
    protected BooleanType active;
    @Child(name="serviceCategory", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="High-level category", formalDefinition="A broad categorization of the service that is to be performed during this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-category")
    protected List<CodeableConcept> serviceCategory;
    @Child(name="serviceType", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific service", formalDefinition="The specific service that is to be performed during this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableConcept> serviceType;
    @Child(name="specialty", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of specialty needed", formalDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="actor", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=5, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource(s) that availability information is being provided for", formalDefinition="Slots that reference this schedule resource provide the availability details to these referenced resource(s).")
    protected List<Reference> actor;
    protected List<Resource> actorTarget;
    @Child(name="planningHorizon", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period of time covered by schedule", formalDefinition="The period of time that the slots that reference this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates.")
    protected Period planningHorizon;
    @Child(name="comment", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments on availability", formalDefinition="Comments on the availability to describe any extended information. Such as custom constraints on the slots that may be associated.")
    protected StringType comment;
    private static final long serialVersionUID = 203182600L;
    @SearchParamDefinition(name="actor", path="Schedule.actor", description="The individual(HealthcareService, Practitioner, Location, ...) to find a Schedule for", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Schedule:actor").toLocked();
    @SearchParamDefinition(name="date", path="Schedule.planningHorizon", description="Search for Schedule resources that have a period that contains this date specified", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Schedule.identifier", description="A Schedule Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="specialty", path="Schedule.specialty", description="Type of specialty needed", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="service-category", path="Schedule.serviceCategory", description="High-level category", type="token")
    public static final String SP_SERVICE_CATEGORY = "service-category";
    public static final TokenClientParam SERVICE_CATEGORY = new TokenClientParam("service-category");
    @SearchParamDefinition(name="service-type", path="Schedule.serviceType", description="The type of appointments that can be booked into associated slot(s)", type="token")
    public static final String SP_SERVICE_TYPE = "service-type";
    public static final TokenClientParam SERVICE_TYPE = new TokenClientParam("service-type");
    @SearchParamDefinition(name="active", path="Schedule.active", description="Is the schedule in active use", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Schedule setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Schedule addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Schedule setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Schedule setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getServiceCategory() {
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        return this.serviceCategory;
    }

    public Schedule setServiceCategory(List<CodeableConcept> theServiceCategory) {
        this.serviceCategory = theServiceCategory;
        return this;
    }

    public boolean hasServiceCategory() {
        if (this.serviceCategory == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceCategory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return t;
    }

    public Schedule addServiceCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return this;
    }

    public CodeableConcept getServiceCategoryFirstRep() {
        if (this.getServiceCategory().isEmpty()) {
            this.addServiceCategory();
        }
        return this.getServiceCategory().get(0);
    }

    public List<CodeableConcept> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        return this.serviceType;
    }

    public Schedule setServiceType(List<CodeableConcept> theServiceType) {
        this.serviceType = theServiceType;
        return this;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceType() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return t;
    }

    public Schedule addServiceType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return this;
    }

    public CodeableConcept getServiceTypeFirstRep() {
        if (this.getServiceType().isEmpty()) {
            this.addServiceType();
        }
        return this.getServiceType().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public Schedule setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public Schedule addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public List<Reference> getActor() {
        if (this.actor == null) {
            this.actor = new ArrayList<Reference>();
        }
        return this.actor;
    }

    public Schedule setActor(List<Reference> theActor) {
        this.actor = theActor;
        return this;
    }

    public boolean hasActor() {
        if (this.actor == null) {
            return false;
        }
        for (Reference item : this.actor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addActor() {
        Reference t = new Reference();
        if (this.actor == null) {
            this.actor = new ArrayList<Reference>();
        }
        this.actor.add(t);
        return t;
    }

    public Schedule addActor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.actor == null) {
            this.actor = new ArrayList<Reference>();
        }
        this.actor.add(t);
        return this;
    }

    public Reference getActorFirstRep() {
        if (this.getActor().isEmpty()) {
            this.addActor();
        }
        return this.getActor().get(0);
    }

    @Deprecated
    public List<Resource> getActorTarget() {
        if (this.actorTarget == null) {
            this.actorTarget = new ArrayList<Resource>();
        }
        return this.actorTarget;
    }

    public Period getPlanningHorizon() {
        if (this.planningHorizon == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.planningHorizon");
            }
            if (Configuration.doAutoCreate()) {
                this.planningHorizon = new Period();
            }
        }
        return this.planningHorizon;
    }

    public boolean hasPlanningHorizon() {
        return this.planningHorizon != null && !this.planningHorizon.isEmpty();
    }

    public Schedule setPlanningHorizon(Period value) {
        this.planningHorizon = value;
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Schedule setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Schedule setComment(String value) {
        if (Utilities.noString(value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "External Ids for this item.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether this schedule record is in active use or should not be used (such as was entered in error).", 0, 1, this.active));
        children.add(new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory));
        children.add(new Property("serviceType", "CodeableConcept", "The specific service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceType));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property(SP_ACTOR, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "Slots that reference this schedule resource provide the availability details to these referenced resource(s).", 0, Integer.MAX_VALUE, this.actor));
        children.add(new Property("planningHorizon", "Period", "The period of time that the slots that reference this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates.", 0, 1, this.planningHorizon));
        children.add(new Property("comment", "string", "Comments on the availability to describe any extended information. Such as custom constraints on the slots that may be associated.", 0, 1, this.comment));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "External Ids for this item.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether this schedule record is in active use or should not be used (such as was entered in error).", 0, 1, this.active);
            }
            case 1281188563: {
                return new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory);
            }
            case -1928370289: {
                return new Property("serviceType", "CodeableConcept", "The specific service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceType);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case 92645877: {
                return new Property(SP_ACTOR, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "Slots that reference this schedule resource provide the availability details to these referenced resource(s).", 0, Integer.MAX_VALUE, this.actor);
            }
            case -1718507650: {
                return new Property("planningHorizon", "Period", "The period of time that the slots that reference this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates.", 0, 1, this.planningHorizon);
            }
            case 950398559: {
                return new Property("comment", "string", "Comments on the availability to describe any extended information. Such as custom constraints on the slots that may be associated.", 0, 1, this.comment);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 1281188563: {
                return this.serviceCategory == null ? new Base[]{} : this.serviceCategory.toArray(new Base[this.serviceCategory.size()]);
            }
            case -1928370289: {
                return this.serviceType == null ? new Base[]{} : this.serviceType.toArray(new Base[this.serviceType.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 92645877: {
                return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
            }
            case -1718507650: {
                Base[] baseArray;
                if (this.planningHorizon == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.planningHorizon;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.comment;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case 1281188563: {
                this.getServiceCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1928370289: {
                this.getServiceType().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(this.castToCodeableConcept(value));
                return value;
            }
            case 92645877: {
                this.getActor().add(this.castToReference(value));
                return value;
            }
            case -1718507650: {
                this.planningHorizon = this.castToPeriod(value);
                return value;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals("serviceCategory")) {
            this.getServiceCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals("serviceType")) {
            this.getServiceType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_ACTOR)) {
            this.getActor().add(this.castToReference(value));
        } else if (name.equals("planningHorizon")) {
            this.planningHorizon = this.castToPeriod(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 1281188563: {
                return this.addServiceCategory();
            }
            case -1928370289: {
                return this.addServiceType();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 92645877: {
                return this.addActor();
            }
            case -1718507650: {
                return this.getPlanningHorizon();
            }
            case 950398559: {
                return this.getCommentElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 1281188563: {
                return new String[]{"CodeableConcept"};
            }
            case -1928370289: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case 92645877: {
                return new String[]{"Reference"};
            }
            case -1718507650: {
                return new String[]{"Period"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Schedule.active");
        }
        if (name.equals("serviceCategory")) {
            return this.addServiceCategory();
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals(SP_ACTOR)) {
            return this.addActor();
        }
        if (name.equals("planningHorizon")) {
            this.planningHorizon = new Period();
            return this.planningHorizon;
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Schedule.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Schedule";
    }

    @Override
    public Schedule copy() {
        Schedule dst = new Schedule();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Schedule dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.serviceCategory != null) {
            dst.serviceCategory = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.serviceCategory) {
                dst.serviceCategory.add(codeableConcept.copy());
            }
        }
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.serviceType) {
                dst.serviceType.add(codeableConcept.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialty) {
                dst.specialty.add(codeableConcept.copy());
            }
        }
        if (this.actor != null) {
            dst.actor = new ArrayList<Reference>();
            for (Reference reference : this.actor) {
                dst.actor.add(reference.copy());
            }
        }
        dst.planningHorizon = this.planningHorizon == null ? null : this.planningHorizon.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
    }

    protected Schedule typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Schedule)) {
            return false;
        }
        Schedule o = (Schedule)other_;
        return Schedule.compareDeep(this.identifier, o.identifier, true) && Schedule.compareDeep(this.active, o.active, true) && Schedule.compareDeep(this.serviceCategory, o.serviceCategory, true) && Schedule.compareDeep(this.serviceType, o.serviceType, true) && Schedule.compareDeep(this.specialty, o.specialty, true) && Schedule.compareDeep(this.actor, o.actor, true) && Schedule.compareDeep(this.planningHorizon, o.planningHorizon, true) && Schedule.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Schedule)) {
            return false;
        }
        Schedule o = (Schedule)other_;
        return Schedule.compareValues(this.active, o.active, true) && Schedule.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.active, this.serviceCategory, this.serviceType, this.specialty, this.actor, this.planningHorizon, this.comment);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Schedule;
    }
}

