/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class BasicAuthInterceptor
implements IClientInterceptor {
    private String myUsername;
    private String myPassword;
    private String myHeaderValue;

    public BasicAuthInterceptor(String theUsername, String thePassword) {
        this(StringUtils.defaultString(theUsername) + ":" + StringUtils.defaultString(thePassword));
    }

    public BasicAuthInterceptor(String theCredentialString) {
        Validate.notBlank(theCredentialString, "theCredentialString must not be null or blank", new Object[0]);
        Validate.isTrue(theCredentialString.contains(":"), "theCredentialString must be in the format 'username:password'", new Object[0]);
        String encoded = Base64.encodeBase64String(theCredentialString.getBytes(Constants.CHARSET_US_ASCII));
        this.myHeaderValue = "Basic " + encoded;
    }

    @Override
    public void interceptRequest(IHttpRequest theRequest) {
        theRequest.addHeader("Authorization", this.myHeaderValue);
    }

    @Override
    public void interceptResponse(IHttpResponse theResponse) throws IOException {
    }
}

