/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhir;

import au.csiro.pathling.config.TerminologyAuthConfiguration;
import au.csiro.pathling.config.TerminologyConfiguration;
import au.csiro.pathling.fhir.ClientAuthInterceptor;
import au.csiro.pathling.fhir.DefaultTerminologyClient;
import au.csiro.pathling.fhir.UserAgentInterceptor;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.HttpClient;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TerminologyClient {
    public static final Logger log = LoggerFactory.getLogger(TerminologyClient.class);

    @Operation(name="$validate-code", type=ValueSet.class, idempotent=true)
    @Nonnull
    public Parameters validateCode(@Nonnull @OperationParam(name="url") UriType var1, @Nonnull @OperationParam(name="system") UriType var2, @Nullable @OperationParam(name="systemVersion") StringType var3, @Nonnull @OperationParam(name="code") CodeType var4);

    public IOperationUntypedWithInput<Parameters> buildValidateCode(@Nonnull UriType var1, @Nonnull UriType var2, @Nullable StringType var3, @Nonnull CodeType var4);

    @Operation(name="$translate", type=CodeSystem.class, idempotent=true)
    @Nonnull
    public Parameters translate(@Nonnull @OperationParam(name="url") UriType var1, @Nonnull @OperationParam(name="system") UriType var2, @Nullable @OperationParam(name="version") StringType var3, @Nonnull @OperationParam(name="code") CodeType var4, @Nullable @OperationParam(name="reverse") BooleanType var5, @Nullable @OperationParam(name="target") UriType var6);

    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildTranslate(@Nonnull UriType var1, @Nonnull UriType var2, @Nullable StringType var3, @Nonnull CodeType var4, @Nullable BooleanType var5, @Nullable UriType var6);

    @Operation(name="$subsumes", type=CodeSystem.class, idempotent=true)
    @Nonnull
    public Parameters subsumes(@Nonnull @OperationParam(name="codeA") CodeType var1, @Nonnull @OperationParam(name="codeB") CodeType var2, @Nonnull @OperationParam(name="system") UriType var3, @Nullable @OperationParam(name="version") StringType var4);

    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildSubsumes(@Nonnull CodeType var1, @Nonnull CodeType var2, @Nonnull UriType var3, @Nullable StringType var4);

    @Operation(name="$lookup", type=CodeSystem.class, idempotent=true)
    @Nonnull
    public Parameters lookup(@Nonnull @OperationParam(name="system") UriType var1, @Nullable @OperationParam(name="version") StringType var2, @Nonnull @OperationParam(name="code") CodeType var3, @Nullable @OperationParam(name="property") CodeType var4);

    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildLookup(@Nonnull UriType var1, @Nullable StringType var2, @Nonnull CodeType var3, @Nullable CodeType var4);

    public static TerminologyClient build(@Nonnull FhirContext fhirContext, @Nonnull TerminologyConfiguration terminologyConfiguration, @Nonnull HttpClient httpClient) {
        TerminologyAuthConfiguration authConfig;
        IRestfulClientFactory restfulClientFactory = fhirContext.getRestfulClientFactory();
        restfulClientFactory.setHttpClient(httpClient);
        restfulClientFactory.setServerValidationMode(ServerValidationModeEnum.NEVER);
        IGenericClient genericClient = restfulClientFactory.newGenericClient(terminologyConfiguration.getServerUrl());
        genericClient.registerInterceptor(new UserAgentInterceptor());
        if (terminologyConfiguration.isVerboseLogging()) {
            LoggingInterceptor verboseLogging = TerminologyClient.buildVerboseLogging();
            genericClient.registerInterceptor(verboseLogging);
        }
        if ((authConfig = terminologyConfiguration.getAuthentication()).isEnabled()) {
            genericClient.registerInterceptor(new ClientAuthInterceptor(authConfig));
        }
        return new DefaultTerminologyClient(genericClient);
    }

    @Nonnull
    private static LoggingInterceptor buildVerboseLogging() {
        LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
        loggingInterceptor.setLogger(log);
        loggingInterceptor.setLogRequestSummary(true);
        loggingInterceptor.setLogResponseSummary(true);
        loggingInterceptor.setLogRequestHeaders(true);
        loggingInterceptor.setLogResponseHeaders(true);
        loggingInterceptor.setLogRequestBody(true);
        loggingInterceptor.setLogResponseBody(true);
        return loggingInterceptor;
    }
}

