"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TailscaleLambdaExtension = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * A Lambda Layer that contains the Tailscale extension. It starts the Tailscale daemon and connects to the Tailscale
 * network exposing a SOCKS5 proxy on port 1050 (`socks://localhost:1055`) to be accessed by the main Lambda runtime
 * process.
 *
 * The Lambda function using this layer requires the following Environment Variables:
 * - `TS_SECRET_API_KEY` - The name of the AWS Secrets Manager secret that contains the Tailscale API Key.
 * - `TS_HOSTNAME` - The "Machine" name as shown in the Tailscale admin console.
 */
class TailscaleLambdaExtension extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.layer = new lambda.LayerVersion(scope, 'tailscale-extension', {
            ...props?.options,
            code: lambda.Code.fromAsset('tailscale-extension'),
            compatibleArchitectures: [lambda.Architecture.X86_64],
        });
    }
}
exports.TailscaleLambdaExtension = TailscaleLambdaExtension;
_a = JSII_RTTI_SYMBOL_1;
TailscaleLambdaExtension[_a] = { fqn: "tailscale-lambda-extension.TailscaleLambdaExtension", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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