# coding: utf-8

"""
    Getir-Locals Integration Swagger Documentation

    This documentation is created by Getir Developers for Getir-Locals Integration.For this integration, you need to take CLIENT NAME and CLIENT SECRET keys from Getir-dev team and use these keys for authentication. You also need to use access token provided after successful login to be able to use all other endpoints  You can view information about the active order through /orders/unapproved endpoints. The status of the order is managed via verify, prepare, handover and cancel endpoints. Details on order management are as follows:  For orders to be made by the Getir courier, the flow is as follows:  Supplier confirms order --verify<br />Supplier prepares order --prepare (1-2 minutes must pass before delivery)<br />Supplier hands over the order to Getir courier --handover<br />For Getir delivery, transactions are made by the Getir courier after handover.  A valid reason will be requested from the supplier to cancel an order. Valid reasons may vary depending on the instant status of the order. For this reason, before canceling an order, you have to get instant valid order cancellation reasons from /orders/{orderId}/cancel-options endpoint.   # noqa: E501

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class OrdersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_options(self, order_id, **kwargs):  # noqa: E501
        """This method is used to select cancel reasons according to delivery option.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_options(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :return: ApiResponseListCancelOptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_options_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_options_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def cancel_options_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """This method is used to select cancel reasons according to delivery option.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_options_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :return: ApiResponseListCancelOptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `cancel_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}/cancel-options', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseListCancelOptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_order(self, body, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used to cancel  the order.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order(body, order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CancelOrderRequest body: (required)
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_order_with_http_info(body, order_id, shop_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_order_with_http_info(body, order_id, shop_id, **kwargs)  # noqa: E501
            return data

    def cancel_order_with_http_info(self, body, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used to cancel  the order.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order_with_http_info(body, order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CancelOrderRequest body: (required)
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'order_id', 'shop_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cancel_order`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `cancel_order`")  # noqa: E501
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `cancel_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501
        if 'shop_id' in params:
            path_params['shopId'] = params['shop_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}/shop/{shopId}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancelled_orders(self, shop_id, **kwargs):  # noqa: E501
        """It is used to get the list of cancelled orders by shop.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancelled_orders(shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shop_id: (required)
        :param date _date:
        :return: ApiResponseListOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancelled_orders_with_http_info(shop_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancelled_orders_with_http_info(shop_id, **kwargs)  # noqa: E501
            return data

    def cancelled_orders_with_http_info(self, shop_id, **kwargs):  # noqa: E501
        """It is used to get the list of cancelled orders by shop.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancelled_orders_with_http_info(shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shop_id: (required)
        :param date _date:
        :return: ApiResponseListOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['shop_id', '_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancelled_orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `cancelled_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'shop_id' in params:
            query_params.append(('shopId', params['shop_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/cancelled', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseListOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deliver_order(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used for the delivery of the prepared order.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deliver_order(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deliver_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
        else:
            (data) = self.deliver_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
            return data

    def deliver_order_with_http_info(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used for the delivery of the prepared order.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deliver_order_with_http_info(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'shop_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deliver_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `deliver_order`")  # noqa: E501
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `deliver_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501
        if 'shop_id' in params:
            path_params['shopId'] = params['shop_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}/shop/{shopId}/deliver', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order(self, order_id, **kwargs):  # noqa: E501
        """This method is used to get details of an order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :return: ArtisanOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def get_order_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """This method is used to get details of an order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :return: ArtisanOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `get_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtisanOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_report(self, start_date, end_date, shop_id, page, page_size, **kwargs):  # noqa: E501
        """It is used to get the list of orders by shopIds,startDate and endDate.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_report(start_date, end_date, shop_id, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Date format pattern is \"yyyy-MM-dd\". (required)
        :param str end_date: Date format pattern is \"yyyy-MM-dd\". (required)
        :param str shop_id: (required)
        :param float page: (required)
        :param float page_size: (required)
        :return: ApiResponseOrderReportResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_report_with_http_info(start_date, end_date, shop_id, page, page_size, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_report_with_http_info(start_date, end_date, shop_id, page, page_size, **kwargs)  # noqa: E501
            return data

    def get_order_report_with_http_info(self, start_date, end_date, shop_id, page, page_size, **kwargs):  # noqa: E501
        """It is used to get the list of orders by shopIds,startDate and endDate.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_report_with_http_info(start_date, end_date, shop_id, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Date format pattern is \"yyyy-MM-dd\". (required)
        :param str end_date: Date format pattern is \"yyyy-MM-dd\". (required)
        :param str shop_id: (required)
        :param float page: (required)
        :param float page_size: (required)
        :return: ApiResponseOrderReportResponseWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'end_date', 'shop_id', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'start_date' is set
        if ('start_date' not in params or
                params['start_date'] is None):
            raise ValueError("Missing the required parameter `start_date` when calling `get_order_report`")  # noqa: E501
        # verify the required parameter 'end_date' is set
        if ('end_date' not in params or
                params['end_date'] is None):
            raise ValueError("Missing the required parameter `end_date` when calling `get_order_report`")  # noqa: E501
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `get_order_report`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_order_report`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_order_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'shop_id' in params:
            query_params.append(('shopId', params['shop_id']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseOrderReportResponseWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handover_order(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used for the delivery of the prepared order to the courier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handover_order(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handover_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
        else:
            (data) = self.handover_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
            return data

    def handover_order_with_http_info(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used for the delivery of the prepared order to the courier.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handover_order_with_http_info(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'shop_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handover_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `handover_order`")  # noqa: E501
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `handover_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501
        if 'shop_id' in params:
            path_params['shopId'] = params['shop_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}/shop/{shopId}/handover', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def prepare_order(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used to change the prepared order to the prepared status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prepare_order(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :param PreparedOrderRequest body:
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.prepare_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
        else:
            (data) = self.prepare_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
            return data

    def prepare_order_with_http_info(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used to change the prepared order to the prepared status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prepare_order_with_http_info(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :param PreparedOrderRequest body:
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'shop_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method prepare_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `prepare_order`")  # noqa: E501
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `prepare_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501
        if 'shop_id' in params:
            path_params['shopId'] = params['shop_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}/shop/{shopId}/prepare', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_invoice(self, order_id, **kwargs):  # noqa: E501
        """This method is used to send the order's invoice to the client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invoice(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param InvoiceRequest body:
        :return: ApiResponseVoid
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_invoice_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_invoice_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def send_invoice_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """This method is used to send the order's invoice to the client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invoice_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param InvoiceRequest body:
        :return: ApiResponseVoid
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `send_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}/invoice-link', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseVoid',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unapproved_orders(self, shop_id, **kwargs):  # noqa: E501
        """It is used to get the list of unapproved orders by shop.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unapproved_orders(shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shop_id: (required)
        :return: ApiResponseListOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unapproved_orders_with_http_info(shop_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unapproved_orders_with_http_info(shop_id, **kwargs)  # noqa: E501
            return data

    def unapproved_orders_with_http_info(self, shop_id, **kwargs):  # noqa: E501
        """It is used to get the list of unapproved orders by shop.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unapproved_orders_with_http_info(shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shop_id: (required)
        :return: ApiResponseListOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['shop_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unapproved_orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `unapproved_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'shop_id' in params:
            query_params.append(('shopId', params['shop_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/unapproved', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseListOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_order(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used to approve the incoming order by the shop  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_order(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
        else:
            (data) = self.verify_order_with_http_info(order_id, shop_id, **kwargs)  # noqa: E501
            return data

    def verify_order_with_http_info(self, order_id, shop_id, **kwargs):  # noqa: E501
        """This method is used to approve the incoming order by the shop  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_order_with_http_info(order_id, shop_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: (required)
        :param str shop_id: (required)
        :return: ApiResponseObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'shop_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `verify_order`")  # noqa: E501
        # verify the required parameter 'shop_id' is set
        if ('shop_id' not in params or
                params['shop_id'] is None):
            raise ValueError("Missing the required parameter `shop_id` when calling `verify_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['orderId'] = params['order_id']  # noqa: E501
        if 'shop_id' in params:
            path_params['shopId'] = params['shop_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/orders/{orderId}/shop/{shopId}/verify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseObject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
