# swagger-client
This documentation is created by Getir Developers for Getir-Locals Integration.For this integration, you need to take CLIENT NAME and CLIENT SECRET keys from Getir-dev team and use these keys for authentication. You also need to use access token provided after successful login to be able to use all other endpoints  You can view information about the active order through /orders/unapproved endpoints. The status of the order is managed via verify, prepare, handover and cancel endpoints. Details on order management are as follows:  For orders to be made by the Getir courier, the flow is as follows:  Supplier confirms order --verify<br />Supplier prepares order --prepare (1-2 minutes must pass before delivery)<br />Supplier hands over the order to Getir courier --handover<br />For Getir delivery, transactions are made by the Getir courier after handover.  A valid reason will be requested from the supplier to cancel an order. Valid reasons may vary depending on the instant status of the order. For this reason, before canceling an order, you have to get instant valid order cancellation reasons from /orders/{orderId}/cancel-options endpoint. 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import swagger_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint
# Configure HTTP basic authorization: basicAuth
configuration = swagger_client.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = swagger_client.AuthApi(swagger_client.ApiClient(configuration))

try:
    # This endpoint is used to get a token for authentication.
    api_response = api_instance.login()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->login: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://locals-integration-api-gateway.artisandev.getirapi.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**login**](docs/AuthApi.md#login) | **POST** /v1/auth/token | This endpoint is used to get a token for authentication.
*HealthApi* | [**health_check**](docs/HealthApi.md#health_check) | **GET** /health | Health Check for Getir Infrastructure
*OrdersApi* | [**cancel_options**](docs/OrdersApi.md#cancel_options) | **GET** /v1/orders/{orderId}/cancel-options | This method is used to select cancel reasons according to delivery option.
*OrdersApi* | [**cancel_order**](docs/OrdersApi.md#cancel_order) | **POST** /v1/orders/{orderId}/shop/{shopId}/cancel | This method is used to cancel  the order.
*OrdersApi* | [**cancelled_orders**](docs/OrdersApi.md#cancelled_orders) | **GET** /v1/orders/cancelled | It is used to get the list of cancelled orders by shop.
*OrdersApi* | [**deliver_order**](docs/OrdersApi.md#deliver_order) | **POST** /v1/orders/{orderId}/shop/{shopId}/deliver | This method is used for the delivery of the prepared order.
*OrdersApi* | [**get_order**](docs/OrdersApi.md#get_order) | **GET** /v1/orders/{orderId} | This method is used to get details of an order
*OrdersApi* | [**get_order_report**](docs/OrdersApi.md#get_order_report) | **GET** /v1/orders/report | It is used to get the list of orders by shopIds,startDate and endDate.
*OrdersApi* | [**handover_order**](docs/OrdersApi.md#handover_order) | **POST** /v1/orders/{orderId}/shop/{shopId}/handover | This method is used for the delivery of the prepared order to the courier.
*OrdersApi* | [**prepare_order**](docs/OrdersApi.md#prepare_order) | **POST** /v1/orders/{orderId}/shop/{shopId}/prepare | This method is used to change the prepared order to the prepared status
*OrdersApi* | [**send_invoice**](docs/OrdersApi.md#send_invoice) | **POST** /v1/orders/{orderId}/invoice-link | This method is used to send the order&#x27;s invoice to the client
*OrdersApi* | [**unapproved_orders**](docs/OrdersApi.md#unapproved_orders) | **GET** /v1/orders/unapproved | It is used to get the list of unapproved orders by shop.
*OrdersApi* | [**verify_order**](docs/OrdersApi.md#verify_order) | **POST** /v1/orders/{orderId}/shop/{shopId}/verify | This method is used to approve the incoming order by the shop
*ProductsApi* | [**get_batch_request_result**](docs/ProductsApi.md#get_batch_request_result) | **GET** /v1/products/price-and-quantity/batch-requests/{batchRequestId} | Get products update result with using batchRequestId
*ProductsApi* | [**get_chain_products**](docs/ProductsApi.md#get_chain_products) | **GET** /v1/products | Product integration allows you to list information such as stock, price, brand of seller&#x27;s listings.
*ProductsApi* | [**get_chain_productsby_chain_id**](docs/ProductsApi.md#get_chain_productsby_chain_id) | **GET** /v1/chains/{chainId}/products | This method is used to get products by chain id.
*ProductsApi* | [**get_shop_productsby_shop_id**](docs/ProductsApi.md#get_shop_productsby_shop_id) | **GET** /v1/shops/{shopId}/products | This method is used to get products by shop id.
*ProductsApi* | [**update_price_and_quantity**](docs/ProductsApi.md#update_price_and_quantity) | **PUT** /v1/products/price-and-quantity | Update price and quantity of products
*ShopsApi* | [**get_shop**](docs/ShopsApi.md#get_shop) | **GET** /v1/shops/{shopId} | It is used to get the shop informations.
*ShopsApi* | [**update_shop_courier_working_status**](docs/ShopsApi.md#update_shop_courier_working_status) | **PUT** /v1/shops/{shopId}/couriers/working-status | It is used to put the shops couiers working status.
*ShopsApi* | [**update_shop_working_hours**](docs/ShopsApi.md#update_shop_working_hours) | **PUT** /v1/shops/{shopId}/working-hours | It is used to put the shops working hours.
*ShopsApi* | [**update_shop_working_status**](docs/ShopsApi.md#update_shop_working_status) | **PUT** /v1/shops/{shopId}/working-status | It is used to put the shops working status.
*SupplierApi* | [**get_supplier**](docs/SupplierApi.md#get_supplier) | **GET** /v1/suppliers/supplier | get supplier data.
*SupplierApi* | [**reset_password**](docs/SupplierApi.md#reset_password) | **PUT** /v1/suppliers/password/reset | Shops can reset the password they use via this endpoint and create a new password.

## Documentation For Models

 - [ApiResponseAuthenticationResponse](docs/ApiResponseAuthenticationResponse.md)
 - [ApiResponseGetShopResponse](docs/ApiResponseGetShopResponse.md)
 - [ApiResponseListCancelOptionResponse](docs/ApiResponseListCancelOptionResponse.md)
 - [ApiResponseListOrderResponse](docs/ApiResponseListOrderResponse.md)
 - [ApiResponseObject](docs/ApiResponseObject.md)
 - [ApiResponseOrderReportResponse](docs/ApiResponseOrderReportResponse.md)
 - [ApiResponseOrderReportResponseWrapper](docs/ApiResponseOrderReportResponseWrapper.md)
 - [ApiResponsePageableResponseShopProductsResponse](docs/ApiResponsePageableResponseShopProductsResponse.md)
 - [ApiResponsePageableResponseShopProductsResponseData](docs/ApiResponsePageableResponseShopProductsResponseData.md)
 - [ApiResponsePriceAndQuantityBatchResponse](docs/ApiResponsePriceAndQuantityBatchResponse.md)
 - [ApiResponsePriceAndQuantityBatchResponseWrapper](docs/ApiResponsePriceAndQuantityBatchResponseWrapper.md)
 - [ApiResponseProductBatchTicketResponse](docs/ApiResponseProductBatchTicketResponse.md)
 - [ApiResponseShopCouriersWorkingStatusResponse](docs/ApiResponseShopCouriersWorkingStatusResponse.md)
 - [ApiResponseShopWorkingHoursResponse](docs/ApiResponseShopWorkingHoursResponse.md)
 - [ApiResponseVoid](docs/ApiResponseVoid.md)
 - [ArtisanOrderResponse](docs/ArtisanOrderResponse.md)
 - [AuthenticationResponse](docs/AuthenticationResponse.md)
 - [CancelOptionResponse](docs/CancelOptionResponse.md)
 - [CancelOrderRequest](docs/CancelOrderRequest.md)
 - [CustomerResponse](docs/CustomerResponse.md)
 - [FieldValidation](docs/FieldValidation.md)
 - [GeneralError](docs/GeneralError.md)
 - [GeneralErrorWrapper](docs/GeneralErrorWrapper.md)
 - [GetShopResponse](docs/GetShopResponse.md)
 - [HealthResponse](docs/HealthResponse.md)
 - [InternalError](docs/InternalError.md)
 - [InternalErrorWrapper](docs/InternalErrorWrapper.md)
 - [InvoiceAddressResponse](docs/InvoiceAddressResponse.md)
 - [InvoiceRequest](docs/InvoiceRequest.md)
 - [MenuOptionsResponse](docs/MenuOptionsResponse.md)
 - [Model5001InternalError](docs/Model5001InternalError.md)
 - [NameResponse](docs/NameResponse.md)
 - [OperationResult](docs/OperationResult.md)
 - [OrderDtoResponse](docs/OrderDtoResponse.md)
 - [OrderResponse](docs/OrderResponse.md)
 - [PageSizeInvalidError](docs/PageSizeInvalidError.md)
 - [PageSizeInvalidErrorMeta](docs/PageSizeInvalidErrorMeta.md)
 - [PageableResponseSupplierProductResponse](docs/PageableResponseSupplierProductResponse.md)
 - [PasswordResetRequest](docs/PasswordResetRequest.md)
 - [PaymentMethodTextResponse](docs/PaymentMethodTextResponse.md)
 - [PreparedOrderRequest](docs/PreparedOrderRequest.md)
 - [PriceAndQuantityBatchProductResponse](docs/PriceAndQuantityBatchProductResponse.md)
 - [ProductBatchRequest](docs/ProductBatchRequest.md)
 - [ProductBatchTicketResponse](docs/ProductBatchTicketResponse.md)
 - [ProductRequest](docs/ProductRequest.md)
 - [ProductResponse](docs/ProductResponse.md)
 - [ShopCouriersWorkingStatusResponse](docs/ShopCouriersWorkingStatusResponse.md)
 - [ShopProductsResponse](docs/ShopProductsResponse.md)
 - [ShopWorkingHoursResponse](docs/ShopWorkingHoursResponse.md)
 - [SupplierDataChainResponse](docs/SupplierDataChainResponse.md)
 - [SupplierDataResponse](docs/SupplierDataResponse.md)
 - [SupplierDataResponseWrapper](docs/SupplierDataResponseWrapper.md)
 - [SupplierDataShopResponse](docs/SupplierDataShopResponse.md)
 - [SupplierProductResponse](docs/SupplierProductResponse.md)
 - [UpdateShopCouriersStatusRequest](docs/UpdateShopCouriersStatusRequest.md)
 - [UpdateShopStatusRequest](docs/UpdateShopStatusRequest.md)
 - [UpdateShopWorkingHoursRequest](docs/UpdateShopWorkingHoursRequest.md)
 - [UpdatedProduct](docs/UpdatedProduct.md)

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication

## bearerAuth



## Author


