The energy ecosystem must implement an architecture which can scale in data-type, volume and connectivity, across use-cases, organisational and logistical boundaries, sectors and jurisdictions. It must deliver this in a secure, safe, robust and adaptable environment which addresses governance.

Data users are diverse: from asset managers to [Distribution Network Operators](https://en.wikipedia.org/wiki/Distribution_network_operator) (DNOs) to consumers. Our research has confirmed:

1. User needs are diverse, encompassing thousands of organisations, customers and society as a whole.
2. There is no ‘single data platform’ approach that will (or should) address all needs.
3. There is a material risk to implementation unless governance is addressed.

Centralised data architectures have not scaled effectively in any sector. Interviewees expressed the need for a clear roadmap to transition from a fragmented data landscape to a robust, decentralised, federated data infrastructure. They believed that “there can be no single platform for all data and use-cases” and “there will be significant barriers to adoption around the centralisation of commercial data”. With Presumed Open as a guiding principle, we must also apply the precautionary principle to innovation to address potential unintended consequences (e.g. unexpected monopolies). 

The architectural approach to developing domain-specific platforms, hubs, analytic networks, asset registries, catalogues, systems maps and so on requires a shift in thinking from ‘push’ to ‘pull’—as websites enable search engines to find and index them, a distributed architecture creates a dynamic market between data suppliers and consumers. This enables markets for many solutions including platforms, apps and related services, while control is retained at the organisational level.

We heard from dozens of experts that they see “no viable alternative” than to “address the upstream needs of data supply through an open, decentralised architecture with strong governance”. Further, “should that exist it would enable a multitude of solutions to emerge”.     

Fortunately, we have 30-years evidence of the most successful information architecture in history: the web. We believe the energy sector must now embrace a ‘web of data’ approach. 

We propose the development of an Open Governance Platform in concert with the market and regulators to establish a common approach to data-sharing, a cohesive and viable market architecture.

Our Phase One consultation process is summarised below. We will update with further details on this page as this programme develops.

[> Learn more](https://icebreakerone.org/energy/)