import os

from cryptography.exceptions import InvalidKey

from .exceptions import (
    InvalidTokenException,
    NoPrivateKeyException,
    BadlyFormattedTokenException,
    TokenExpiredException,
    PathMismatchException,
    MethodMismatchException,
)
from .token import RocketToken

# set some variable to use as keys when operating in dev mode
os.environ[
    "RT_DEV_PRIVATE"
] = "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"
os.environ[
    "RT_DEV_PUBLIC"
] = "LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQ0lqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FnOEFNSUlDQ2dLQ0FnRUEyN0c4YzM4cVdCY3YyTlhjMGZ6dApMU0pYd2lZUk9qSVpTcDBjVnN5WDVFSUVDdWgwQ3I2QkxuT0w1VEozZXEzcjlVczNvMkxnQlBtS0haV1ExL1NMCmxTSER1eDhPT0VIWGVvdmZtajkzc0UzbWp6YnU1aVp5aitKK0dIRjBHQTNRNFA3dm9jbkQxK3JkS2R3amNWK2UKNmp3NDFMcmIvN3RPZXphc1VEQlY4VWxZemF6ajZoU1FRZDE4Z2NLQkdqNnhscyt0TklLUUQ0L1k5N014QlJyNAozNURDZ1FVYm11cGo0UG1nWEo3UnlQaVNiaWt1b0NLUjg2MnlGNVZ3b1FOZHpnOVppcjJnbGV6RGpmWHo5bjh2ClMrNHhaVGUyam1Mb1NFSHVmZlFOaThRdlZlRFdVNldCMTJ1UGY5SEpMZjd4bUpiRHR0bkRSSFVIYzBsamM5OVMKY3VzWGlvZjBCQVI5NEcrbHR4R3RpellPNVljeHIzVTNSR054cUFBeFBjZDYxTTNxRmxxWEdza3RjSHNpTmRLQQoydE1OTjZzMncvMGI3aklDUHJHQmRpMUZoOHBEdWVZcmlubkF6VVFvRGVKMFFJQnpsN2NEYTUrcWJlUmcwMjc4CnF2T1N2bitLREQ4RlhlVlMvMDJFcXdiSzNNMXBDMWlQYTRWMkZMYVpxVk9OSjg4RE9wOXpBOE5ObDN6Q1QyWm0KcmduQnNJaGlVa2pPR1BKbDZoMmt1NFZKeHE4MmIzNGZGYndSdUgyVWQ4SFZWaFc2ckhPVTlQaUk4em1UWDBwdgpkaGp2NFBSK3AzQytrVEpyYmd0Y1IvdDRHS1h0Z2dzbFBoZktVQm4reHdRQTJFOGt0RHQwcFN2MHJTZUZJR1AzCi95WUVYNUdrTUl3MW1hZ2pxdE5tL1g4Q0F3RUFBUT09Ci0tLS0tRU5EIFBVQkxJQyBLRVktLS0tLQo="

__all__ = [
    RocketToken,
    InvalidTokenException,
    NoPrivateKeyException,
    InvalidKey,
    BadlyFormattedTokenException,
    TokenExpiredException,
    PathMismatchException,
    MethodMismatchException,
]
