# Generated by Django 3.2.5 on 2021-07-29 19:44

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import sage_session.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Session',
            fields=[
                ('session_key', models.CharField(max_length=40, primary_key=True, serialize=False, verbose_name='session key')),
                ('session_data', models.TextField(verbose_name='session data')),
                ('expire_date', models.DateTimeField(db_index=True, verbose_name='expire date')),
                ('user_agent', models.CharField(blank=True, max_length=200, null=True, verbose_name='User Agent')),
                ('last_activity', models.DateTimeField(auto_now=True, verbose_name='Last Activity')),
                ('ip', models.GenericIPAddressField(blank=True, null=True, verbose_name='IP')),
                ('location', models.CharField(blank=True, max_length=50, null=True, verbose_name='Location')),
                ('device_brand', models.CharField(blank=True, max_length=50, null=True, verbose_name='Device Brand')),
                ('device_model', models.CharField(blank=True, max_length=50, null=True, verbose_name='Device Model')),
                ('browser', models.CharField(blank=True, max_length=50, null=True, verbose_name='Browser')),
                ('browser_version', models.CharField(blank=True, max_length=50, null=True, verbose_name='Browser Version')),
                ('os', models.CharField(blank=True, max_length=50, null=True, verbose_name='OS')),
                ('os_version', models.CharField(blank=True, max_length=50, null=True, verbose_name='OS Version')),
                ('is_mobile', models.BooleanField(default=False, verbose_name='Is mobile')),
                ('is_tablet', models.BooleanField(default=False, verbose_name='Is tablet')),
                ('is_touch_capable', models.BooleanField(default=False, verbose_name='Is touch capable')),
                ('is_pc', models.BooleanField(default=False, verbose_name='Is pc')),
                ('is_bot', models.BooleanField(default=False, verbose_name='Is bot')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'session',
                'verbose_name_plural': 'sessions',
                'abstract': False,
            },
            managers=[
                ('objects', sage_session.models.SessionManager()),
            ],
        ),
    ]
