# Generated by Django 3.0.7 on 2022-01-26 13:30

import ckeditor.fields
import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Mappableobject",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Mapping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=100)),
                ("type", models.CharField(max_length=100)),
                ("object_id", models.CharField(blank=True, max_length=100, null=True)),
                ("size", models.BigIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Profile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Team",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=100)),
                (
                    "date",
                    models.DateTimeField(
                        blank=True, default=datetime.datetime.now, null=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Tool",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=100, null=True)),
                ("connector", models.CharField(blank=True, max_length=100, null=True)),
                ("date_created", models.DateTimeField(blank=True, null=True)),
                (
                    "author",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Profile",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Assay",
            fields=[
                (
                    "mappableobject_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.Mappableobject",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", ckeditor.fields.RichTextField(blank=True, null=True)),
                ("date_created", models.DateTimeField(blank=True, null=True)),
                ("date_modified", models.DateTimeField(blank=True, null=True)),
            ],
            bases=("core.mappableobject",),
        ),
        migrations.CreateModel(
            name="Investigation",
            fields=[
                (
                    "mappableobject_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.Mappableobject",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", ckeditor.fields.RichTextField(blank=True, null=True)),
                ("date_created", models.DateTimeField(blank=True, null=True)),
                ("date_modified", models.DateTimeField(blank=True, null=True)),
            ],
            bases=("core.mappableobject",),
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                (
                    "mappableobject_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.Mappableobject",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", ckeditor.fields.RichTextField(blank=True, null=True)),
                ("date_created", models.DateTimeField(blank=True, null=True)),
                ("date_modified", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "permissions": (("manage_user", "Manage user"),),
            },
            bases=("core.mappableobject",),
        ),
        migrations.CreateModel(
            name="Toolparam",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("key", models.CharField(blank=True, max_length=100, null=True)),
                ("value", models.CharField(blank=True, max_length=2000, null=True)),
                (
                    "tool_id",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Tool",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="profile",
            name="team",
            field=models.ManyToManyField(blank=True, to="core.Team"),
        ),
        migrations.AddField(
            model_name="profile",
            name="user",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.CreateModel(
            name="MappingParam",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("key", models.CharField(blank=True, max_length=100, null=True)),
                ("value", models.CharField(blank=True, max_length=100, null=True)),
                (
                    "mapping_id",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Mapping",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="mapping",
            name="author",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Profile",
            ),
        ),
        migrations.AddField(
            model_name="mapping",
            name="foreign_id_obj",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Mappableobject",
            ),
        ),
        migrations.AddField(
            model_name="mapping",
            name="tool_id",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Tool",
            ),
        ),
        migrations.AddField(
            model_name="tool",
            name="project",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Project",
            ),
        ),
        migrations.CreateModel(
            name="Study",
            fields=[
                (
                    "mappableobject_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.Mappableobject",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", ckeditor.fields.RichTextField(blank=True, null=True)),
                ("date_created", models.DateTimeField(blank=True, null=True)),
                ("date_modified", models.DateTimeField(blank=True, null=True)),
                ("assays", models.ManyToManyField(blank=True, to="core.Assay")),
                (
                    "author",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="studies",
                        to="core.Profile",
                    ),
                ),
            ],
            bases=("core.mappableobject",),
        ),
        migrations.AddField(
            model_name="project",
            name="author",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Profile",
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="investigations",
            field=models.ManyToManyField(blank=True, to="core.Investigation"),
        ),
        migrations.CreateModel(
            name="MappingProjectUser",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        choices=[
                            ("administrator", "administrator"),
                            ("contributor", "contributor"),
                            ("collaborator", "collaborator"),
                        ],
                        default="administrator",
                        max_length=13,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Profile",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Project",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="investigation",
            name="author",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Profile",
            ),
        ),
        migrations.AddField(
            model_name="investigation",
            name="studies",
            field=models.ManyToManyField(blank=True, to="core.Study"),
        ),
        migrations.CreateModel(
            name="Image",
            fields=[
                (
                    "mappableobject_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.Mappableobject",
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=100)),
                (
                    "author",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Profile",
                    ),
                ),
            ],
            bases=("core.mappableobject",),
        ),
        migrations.CreateModel(
            name="Dataset",
            fields=[
                (
                    "mappableobject_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.Mappableobject",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", ckeditor.fields.RichTextField(blank=True, null=True)),
                ("date_created", models.DateTimeField(blank=True, null=True)),
                ("date_modified", models.DateTimeField(blank=True, null=True)),
                (
                    "author",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.Profile",
                    ),
                ),
            ],
            bases=("core.mappableobject",),
        ),
        migrations.AddField(
            model_name="assay",
            name="author",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.Profile",
            ),
        ),
        migrations.AddField(
            model_name="assay",
            name="datasets",
            field=models.ManyToManyField(blank=True, to="core.Dataset"),
        ),
    ]
