"""
    wallet-api

    API  # noqa: E501

    The version of the OpenAPI document: 2.1.524
    Contact: development@wallet.inc
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from wallet.api_client import ApiClient, Endpoint as _Endpoint
from wallet.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from wallet.model.agreement import Agreement
from wallet.model.auth_error import AuthError
from wallet.model.falsum_error import FalsumError
from wallet.model.imported_list import ImportedList
from wallet.model.imported_list_recipient import ImportedListRecipient
from wallet.model.inline_response2006 import InlineResponse2006
from wallet.model.inline_response2007 import InlineResponse2007
from wallet.model.inline_response2008 import InlineResponse2008
from wallet.model.internal_server_error import InternalServerError
from wallet.model.nano_id import NanoID
from wallet.model.opt_in_list import OptInList
from wallet.model.opt_in_list_source import OptInListSource
from wallet.model.opt_in_list_subscriber import OptInListSubscriber
from wallet.model.outbound_sms import OutboundSMS
from wallet.model.phone_number import PhoneNumber
from wallet.model.ss_imported_list_recipient_create_params import SSImportedListRecipientCreateParams
from wallet.model.static_voucher_campaign_broadcast import StaticVoucherCampaignBroadcast
from wallet.model.tcpa import Tcpa
from wallet.model.wt_count_result import WTCountResult
from wallet.model.wt_employee_import_records import WTEmployeeImportRecords
from wallet.model.wt_imported_list_recipient_from_membership_tier_import import WTImportedListRecipientFromMembershipTierImport
from wallet.model.wt_opt_in_list_creation_params import WTOptInListCreationParams
from wallet.model.wtsms_acquire_phone_number import WTSMSAcquirePhoneNumber
from wallet.model.wtsms_create_agreement import WTSMSCreateAgreement
from wallet.model.wtsms_import_opt_in_list_subscribers import WTSMSImportOptInListSubscribers
from wallet.model.wtsms_imported_list_create import WTSMSImportedListCreate
from wallet.model.wtsms_limits import WTSMSLimits
from wallet.model.wtsms_opt_in_list_source_create import WTSMSOptInListSourceCreate
from wallet.model.wtsms_update_phone_number_config import WTSMSUpdatePhoneNumberConfig


class SMSApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.acquire_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': (PhoneNumber,),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/acquire',
                'operation_id': 'acquire_phone_number',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wtsms_acquire_phone_number',
                ],
                'required': [
                    'wtsms_acquire_phone_number',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wtsms_acquire_phone_number':
                        (WTSMSAcquirePhoneNumber,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wtsms_acquire_phone_number': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.archive_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': (PhoneNumber,),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/{phoneNumberID}',
                'operation_id': 'archive_phone_number',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.archive_recipient_endpoint = _Endpoint(
            settings={
                'response_type': (ImportedListRecipient,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/{id}',
                'operation_id': 'archive_recipient',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (NanoID,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.count_imported_list_recipients_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/count/{listID}',
                'operation_id': 'count_imported_list_recipients',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'is_archive_included',
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'is_archive_included':
                        (bool,),
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                    'is_archive_included': 'isArchiveIncluded',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'list_id': 'path',
                    'is_archive_included': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.count_opt_in_list_subscribers_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInList/subscribers/count/{listID}',
                'operation_id': 'count_opt_in_list_subscribers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'is_subscribed',
                    'is_pending_age21_verification',
                    'is_archive_included',
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'is_subscribed':
                        (bool,),
                    'is_pending_age21_verification':
                        (bool,),
                    'is_archive_included':
                        (bool,),
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                    'is_subscribed': 'isSubscribed',
                    'is_pending_age21_verification': 'isPendingAge21Verification',
                    'is_archive_included': 'isArchiveIncluded',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'list_id': 'path',
                    'is_subscribed': 'query',
                    'is_pending_age21_verification': 'query',
                    'is_archive_included': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.count_opt_in_source_subscribers_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInSource/subscribers/count/{sourceID}',
                'operation_id': 'count_opt_in_source_subscribers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'is_subscribed',
                    'is_pending_age21_verification',
                    'is_archive_included',
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (NanoID,),
                    'is_subscribed':
                        (bool,),
                    'is_pending_age21_verification':
                        (bool,),
                    'is_archive_included':
                        (bool,),
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'source_id': 'sourceID',
                    'is_subscribed': 'isSubscribed',
                    'is_pending_age21_verification': 'isPendingAge21Verification',
                    'is_archive_included': 'isArchiveIncluded',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'source_id': 'path',
                    'is_subscribed': 'query',
                    'is_pending_age21_verification': 'query',
                    'is_archive_included': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.count_outbound_sms_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/sms/outbound/count/{phoneNumberID}',
                'operation_id': 'count_outbound_sms',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                    'to_phone_number',
                    'status',
                    'payment_object_broadcast_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                    'to_phone_number':
                        (str,),
                    'status':
                        (str,),
                    'payment_object_broadcast_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                    'to_phone_number': 'toPhoneNumber',
                    'status': 'status',
                    'payment_object_broadcast_id': 'paymentObjectBroadcastID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                    'to_phone_number': 'query',
                    'status': 'query',
                    'payment_object_broadcast_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_imported_list_endpoint = _Endpoint(
            settings={
                'response_type': (ImportedList,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList',
                'operation_id': 'create_imported_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wtsms_imported_list_create',
                ],
                'required': [
                    'wtsms_imported_list_create',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wtsms_imported_list_create':
                        (WTSMSImportedListCreate,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wtsms_imported_list_create': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_opt_in_list_endpoint = _Endpoint(
            settings={
                'response_type': (OptInList,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInList',
                'operation_id': 'create_opt_in_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_opt_in_list_creation_params',
                ],
                'required': [
                    'wt_opt_in_list_creation_params',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_opt_in_list_creation_params':
                        (WTOptInListCreationParams,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_opt_in_list_creation_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_opt_in_list_source_endpoint = _Endpoint(
            settings={
                'response_type': (OptInListSource,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInListSource',
                'operation_id': 'create_opt_in_list_source',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wtsms_opt_in_list_source_create',
                ],
                'required': [
                    'wtsms_opt_in_list_source_create',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wtsms_opt_in_list_source_create':
                        (WTSMSOptInListSourceCreate,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wtsms_opt_in_list_source_create': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_recipient_in_imported_list_endpoint = _Endpoint(
            settings={
                'response_type': (ImportedListRecipient,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/create',
                'operation_id': 'create_recipient_in_imported_list',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'ss_imported_list_recipient_create_params',
                ],
                'required': [
                    'ss_imported_list_recipient_create_params',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ss_imported_list_recipient_create_params':
                        (SSImportedListRecipientCreateParams,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'ss_imported_list_recipient_create_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sms_agreement_endpoint = _Endpoint(
            settings={
                'response_type': (Agreement,),
                'auth': [],
                'endpoint_path': '/v2/sms/agreement/create',
                'operation_id': 'create_sms_agreement',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wtsms_create_agreement',
                ],
                'required': [
                    'wtsms_create_agreement',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wtsms_create_agreement':
                        (WTSMSCreateAgreement,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wtsms_create_agreement': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.export_imported_list_recipients_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/export/{importedListID}',
                'operation_id': 'export_imported_list_recipients',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'imported_list_id',
                ],
                'required': [
                    'imported_list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'imported_list_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'imported_list_id': 'importedListID',
                },
                'location_map': {
                    'imported_list_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.export_opt_in_list_subscribers_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInList/subscribers/export/{listID}',
                'operation_id': 'export_opt_in_list_subscribers',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                ],
                'required': [
                    'list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                },
                'location_map': {
                    'list_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_blocked_tcpa_entries_endpoint = _Endpoint(
            settings={
                'response_type': ([Tcpa],),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/blocked/{phoneNumberID}',
                'operation_id': 'fetch_blocked_tcpa_entries',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_imported_list_recipients_endpoint = _Endpoint(
            settings={
                'response_type': ([ImportedListRecipient],),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/{listID}',
                'operation_id': 'fetch_imported_list_recipients',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                ],
                'required': [
                    'list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                },
                'location_map': {
                    'list_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_imported_list_recipients_by_page_endpoint = _Endpoint(
            settings={
                'response_type': (InlineResponse2008,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/page/{listID}',
                'operation_id': 'fetch_imported_list_recipients_by_page',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'page_size',
                    'page_num',
                    'is_archive_included',
                ],
                'required': [
                    'list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'page_size':
                        (float,),
                    'page_num':
                        (float,),
                    'is_archive_included':
                        (bool,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                    'page_size': 'pageSize',
                    'page_num': 'pageNum',
                    'is_archive_included': 'isArchiveIncluded',
                },
                'location_map': {
                    'list_id': 'path',
                    'page_size': 'query',
                    'page_num': 'query',
                    'is_archive_included': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_opt_in_list_sources_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInListSources/all',
                'operation_id': 'fetch_opt_in_list_sources',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'is_archive_included',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'is_archive_included':
                        (bool,),
                },
                'attribute_map': {
                    'is_archive_included': 'isArchiveIncluded',
                },
                'location_map': {
                    'is_archive_included': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_opt_in_list_subscribers_endpoint = _Endpoint(
            settings={
                'response_type': ([OptInListSubscriber],),
                'auth': [],
                'endpoint_path': '/v2/sms/optInList/subscribers/{listID}',
                'operation_id': 'fetch_opt_in_list_subscribers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'is_subscribed',
                    'is_pending_age21_verification',
                    'is_archive_included',
                ],
                'required': [
                    'list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'is_subscribed':
                        (bool,),
                    'is_pending_age21_verification':
                        (bool,),
                    'is_archive_included':
                        (bool,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                    'is_subscribed': 'isSubscribed',
                    'is_pending_age21_verification': 'isPendingAge21Verification',
                    'is_archive_included': 'isArchiveIncluded',
                },
                'location_map': {
                    'list_id': 'path',
                    'is_subscribed': 'query',
                    'is_pending_age21_verification': 'query',
                    'is_archive_included': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_opt_in_list_subscribers_by_page_endpoint = _Endpoint(
            settings={
                'response_type': (InlineResponse2007,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInList/subscribers/page/{listID}',
                'operation_id': 'fetch_opt_in_list_subscribers_by_page',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'page_size',
                    'page_num',
                    'is_subscribed',
                    'is_pending_age21_verification',
                    'is_archive_included',
                ],
                'required': [
                    'list_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'page_size':
                        (float,),
                    'page_num':
                        (float,),
                    'is_subscribed':
                        (bool,),
                    'is_pending_age21_verification':
                        (bool,),
                    'is_archive_included':
                        (bool,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                    'page_size': 'pageSize',
                    'page_num': 'pageNum',
                    'is_subscribed': 'isSubscribed',
                    'is_pending_age21_verification': 'isPendingAge21Verification',
                    'is_archive_included': 'isArchiveIncluded',
                },
                'location_map': {
                    'list_id': 'path',
                    'page_size': 'query',
                    'page_num': 'query',
                    'is_subscribed': 'query',
                    'is_pending_age21_verification': 'query',
                    'is_archive_included': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_opt_in_lists_associated_with_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': ([OptInList],),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/lists/{phoneNumberID}',
                'operation_id': 'fetch_opt_in_lists_associated_with_phone_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_opt_in_source_subscribers_endpoint = _Endpoint(
            settings={
                'response_type': ([OptInListSubscriber],),
                'auth': [],
                'endpoint_path': '/v2/sms/optInSource/subscribers/{sourceID}',
                'operation_id': 'fetch_opt_in_source_subscribers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'is_subscribed',
                    'is_pending_age21_verification',
                    'is_archive_included',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (NanoID,),
                    'is_subscribed':
                        (bool,),
                    'is_pending_age21_verification':
                        (bool,),
                    'is_archive_included':
                        (bool,),
                },
                'attribute_map': {
                    'source_id': 'sourceID',
                    'is_subscribed': 'isSubscribed',
                    'is_pending_age21_verification': 'isPendingAge21Verification',
                    'is_archive_included': 'isArchiveIncluded',
                },
                'location_map': {
                    'source_id': 'path',
                    'is_subscribed': 'query',
                    'is_pending_age21_verification': 'query',
                    'is_archive_included': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_opt_in_sources_associated_with_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': ([OptInListSource],),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/sources/{phoneNumberID}',
                'operation_id': 'fetch_opt_in_sources_associated_with_phone_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_outbound_sms_endpoint = _Endpoint(
            settings={
                'response_type': ([OutboundSMS],),
                'auth': [],
                'endpoint_path': '/v2/sms/outbound/{phoneNumberID}',
                'operation_id': 'fetch_outbound_sms',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                    'to_phone_number',
                    'status',
                    'payment_object_broadcast_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                    'to_phone_number':
                        (str,),
                    'status':
                        (str,),
                    'payment_object_broadcast_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                    'to_phone_number': 'toPhoneNumber',
                    'status': 'status',
                    'payment_object_broadcast_id': 'paymentObjectBroadcastID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                    'to_phone_number': 'query',
                    'status': 'query',
                    'payment_object_broadcast_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_outbound_smsby_page_endpoint = _Endpoint(
            settings={
                'response_type': (InlineResponse2006,),
                'auth': [],
                'endpoint_path': '/v2/sms/outbound/page/{phoneNumberID}',
                'operation_id': 'fetch_outbound_smsby_page',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                    'to_phone_number',
                    'payment_object_broadcast_id',
                    'page_size',
                    'page_num',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                    'to_phone_number':
                        (str,),
                    'payment_object_broadcast_id':
                        (NanoID,),
                    'page_size':
                        (float,),
                    'page_num':
                        (float,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                    'to_phone_number': 'toPhoneNumber',
                    'payment_object_broadcast_id': 'paymentObjectBroadcastID',
                    'page_size': 'pageSize',
                    'page_num': 'pageNum',
                },
                'location_map': {
                    'phone_number_id': 'path',
                    'to_phone_number': 'query',
                    'payment_object_broadcast_id': 'query',
                    'page_size': 'query',
                    'page_num': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_payment_object_broadcasts_endpoint = _Endpoint(
            settings={
                'response_type': ([StaticVoucherCampaignBroadcast],),
                'auth': [],
                'endpoint_path': '/v2/sms/paymentObjectBroadcasts/{phoneNumberID}',
                'operation_id': 'fetch_payment_object_broadcasts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_sms_agreement_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/sms/agreement',
                'operation_id': 'fetch_sms_agreement',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.import_imported_list_recipients_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/import/{importedListID}',
                'operation_id': 'import_imported_list_recipients',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'imported_list_id',
                    'wt_employee_import_records',
                ],
                'required': [
                    'imported_list_id',
                    'wt_employee_import_records',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'imported_list_id':
                        (NanoID,),
                    'wt_employee_import_records':
                        (WTEmployeeImportRecords,),
                },
                'attribute_map': {
                    'imported_list_id': 'importedListID',
                },
                'location_map': {
                    'imported_list_id': 'path',
                    'wt_employee_import_records': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.import_imported_list_recipients_from_membership_tier_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/import-from-tier',
                'operation_id': 'import_imported_list_recipients_from_membership_tier',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_imported_list_recipient_from_membership_tier_import',
                ],
                'required': [
                    'wt_imported_list_recipient_from_membership_tier_import',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_imported_list_recipient_from_membership_tier_import':
                        (WTImportedListRecipientFromMembershipTierImport,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_imported_list_recipient_from_membership_tier_import': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.import_opt_in_list_subscribers_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInList/subscribers/import/{listID}',
                'operation_id': 'import_opt_in_list_subscribers',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'wtsms_import_opt_in_list_subscribers',
                ],
                'required': [
                    'list_id',
                    'wtsms_import_opt_in_list_subscribers',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'wtsms_import_opt_in_list_subscribers':
                        (WTSMSImportOptInListSubscribers,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                },
                'location_map': {
                    'list_id': 'path',
                    'wtsms_import_opt_in_list_subscribers': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.restore_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': (PhoneNumber,),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/{phoneNumberID}',
                'operation_id': 'restore_phone_number',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                ],
                'required': [
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.restore_recipient_endpoint = _Endpoint(
            settings={
                'response_type': (ImportedListRecipient,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/recipients/{id}',
                'operation_id': 'restore_recipient',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (NanoID,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_sent_and_max_count_of_messages_endpoint = _Endpoint(
            settings={
                'response_type': (WTSMSLimits,),
                'auth': [],
                'endpoint_path': '/v2/sms/sent',
                'operation_id': 'retrieve_sent_and_max_count_of_messages',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.save_imported_list_endpoint = _Endpoint(
            settings={
                'response_type': (ImportedList,),
                'auth': [],
                'endpoint_path': '/v2/sms/importedList/{listID}',
                'operation_id': 'save_imported_list',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'wtsms_imported_list_create',
                ],
                'required': [
                    'list_id',
                    'wtsms_imported_list_create',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'wtsms_imported_list_create':
                        (WTSMSImportedListCreate,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                },
                'location_map': {
                    'list_id': 'path',
                    'wtsms_imported_list_create': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.save_opt_in_list_endpoint = _Endpoint(
            settings={
                'response_type': (OptInList,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInList/{listID}',
                'operation_id': 'save_opt_in_list',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'list_id',
                    'wt_opt_in_list_creation_params',
                ],
                'required': [
                    'list_id',
                    'wt_opt_in_list_creation_params',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'list_id':
                        (NanoID,),
                    'wt_opt_in_list_creation_params':
                        (WTOptInListCreationParams,),
                },
                'attribute_map': {
                    'list_id': 'listID',
                },
                'location_map': {
                    'list_id': 'path',
                    'wt_opt_in_list_creation_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.save_opt_in_list_source_endpoint = _Endpoint(
            settings={
                'response_type': (OptInListSource,),
                'auth': [],
                'endpoint_path': '/v2/sms/optInListSource/{sourceID}',
                'operation_id': 'save_opt_in_list_source',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'wtsms_opt_in_list_source_create',
                ],
                'required': [
                    'source_id',
                    'wtsms_opt_in_list_source_create',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (NanoID,),
                    'wtsms_opt_in_list_source_create':
                        (WTSMSOptInListSourceCreate,),
                },
                'attribute_map': {
                    'source_id': 'sourceID',
                },
                'location_map': {
                    'source_id': 'path',
                    'wtsms_opt_in_list_source_create': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.send_phone_number_for_verification_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/verification/{phoneNumberID}',
                'operation_id': 'send_phone_number_for_verification',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                    'wtsms_update_phone_number_config',
                ],
                'required': [
                    'phone_number_id',
                    'wtsms_update_phone_number_config',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                    'wtsms_update_phone_number_config':
                        (WTSMSUpdatePhoneNumberConfig,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                    'wtsms_update_phone_number_config': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': (PhoneNumber,),
                'auth': [],
                'endpoint_path': '/v2/sms/phoneNumber/{phoneNumberID}',
                'operation_id': 'update_phone_number',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number_id',
                    'wtsms_update_phone_number_config',
                ],
                'required': [
                    'phone_number_id',
                    'wtsms_update_phone_number_config',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number_id':
                        (NanoID,),
                    'wtsms_update_phone_number_config':
                        (WTSMSUpdatePhoneNumberConfig,),
                },
                'attribute_map': {
                    'phone_number_id': 'phoneNumberID',
                },
                'location_map': {
                    'phone_number_id': 'path',
                    'wtsms_update_phone_number_config': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def acquire_phone_number(
        self,
        wtsms_acquire_phone_number,
        **kwargs
    ):
        """Acquire phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.acquire_phone_number(wtsms_acquire_phone_number, async_req=True)
        >>> result = thread.get()

        Args:
            wtsms_acquire_phone_number (WTSMSAcquirePhoneNumber):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PhoneNumber
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wtsms_acquire_phone_number'] = \
            wtsms_acquire_phone_number
        return self.acquire_phone_number_endpoint.call_with_http_info(**kwargs)

    def archive_phone_number(
        self,
        phone_number_id,
        **kwargs
    ):
        """Archive phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.archive_phone_number(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PhoneNumber
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.archive_phone_number_endpoint.call_with_http_info(**kwargs)

    def archive_recipient(
        self,
        id,
        **kwargs
    ):
        """Archive recipient  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.archive_recipient(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ImportedListRecipient
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.archive_recipient_endpoint.call_with_http_info(**kwargs)

    def count_imported_list_recipients(
        self,
        list_id,
        **kwargs
    ):
        """Count imported list recipients  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_imported_list_recipients(list_id, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):

        Keyword Args:
            is_archive_included (bool): [optional]
            start_date (datetime): [optional]
            end_date (datetime): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        return self.count_imported_list_recipients_endpoint.call_with_http_info(**kwargs)

    def count_opt_in_list_subscribers(
        self,
        list_id,
        **kwargs
    ):
        """Count opt in list subscribers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_opt_in_list_subscribers(list_id, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):

        Keyword Args:
            is_subscribed (bool): [optional]
            is_pending_age21_verification (bool): [optional]
            is_archive_included (bool): [optional]
            start_date (datetime): [optional]
            end_date (datetime): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        return self.count_opt_in_list_subscribers_endpoint.call_with_http_info(**kwargs)

    def count_opt_in_source_subscribers(
        self,
        source_id,
        **kwargs
    ):
        """Count opt in source subscribers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_opt_in_source_subscribers(source_id, async_req=True)
        >>> result = thread.get()

        Args:
            source_id (NanoID):

        Keyword Args:
            is_subscribed (bool): [optional]
            is_pending_age21_verification (bool): [optional]
            is_archive_included (bool): [optional]
            start_date (datetime): [optional]
            end_date (datetime): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_id'] = \
            source_id
        return self.count_opt_in_source_subscribers_endpoint.call_with_http_info(**kwargs)

    def count_outbound_sms(
        self,
        phone_number_id,
        **kwargs
    ):
        """Count outbound SMS  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_outbound_sms(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            to_phone_number (str): [optional]
            status (str): [optional]
            payment_object_broadcast_id (NanoID): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.count_outbound_sms_endpoint.call_with_http_info(**kwargs)

    def create_imported_list(
        self,
        wtsms_imported_list_create,
        **kwargs
    ):
        """Create imported list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_imported_list(wtsms_imported_list_create, async_req=True)
        >>> result = thread.get()

        Args:
            wtsms_imported_list_create (WTSMSImportedListCreate):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ImportedList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wtsms_imported_list_create'] = \
            wtsms_imported_list_create
        return self.create_imported_list_endpoint.call_with_http_info(**kwargs)

    def create_opt_in_list(
        self,
        wt_opt_in_list_creation_params,
        **kwargs
    ):
        """Create opt in list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_opt_in_list(wt_opt_in_list_creation_params, async_req=True)
        >>> result = thread.get()

        Args:
            wt_opt_in_list_creation_params (WTOptInListCreationParams):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OptInList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_opt_in_list_creation_params'] = \
            wt_opt_in_list_creation_params
        return self.create_opt_in_list_endpoint.call_with_http_info(**kwargs)

    def create_opt_in_list_source(
        self,
        wtsms_opt_in_list_source_create,
        **kwargs
    ):
        """Send SMS to opt in list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_opt_in_list_source(wtsms_opt_in_list_source_create, async_req=True)
        >>> result = thread.get()

        Args:
            wtsms_opt_in_list_source_create (WTSMSOptInListSourceCreate):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OptInListSource
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wtsms_opt_in_list_source_create'] = \
            wtsms_opt_in_list_source_create
        return self.create_opt_in_list_source_endpoint.call_with_http_info(**kwargs)

    def create_recipient_in_imported_list(
        self,
        ss_imported_list_recipient_create_params,
        **kwargs
    ):
        """Add new recipient in an imported list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_recipient_in_imported_list(ss_imported_list_recipient_create_params, async_req=True)
        >>> result = thread.get()

        Args:
            ss_imported_list_recipient_create_params (SSImportedListRecipientCreateParams):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ImportedListRecipient
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ss_imported_list_recipient_create_params'] = \
            ss_imported_list_recipient_create_params
        return self.create_recipient_in_imported_list_endpoint.call_with_http_info(**kwargs)

    def create_sms_agreement(
        self,
        wtsms_create_agreement,
        **kwargs
    ):
        """Accept SMS agreement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sms_agreement(wtsms_create_agreement, async_req=True)
        >>> result = thread.get()

        Args:
            wtsms_create_agreement (WTSMSCreateAgreement):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Agreement
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wtsms_create_agreement'] = \
            wtsms_create_agreement
        return self.create_sms_agreement_endpoint.call_with_http_info(**kwargs)

    def export_imported_list_recipients(
        self,
        imported_list_id,
        **kwargs
    ):
        """Export imported list recipients  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_imported_list_recipients(imported_list_id, async_req=True)
        >>> result = thread.get()

        Args:
            imported_list_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['imported_list_id'] = \
            imported_list_id
        return self.export_imported_list_recipients_endpoint.call_with_http_info(**kwargs)

    def export_opt_in_list_subscribers(
        self,
        list_id,
        **kwargs
    ):
        """Export opt in list subscribers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_opt_in_list_subscribers(list_id, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        return self.export_opt_in_list_subscribers_endpoint.call_with_http_info(**kwargs)

    def fetch_blocked_tcpa_entries(
        self,
        phone_number_id,
        **kwargs
    ):
        """Fetch blocked TCPA entries  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_blocked_tcpa_entries(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Tcpa]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.fetch_blocked_tcpa_entries_endpoint.call_with_http_info(**kwargs)

    def fetch_imported_list_recipients(
        self,
        list_id,
        **kwargs
    ):
        """Fetch imported list recipients  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_imported_list_recipients(list_id, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ImportedListRecipient]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        return self.fetch_imported_list_recipients_endpoint.call_with_http_info(**kwargs)

    def fetch_imported_list_recipients_by_page(
        self,
        list_id,
        **kwargs
    ):
        """Fetch imported list recipients by page  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_imported_list_recipients_by_page(list_id, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):

        Keyword Args:
            page_size (float): [optional]
            page_num (float): [optional]
            is_archive_included (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineResponse2008
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        return self.fetch_imported_list_recipients_by_page_endpoint.call_with_http_info(**kwargs)

    def fetch_opt_in_list_sources(
        self,
        **kwargs
    ):
        """Fetch all opt in list sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_opt_in_list_sources(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            is_archive_included (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.fetch_opt_in_list_sources_endpoint.call_with_http_info(**kwargs)

    def fetch_opt_in_list_subscribers(
        self,
        list_id,
        **kwargs
    ):
        """Fetch opt in list subscribers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_opt_in_list_subscribers(list_id, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):

        Keyword Args:
            is_subscribed (bool): [optional]
            is_pending_age21_verification (bool): [optional]
            is_archive_included (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [OptInListSubscriber]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        return self.fetch_opt_in_list_subscribers_endpoint.call_with_http_info(**kwargs)

    def fetch_opt_in_list_subscribers_by_page(
        self,
        list_id,
        **kwargs
    ):
        """Fetch opt in list subscribers by page  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_opt_in_list_subscribers_by_page(list_id, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):

        Keyword Args:
            page_size (float): [optional]
            page_num (float): [optional]
            is_subscribed (bool): [optional]
            is_pending_age21_verification (bool): [optional]
            is_archive_included (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineResponse2007
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        return self.fetch_opt_in_list_subscribers_by_page_endpoint.call_with_http_info(**kwargs)

    def fetch_opt_in_lists_associated_with_phone_number(
        self,
        phone_number_id,
        **kwargs
    ):
        """Fetch opt in lists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_opt_in_lists_associated_with_phone_number(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [OptInList]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.fetch_opt_in_lists_associated_with_phone_number_endpoint.call_with_http_info(**kwargs)

    def fetch_opt_in_source_subscribers(
        self,
        source_id,
        **kwargs
    ):
        """Fetch opt in source subscribers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_opt_in_source_subscribers(source_id, async_req=True)
        >>> result = thread.get()

        Args:
            source_id (NanoID):

        Keyword Args:
            is_subscribed (bool): [optional]
            is_pending_age21_verification (bool): [optional]
            is_archive_included (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [OptInListSubscriber]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_id'] = \
            source_id
        return self.fetch_opt_in_source_subscribers_endpoint.call_with_http_info(**kwargs)

    def fetch_opt_in_sources_associated_with_phone_number(
        self,
        phone_number_id,
        **kwargs
    ):
        """Fetch opt in sources  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_opt_in_sources_associated_with_phone_number(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [OptInListSource]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.fetch_opt_in_sources_associated_with_phone_number_endpoint.call_with_http_info(**kwargs)

    def fetch_outbound_sms(
        self,
        phone_number_id,
        **kwargs
    ):
        """Fetch outbound SMS  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_outbound_sms(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            to_phone_number (str): [optional]
            status (str): [optional]
            payment_object_broadcast_id (NanoID): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [OutboundSMS]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.fetch_outbound_sms_endpoint.call_with_http_info(**kwargs)

    def fetch_outbound_smsby_page(
        self,
        phone_number_id,
        **kwargs
    ):
        """Fetch outbound SMSes by page  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_outbound_smsby_page(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            to_phone_number (str): [optional]
            payment_object_broadcast_id (NanoID): [optional]
            page_size (float): [optional]
            page_num (float): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineResponse2006
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.fetch_outbound_smsby_page_endpoint.call_with_http_info(**kwargs)

    def fetch_payment_object_broadcasts(
        self,
        phone_number_id,
        **kwargs
    ):
        """Fetch payment object broadcasts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_payment_object_broadcasts(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [StaticVoucherCampaignBroadcast]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.fetch_payment_object_broadcasts_endpoint.call_with_http_info(**kwargs)

    def fetch_sms_agreement(
        self,
        **kwargs
    ):
        """Fetch SMS agreement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_sms_agreement(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.fetch_sms_agreement_endpoint.call_with_http_info(**kwargs)

    def import_imported_list_recipients(
        self,
        imported_list_id,
        wt_employee_import_records,
        **kwargs
    ):
        """Import imported list recipients  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_imported_list_recipients(imported_list_id, wt_employee_import_records, async_req=True)
        >>> result = thread.get()

        Args:
            imported_list_id (NanoID):
            wt_employee_import_records (WTEmployeeImportRecords):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['imported_list_id'] = \
            imported_list_id
        kwargs['wt_employee_import_records'] = \
            wt_employee_import_records
        return self.import_imported_list_recipients_endpoint.call_with_http_info(**kwargs)

    def import_imported_list_recipients_from_membership_tier(
        self,
        wt_imported_list_recipient_from_membership_tier_import,
        **kwargs
    ):
        """Import imported list recipients from a given membership tier  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_imported_list_recipients_from_membership_tier(wt_imported_list_recipient_from_membership_tier_import, async_req=True)
        >>> result = thread.get()

        Args:
            wt_imported_list_recipient_from_membership_tier_import (WTImportedListRecipientFromMembershipTierImport):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_imported_list_recipient_from_membership_tier_import'] = \
            wt_imported_list_recipient_from_membership_tier_import
        return self.import_imported_list_recipients_from_membership_tier_endpoint.call_with_http_info(**kwargs)

    def import_opt_in_list_subscribers(
        self,
        list_id,
        wtsms_import_opt_in_list_subscribers,
        **kwargs
    ):
        """Import opt in list subscribers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_opt_in_list_subscribers(list_id, wtsms_import_opt_in_list_subscribers, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):
            wtsms_import_opt_in_list_subscribers (WTSMSImportOptInListSubscribers):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        kwargs['wtsms_import_opt_in_list_subscribers'] = \
            wtsms_import_opt_in_list_subscribers
        return self.import_opt_in_list_subscribers_endpoint.call_with_http_info(**kwargs)

    def restore_phone_number(
        self,
        phone_number_id,
        **kwargs
    ):
        """Restore phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restore_phone_number(phone_number_id, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PhoneNumber
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        return self.restore_phone_number_endpoint.call_with_http_info(**kwargs)

    def restore_recipient(
        self,
        id,
        **kwargs
    ):
        """Restore recipient  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restore_recipient(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (NanoID):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ImportedListRecipient
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.restore_recipient_endpoint.call_with_http_info(**kwargs)

    def retrieve_sent_and_max_count_of_messages(
        self,
        **kwargs
    ):
        """Retrieve the number of messages sent by the merchant within the current billing cycle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_sent_and_max_count_of_messages(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTSMSLimits
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.retrieve_sent_and_max_count_of_messages_endpoint.call_with_http_info(**kwargs)

    def save_imported_list(
        self,
        list_id,
        wtsms_imported_list_create,
        **kwargs
    ):
        """Save imported list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_imported_list(list_id, wtsms_imported_list_create, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):
            wtsms_imported_list_create (WTSMSImportedListCreate):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ImportedList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        kwargs['wtsms_imported_list_create'] = \
            wtsms_imported_list_create
        return self.save_imported_list_endpoint.call_with_http_info(**kwargs)

    def save_opt_in_list(
        self,
        list_id,
        wt_opt_in_list_creation_params,
        **kwargs
    ):
        """Save opt in list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_opt_in_list(list_id, wt_opt_in_list_creation_params, async_req=True)
        >>> result = thread.get()

        Args:
            list_id (NanoID):
            wt_opt_in_list_creation_params (WTOptInListCreationParams):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OptInList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['list_id'] = \
            list_id
        kwargs['wt_opt_in_list_creation_params'] = \
            wt_opt_in_list_creation_params
        return self.save_opt_in_list_endpoint.call_with_http_info(**kwargs)

    def save_opt_in_list_source(
        self,
        source_id,
        wtsms_opt_in_list_source_create,
        **kwargs
    ):
        """Save opt in list source  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_opt_in_list_source(source_id, wtsms_opt_in_list_source_create, async_req=True)
        >>> result = thread.get()

        Args:
            source_id (NanoID):
            wtsms_opt_in_list_source_create (WTSMSOptInListSourceCreate):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OptInListSource
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['source_id'] = \
            source_id
        kwargs['wtsms_opt_in_list_source_create'] = \
            wtsms_opt_in_list_source_create
        return self.save_opt_in_list_source_endpoint.call_with_http_info(**kwargs)

    def send_phone_number_for_verification(
        self,
        phone_number_id,
        wtsms_update_phone_number_config,
        **kwargs
    ):
        """Request phone number verification  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_phone_number_for_verification(phone_number_id, wtsms_update_phone_number_config, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):
            wtsms_update_phone_number_config (WTSMSUpdatePhoneNumberConfig):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        kwargs['wtsms_update_phone_number_config'] = \
            wtsms_update_phone_number_config
        return self.send_phone_number_for_verification_endpoint.call_with_http_info(**kwargs)

    def update_phone_number(
        self,
        phone_number_id,
        wtsms_update_phone_number_config,
        **kwargs
    ):
        """Update phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_phone_number(phone_number_id, wtsms_update_phone_number_config, async_req=True)
        >>> result = thread.get()

        Args:
            phone_number_id (NanoID):
            wtsms_update_phone_number_config (WTSMSUpdatePhoneNumberConfig):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PhoneNumber
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['phone_number_id'] = \
            phone_number_id
        kwargs['wtsms_update_phone_number_config'] = \
            wtsms_update_phone_number_config
        return self.update_phone_number_endpoint.call_with_http_info(**kwargs)

