"""
    wallet-api

    API  # noqa: E501

    The version of the OpenAPI document: 2.1.524
    Contact: development@wallet.inc
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from wallet.api_client import ApiClient, Endpoint as _Endpoint
from wallet.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from wallet.model.auth_error import AuthError
from wallet.model.falsum_error import FalsumError
from wallet.model.internal_server_error import InternalServerError
from wallet.model.request import Request
from wallet.model.response import Response
from wallet.model.static_voucher import StaticVoucher
from wallet.model.wt_count_result import WTCountResult
from wallet.model.wt_info_genesis_lookup_request_errors import WTInfoGenesisLookupRequestErrors
from wallet.model.wt_info_genesis_record_filter_parameters import WTInfoGenesisRecordFilterParameters
from wallet.model.wt_info_genesis_routing_ids import WTInfoGenesisRoutingIDs
from wallet.model.wt_info_genesis_unique_posting_ids import WTInfoGenesisUniquePostingIDs


class InfoGenesisReportsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.count_ad_credits_redemptions_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/adCredits/redemptions',
                'operation_id': 'count_ad_credits_redemptions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_ad_credits_refunds_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/adCredits/refunds',
                'operation_id': 'count_ad_credits_refunds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_dynamic_voucher_redemptions_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/dynamicVoucher/redemptions',
                'operation_id': 'count_dynamic_voucher_redemptions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_dynamic_voucher_refunds_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/dynamicVoucher/refunds',
                'operation_id': 'count_dynamic_voucher_refunds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_membership_points_redemptions_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/membershipPoints/redemptions',
                'operation_id': 'count_membership_points_redemptions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_membership_points_refunds_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/membershipPoints/refunds',
                'operation_id': 'count_membership_points_refunds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_membership_tier_redemptions_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/membershipTier/redemptions',
                'operation_id': 'count_membership_tier_redemptions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_membership_tier_refunds_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/membershipTier/refunds',
                'operation_id': 'count_membership_tier_refunds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_merchant_credit_redemptions_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/merchantCredit/redemptions',
                'operation_id': 'count_merchant_credit_redemptions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_merchant_credit_refunds_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/merchantCredit/refunds',
                'operation_id': 'count_merchant_credit_refunds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_static_voucher_redemptions_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/staticVoucher/redemptions',
                'operation_id': 'count_static_voucher_redemptions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.count_static_voucher_refunds_endpoint = _Endpoint(
            settings={
                'response_type': (WTCountResult,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/count/staticVoucher/refunds',
                'operation_id': 'count_static_voucher_refunds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_authorizations_endpoint = _Endpoint(
            settings={
                'response_type': ([Request],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/authorizations',
                'operation_id': 'fetch_info_genesis_authorizations',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_campaign_data_endpoint = _Endpoint(
            settings={
                'response_type': (bool,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/campaign',
                'operation_id': 'fetch_info_genesis_campaign_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_lookup_requests_endpoint = _Endpoint(
            settings={
                'response_type': ([Request],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/requests/lookup',
                'operation_id': 'fetch_info_genesis_lookup_requests',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_lookup_requests_errors_endpoint = _Endpoint(
            settings={
                'response_type': ([Request],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/requests/lookup/errors',
                'operation_id': 'fetch_info_genesis_lookup_requests_errors',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_lookup_request_errors',
                ],
                'required': [
                    'wt_info_genesis_lookup_request_errors',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_lookup_request_errors':
                        (WTInfoGenesisLookupRequestErrors,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_lookup_request_errors': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_redeemed_static_vouchers_endpoint = _Endpoint(
            settings={
                'response_type': ([StaticVoucher],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/staticVouchers/redeemed',
                'operation_id': 'fetch_info_genesis_redeemed_static_vouchers',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_unique_posting_ids',
                ],
                'required': [
                    'wt_info_genesis_unique_posting_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_unique_posting_ids':
                        (WTInfoGenesisUniquePostingIDs,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_unique_posting_ids': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_redeemed_unique_posting_ids_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/postingIDs/redeemed',
                'operation_id': 'fetch_info_genesis_redeemed_unique_posting_ids',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date_time',
                    'end_date_time',
                ],
                'required': [
                    'start_date_time',
                    'end_date_time',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date_time':
                        (datetime,),
                    'end_date_time':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date_time': 'startDateTime',
                    'end_date_time': 'endDateTime',
                },
                'location_map': {
                    'start_date_time': 'query',
                    'end_date_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_info_genesis_redemptions_endpoint = _Endpoint(
            settings={
                'response_type': ([Request],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/redemptions',
                'operation_id': 'fetch_info_genesis_redemptions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_refunded_routing_ids_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/routingIDs/refunded',
                'operation_id': 'fetch_info_genesis_refunded_routing_ids',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date_time',
                    'end_date_time',
                ],
                'required': [
                    'start_date_time',
                    'end_date_time',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date_time':
                        (datetime,),
                    'end_date_time':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date_time': 'startDateTime',
                    'end_date_time': 'endDateTime',
                },
                'location_map': {
                    'start_date_time': 'query',
                    'end_date_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_info_genesis_refunded_static_vouchers_endpoint = _Endpoint(
            settings={
                'response_type': ([StaticVoucher],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/staticVouchers/refunded',
                'operation_id': 'fetch_info_genesis_refunded_static_vouchers',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_routing_ids',
                ],
                'required': [
                    'wt_info_genesis_routing_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_routing_ids':
                        (WTInfoGenesisRoutingIDs,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_routing_ids': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_refunds_endpoint = _Endpoint(
            settings={
                'response_type': ([Request],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/refunds',
                'operation_id': 'fetch_info_genesis_refunds',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'required': [
                    'wt_info_genesis_record_filter_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_record_filter_parameters':
                        (WTInfoGenesisRecordFilterParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_record_filter_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_request_endpoint = _Endpoint(
            settings={
                'response_type': (Request,),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/request/{transactionID}',
                'operation_id': 'fetch_info_genesis_request',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_id',
                ],
                'required': [
                    'transaction_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_id':
                        (str,),
                },
                'attribute_map': {
                    'transaction_id': 'transactionID',
                },
                'location_map': {
                    'transaction_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_info_genesis_requests_endpoint = _Endpoint(
            settings={
                'response_type': ([Request],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/requests',
                'operation_id': 'fetch_info_genesis_requests',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_routing_ids',
                ],
                'required': [
                    'wt_info_genesis_routing_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_routing_ids':
                        (WTInfoGenesisRoutingIDs,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_routing_ids': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_response_errors_endpoint = _Endpoint(
            settings={
                'response_type': ([Response],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/responses/errors',
                'operation_id': 'fetch_info_genesis_response_errors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date_time',
                    'end_date_time',
                ],
                'required': [
                    'start_date_time',
                    'end_date_time',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date_time':
                        (datetime,),
                    'end_date_time':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date_time': 'startDateTime',
                    'end_date_time': 'endDateTime',
                },
                'location_map': {
                    'start_date_time': 'query',
                    'end_date_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_info_genesis_responses_endpoint = _Endpoint(
            settings={
                'response_type': ([Response],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/responses',
                'operation_id': 'fetch_info_genesis_responses',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_routing_ids',
                ],
                'required': [
                    'wt_info_genesis_routing_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_routing_ids':
                        (WTInfoGenesisRoutingIDs,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_routing_ids': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_info_genesis_transactions_with_unique_posting_ids_endpoint = _Endpoint(
            settings={
                'response_type': ([Request],),
                'auth': [],
                'endpoint_path': '/v2/pos/infogenesis/transactions',
                'operation_id': 'fetch_info_genesis_transactions_with_unique_posting_ids',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'wt_info_genesis_unique_posting_ids',
                ],
                'required': [
                    'wt_info_genesis_unique_posting_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'wt_info_genesis_unique_posting_ids':
                        (WTInfoGenesisUniquePostingIDs,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'wt_info_genesis_unique_posting_ids': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def count_ad_credits_redemptions(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count redeemed ad credits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_ad_credits_redemptions(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_ad_credits_redemptions_endpoint.call_with_http_info(**kwargs)

    def count_ad_credits_refunds(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count refunded ad credits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_ad_credits_refunds(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_ad_credits_refunds_endpoint.call_with_http_info(**kwargs)

    def count_dynamic_voucher_redemptions(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count dynamic voucher redemptions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_dynamic_voucher_redemptions(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_dynamic_voucher_redemptions_endpoint.call_with_http_info(**kwargs)

    def count_dynamic_voucher_refunds(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count dynamic voucher refunds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_dynamic_voucher_refunds(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_dynamic_voucher_refunds_endpoint.call_with_http_info(**kwargs)

    def count_membership_points_redemptions(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count redeemed membership points  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_membership_points_redemptions(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_membership_points_redemptions_endpoint.call_with_http_info(**kwargs)

    def count_membership_points_refunds(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count refunded membership points  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_membership_points_refunds(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_membership_points_refunds_endpoint.call_with_http_info(**kwargs)

    def count_membership_tier_redemptions(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count tier redemptions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_membership_tier_redemptions(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_membership_tier_redemptions_endpoint.call_with_http_info(**kwargs)

    def count_membership_tier_refunds(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count tier refunds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_membership_tier_refunds(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_membership_tier_refunds_endpoint.call_with_http_info(**kwargs)

    def count_merchant_credit_redemptions(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count redeemed merchant credits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_merchant_credit_redemptions(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_merchant_credit_redemptions_endpoint.call_with_http_info(**kwargs)

    def count_merchant_credit_refunds(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count refunded merchant credits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_merchant_credit_refunds(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_merchant_credit_refunds_endpoint.call_with_http_info(**kwargs)

    def count_static_voucher_redemptions(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count static voucher redemptions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_static_voucher_redemptions(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_static_voucher_redemptions_endpoint.call_with_http_info(**kwargs)

    def count_static_voucher_refunds(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Count static voucher refunds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_static_voucher_refunds(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTCountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.count_static_voucher_refunds_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_authorizations(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Fetch InfoGenesis authorizations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_authorizations(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Request]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.fetch_info_genesis_authorizations_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_campaign_data(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Fetch campaign information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_campaign_data(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.fetch_info_genesis_campaign_data_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_lookup_requests(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Fetch InfoGenesis lookup requests  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_lookup_requests(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Request]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.fetch_info_genesis_lookup_requests_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_lookup_requests_errors(
        self,
        wt_info_genesis_lookup_request_errors,
        **kwargs
    ):
        """Fetch InfoGenesis lookup request errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_lookup_requests_errors(wt_info_genesis_lookup_request_errors, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_lookup_request_errors (WTInfoGenesisLookupRequestErrors):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Request]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_lookup_request_errors'] = \
            wt_info_genesis_lookup_request_errors
        return self.fetch_info_genesis_lookup_requests_errors_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_redeemed_static_vouchers(
        self,
        wt_info_genesis_unique_posting_ids,
        **kwargs
    ):
        """Fetch redeemed static vouchers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_redeemed_static_vouchers(wt_info_genesis_unique_posting_ids, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_unique_posting_ids (WTInfoGenesisUniquePostingIDs):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [StaticVoucher]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_unique_posting_ids'] = \
            wt_info_genesis_unique_posting_ids
        return self.fetch_info_genesis_redeemed_static_vouchers_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_redeemed_unique_posting_ids(
        self,
        start_date_time,
        end_date_time,
        **kwargs
    ):
        """Fetch redeemed InfoGenesis unique posting IDs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_redeemed_unique_posting_ids(start_date_time, end_date_time, async_req=True)
        >>> result = thread.get()

        Args:
            start_date_time (datetime):
            end_date_time (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date_time'] = \
            start_date_time
        kwargs['end_date_time'] = \
            end_date_time
        return self.fetch_info_genesis_redeemed_unique_posting_ids_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_redemptions(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Fetch InfoGenesis redemptions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_redemptions(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Request]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.fetch_info_genesis_redemptions_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_refunded_routing_ids(
        self,
        start_date_time,
        end_date_time,
        **kwargs
    ):
        """Fetch refunded InfoGenesis unique posting IDs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_refunded_routing_ids(start_date_time, end_date_time, async_req=True)
        >>> result = thread.get()

        Args:
            start_date_time (datetime):
            end_date_time (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date_time'] = \
            start_date_time
        kwargs['end_date_time'] = \
            end_date_time
        return self.fetch_info_genesis_refunded_routing_ids_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_refunded_static_vouchers(
        self,
        wt_info_genesis_routing_ids,
        **kwargs
    ):
        """Fetch refunded static vouchers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_refunded_static_vouchers(wt_info_genesis_routing_ids, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_routing_ids (WTInfoGenesisRoutingIDs):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [StaticVoucher]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_routing_ids'] = \
            wt_info_genesis_routing_ids
        return self.fetch_info_genesis_refunded_static_vouchers_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_refunds(
        self,
        wt_info_genesis_record_filter_parameters,
        **kwargs
    ):
        """Fetch InfoGenesis refunds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_refunds(wt_info_genesis_record_filter_parameters, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_record_filter_parameters (WTInfoGenesisRecordFilterParameters):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Request]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_record_filter_parameters'] = \
            wt_info_genesis_record_filter_parameters
        return self.fetch_info_genesis_refunds_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_request(
        self,
        transaction_id,
        **kwargs
    ):
        """Fetch InfoGenesis request with transaction ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_request(transaction_id, async_req=True)
        >>> result = thread.get()

        Args:
            transaction_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Request
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['transaction_id'] = \
            transaction_id
        return self.fetch_info_genesis_request_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_requests(
        self,
        wt_info_genesis_routing_ids,
        **kwargs
    ):
        """Fetch InfoGenesis requests with routing IDs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_requests(wt_info_genesis_routing_ids, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_routing_ids (WTInfoGenesisRoutingIDs):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Request]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_routing_ids'] = \
            wt_info_genesis_routing_ids
        return self.fetch_info_genesis_requests_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_response_errors(
        self,
        start_date_time,
        end_date_time,
        **kwargs
    ):
        """Fetch InfoGenesis response errors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_response_errors(start_date_time, end_date_time, async_req=True)
        >>> result = thread.get()

        Args:
            start_date_time (datetime):
            end_date_time (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Response]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date_time'] = \
            start_date_time
        kwargs['end_date_time'] = \
            end_date_time
        return self.fetch_info_genesis_response_errors_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_responses(
        self,
        wt_info_genesis_routing_ids,
        **kwargs
    ):
        """Fetch InfoGenesis responses with routing IDs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_responses(wt_info_genesis_routing_ids, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_routing_ids (WTInfoGenesisRoutingIDs):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Response]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_routing_ids'] = \
            wt_info_genesis_routing_ids
        return self.fetch_info_genesis_responses_endpoint.call_with_http_info(**kwargs)

    def fetch_info_genesis_transactions_with_unique_posting_ids(
        self,
        wt_info_genesis_unique_posting_ids,
        **kwargs
    ):
        """Fetch InfoGenesis transactions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_info_genesis_transactions_with_unique_posting_ids(wt_info_genesis_unique_posting_ids, async_req=True)
        >>> result = thread.get()

        Args:
            wt_info_genesis_unique_posting_ids (WTInfoGenesisUniquePostingIDs):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Request]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['wt_info_genesis_unique_posting_ids'] = \
            wt_info_genesis_unique_posting_ids
        return self.fetch_info_genesis_transactions_with_unique_posting_ids_endpoint.call_with_http_info(**kwargs)

