# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['meta_package_manager',
 'meta_package_manager.bitbar',
 'meta_package_manager.managers',
 'meta_package_manager.tests']

package_data = \
{'': ['*']}

install_requires = \
['boltons>=20.2.1,<21.0.0',
 'cli-helpers>=2.1,<3.0',
 'click-log>=0.3,<0.4',
 'click>=7.1,<8.0',
 'simplejson>=3.17.2,<4.0.0',
 'tomlkit>=0.7,<0.8']

extras_require = \
{'docs': ['sphinx>=3.2,<4.0',
          'sphinx_rtd_theme>=0.5.0,<0.6.0',
          'sphinx_tabs>=1.1.13,<2.0.0']}

entry_points = \
{'console_scripts': ['mpm = meta_package_manager.cli:cli']}

setup_kwargs = {
    'name': 'meta-package-manager',
    'version': '3.4.0',
    'description': '    CLI unifying Homebrew, apt, Chocolatey, Pip, NPM, Composer and the like.',
    'long_description': "Meta Package Manager\n====================\n\nCLI providing unifying interface to all package managers.\n\nStable release: |release| |versions|\n\nDevelopment: |build| |docs| |coverage|\n\n.. |release| image:: https://img.shields.io/pypi/v/meta-package-manager.svg\n    :target: https://pypi.python.org/pypi/meta-package-manager\n    :alt: Last release\n.. |versions| image:: https://img.shields.io/pypi/pyversions/meta-package-manager.svg\n    :target: https://pypi.python.org/pypi/meta-package-manager\n    :alt: Python versions\n.. |build| image:: https://github.com/kdeldycke/meta-package-manager/workflows/Tests/badge.svg\n    :target: https://github.com/kdeldycke/meta-package-manager/actions?query=workflow%3ATests\n    :alt: Unittests status\n.. |docs| image:: https://readthedocs.org/projects/meta-package-manager/badge/?version=develop\n    :target: https://meta-package-manager.readthedocs.io/en/develop/\n    :alt: Documentation Status\n.. |coverage| image:: https://codecov.io/gh/kdeldycke/meta-package-manager/branch/develop/graph/badge.svg\n    :target: https://codecov.io/github/kdeldycke/meta-package-manager?branch=develop\n    :alt: Coverage Status\n\n.. figure:: https://raw.githubusercontent.com/kdeldycke/meta-package-manager/develop/docs/mpm-managers-cli.png\n    :align: center\n\n.. figure:: https://raw.githubusercontent.com/kdeldycke/meta-package-manager/develop/docs/mpm-outdated-cli.png\n    :align: center\n\n\nFeatures\n---------\n\n* Inventory and list all package managers available on the system.\n* Supports macOS, Linux and Windows.\n* List installed packages.\n* Search for packages.\n* List outdated packages.\n* Sync local package infos.\n* Upgrade all outdated packages.\n* Backup list of installed packages to TOML files.\n* Pin-point commands to a subset of package managers (include/exclude\n  selectors).\n* Export results in JSON or user-friendly tables.\n* Shell auto-completion for Bash, Zsh and Fish.\n* Provides a `BitBar plugin\n  <https://meta-package-manager.readthedocs.io/en/develop/bitbar.html>`_ for\n  friendly macOS integration.\n\n\nSupported package managers\n--------------------------\n\n================ ============= ====== ====== ======== ========= ============== =========== ============ ============= ============ ============\nPackage manager  Min. version  macOS  Linux  Windows  ``sync``  ``installed``  ``search``  ``install``  ``outdated``  ``upgrade``  ``cleanup``\n================ ============= ====== ====== ======== ========= ============== =========== ============ ============= ============ ============\n|brew|__          2.2.15        ✓                      ✓         ✓              ✓                        ✓             ✓            ✓\n|cask|__          2.2.15        ✓                      ✓         ✓              ✓                        ✓             ✓            ✓\n|pip|__           10.0.0        ✓      ✓      ✓                  ✓              ✓                        ✓             ✓\n|npm|__           4.0.0         ✓      ✓      ✓                  ✓              ✓                        ✓             ✓\n|yarn|__          1.21.0        ✓      ✓      ✓                  ✓              ✓                        ✓             ✓            ✓\n|apm|__                         ✓      ✓      ✓                  ✓              ✓                        ✓             ✓\n|gem|__           2.5.0         ✓      ✓      ✓                  ✓              ✓                        ✓             ✓            ✓\n|mas|__           1.3.1         ✓                                ✓              ✓                        ✓             ✓\n|apt|__           1.0.0                ✓               ✓         ✓              ✓                        ✓             ✓            ✓\n|composer|__      1.4.0         ✓      ✓      ✓        ✓         ✓              ✓                        ✓             ✓            ✓\n|flatpak|__       1.2.*                ✓                         ✓              ✓                        ✓             ✓            ✓\n|opkg|__          0.2.0                ✓               ✓         ✓              ✓                        ✓             ✓\n|snap|__          2.0.0                ✓                         ✓              ✓                                      ✓\n================ ============= ====== ====== ======== ========= ============== =========== ============ ============= ============ ============\n\n.. |brew| replace::\n   Homebrew\n__ https://brew.sh\n.. |cask| replace::\n   Homebrew Cask\n__ https://caskroom.github.io\n.. |pip| replace::\n   Python ``pip``\n__ https://pypi.org\n.. |npm| replace::\n   Node's ``npm``\n__ https://www.npmjs.com\n.. |yarn| replace::\n   Node's ``yarn``\n__ https://yarnpkg.com\n.. |apm| replace::\n   Atom's ``apm``\n__ https://atom.io/packages\n.. |gem| replace::\n   Ruby's ``gem``\n__ https://rubygems.org\n.. |mas| replace::\n   Mac AppStore via ``mas``\n__ https://github.com/argon/mas\n.. |apt| replace::\n   ``apt``\n__ https://wiki.debian.org/Apt\n.. |composer| replace::\n   ``composer``\n__ https://getcomposer.org\n.. |flatpak| replace::\n   Flatpak\n__ https://flatpak.org\n.. |opkg| replace::\n   opkg\n__ https://git.yoctoproject.org/cgit/cgit.cgi/opkg/\n.. |snap| replace::\n   ``snap``\n__ https://snapcraft.io\n\n\nIf you're bored, feel free to add support for new package manager. See\ngood candidates at:\n\n* `Wikipedia list of package managers\n  <https://en.wikipedia.org/wiki/List_of_software_package_management_systems>`_\n* `Awesome list of package managers\n  <https://github.com/k4m4/terminals-are-sexy#package-managers>`_\n* `GitHub list of package managers\n  <https://github.com/showcases/package-managers>`_\n\n\nInstallation\n------------\n\nThis package is `available on PyPi\n<https://pypi.python.org/pypi/meta-package-manager>`_, so you can install the\nlatest stable release and its dependencies with a simple ``pip`` call:\n\n.. code-block:: shell-session\n\n    $ pip install meta-package-manager\n\n\nDocumentation\n-------------\n\nDocs are `hosted on Read the Docs\n<https://meta-package-manager.readthedocs.io>`_.\n\n\nUsage\n-----\n\nExamples of the package's ``mpm`` CLI.\n\nList global options and commands:\n\n.. code-block:: shell-session\n\n    $ mpm\n    Usage: mpm [OPTIONS] COMMAND [ARGS]...\n\n      CLI for multi-package manager upgrades.\n\n    Options:\n      -v, --verbosity LEVEL           Either CRITICAL, ERROR, WARNING, INFO or\n                                      DEBUG. Defaults to INFO.\n      -m, --manager [apm|apt|brew|cask|composer|flatpak|gem|mas|npm|opkg|pip2|pip3]\n                                      Restrict sub-command to a subset of package\n                                      managers. Repeat to select multiple\n                                      managers. Defaults to all.\n      --ignore-auto-updates / --include-auto-updates\n                                      Report all outdated packages, including\n                                      those tagged as auto-updating. Defaults to\n                                      include all packages. Only applies for\n                                      'outdated' and 'upgrade' commands.\n      -o, --output-format [ascii|csv|csv-tab|double|fancy_grid|github|grid|html|jira|json|latex|latex_booktabs|mediawiki|moinmoin|orgtbl|pipe|plain|psql|rst|simple|textile|tsv|vertical]\n                                      Rendering mode of the output. Defaults to\n                                      fancy-grid.\n      --stats / --no-stats            Print statistics or not at the end of\n                                      output. Active by default.\n      --stop-on-error / --continue-on-error\n                                      Stop right away or continue operations on\n                                      manager CLI error. Defaults to stop.\n      --version                       Show the version and exit.\n      --help                          Show this message and exit.\n\n    Commands:\n      installed  List installed packages.\n      managers   List supported package managers and their location.\n      outdated   List outdated packages.\n      search     Search packages.\n      sync       Sync local package info.\n      upgrade    Upgrade all packages.\n\nList all supported package managers and their status on current system (macOS):\n\n.. code-block:: shell-session\n\n    $ mpm managers\n    ╒═══════════════════╤══════════╤═══════════════╤════════════════════════════╤══════════════╤═══════════╕\n    │ Package manager   │ ID       │ Supported     │ CLI                        │ Executable   │ Version   │\n    ╞═══════════════════╪══════════╪═══════════════╪════════════════════════════╪══════════════╪═══════════╡\n    │ Atom's apm        │ apm      │ ✓             │ ✘  apm CLI not found.      │              │           │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ APT               │ apt      │ ✘  Linux only │ ✓  /usr/bin/apt            │ ✓            │ ✘         │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Homebrew          │ brew     │ ✓             │ ✓  /usr/local/bin/brew     │ ✓            │ ✓  2.2.10 │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Homebrew Cask     │ cask     │ ✓             │ ✓  /usr/local/bin/brew     │ ✓            │ ✓  2.2.10 │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ PHP's Composer    │ composer │ ✓             │ ✘  composer CLI not found. │              │           │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Flatpak           │ flatpak  │ ✘  Linux only │ ✘  flatpak CLI not found.  │              │           │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Ruby Gems         │ gem      │ ✓             │ ✓  /usr/bin/gem            │ ✓            │ ✓  3.0.3  │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Mac AppStore      │ mas      │ ✓             │ ✓  /usr/local/bin/mas      │ ✓            │ ✓  1.6.3  │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Node's npm        │ npm      │ ✓             │ ✓  /usr/local/bin/npm      │ ✓            │ ✓  6.13.7 │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Node's yarn       │ yarn     │ ✓             │ ✓  /usr/local/bin/yarn     │ ✓            │ ✓  1.21.0 │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ OPKG              │ opkg     │ ✘  Linux only │ ✘  opkg CLI not found.     │              │           │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Python 2's Pip    │ pip2     │ ✓             │ ✘  pip2 CLI not found.     │              │           │\n    ├───────────────────┼──────────┼───────────────┼────────────────────────────┼──────────────┼───────────┤\n    │ Python 3's Pip    │ pip3     │ ✓             │ ✓  /usr/local/bin/pip3     │ ✓            │ ✓  20.0.2 │\n    ╘═══════════════════╧══════════╧═══════════════╧════════════════════════════╧══════════════╧═══════════╛\n",
    'author': 'Kevin Deldycke',
    'author_email': 'kevin@deldycke.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kdeldycke/meta-package-manager',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
