# Copyright 2021 The LeafNLP Team. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import shutil
from pathlib import Path

from setuptools import setup

# Remove stale leafnlp.egg-info directory to avoid 
# https://github.com/pypa/pip/issues/5466
# borrow from 
# https://github.com/huggingface/transformers
# https://github.com/allenai/allennlp/blob/master/allennlp
stale_egg_info = Path(__file__).parent / "leafnlp.egg-info"
if stale_egg_info.exists():
    print(("Warning: {} exists.\n\n"
           "This directory is automatically generated by Python packaging tools.\n"
           "See https://github.com/pypa/pip/issues/5466 for details.\n"
           ).format(stale_egg_info))
    shutil.rmtree(stale_egg_info)

setup(name="leafnlp",
      version="0.0.15",
      description="Domain-specific Natural Language Processing with LeafNLP",
      long_description=open("README.md").read(),
      long_description_content_type="text/markdown",
      keywords="leafnlp NLP Deep Learning",
      classifiers=[
          "Intended Audience :: Science/Research",
          "Development Status :: 3 - Alpha",
          "License :: OSI Approved :: Apache Software License",
          "Programming Language :: Python :: 3",
          "Topic :: Scientific/Engineering :: Artificial Intelligence"],
      url="https://leafnlp.org",
      author="The LeafNLP Team",
      author_email="",
      package_dir={"": "src"},
      packages=[
          "leafnlp.nlp.event_detection",
          "leafnlp.nlp.named_entity_recogonition",
          "leafnlp.nlp.text_ranking",
          "leafnlp.nlp.text_similarity",
        #   "leafnlp.nlp.tokenizer",
          "leafnlp.ml.modules.activation",
          "leafnlp.ml.modules.attention",
          "leafnlp.ml.modules.decoder",
          "leafnlp.ml.modules.decoding",
          "leafnlp.ml.modules.embedding",
          "leafnlp.ml.modules.encoder",
          "leafnlp.ml.modules.utils",
          "leafnlp.ml.sequence_tagging",
        #   "leafnlp.research.ed_false_annotation",
        #   "leafnlp.trainer.leafbase",
        #   "leafnlp.trainer.event_detection",
        #   "leafnlp.trainer.named_entity_recogonition",
        #   "leafnlp.trainer.ed_false_annotation"
        ],
      package_data={"leafnlp": ["py.typed"]},
      install_requires=[
          "numpy==1.21.2",
          "torch==1.9.1",
          "torchvision==0.10.1",
          "tqdm==4.49.0",
          "transformers==4.11.2"
        ],
      python_requires=">=3.8.10",
      include_package_data=True,
      zip_safe=False)
      
