
CSRF injection
-------

**Description:**

Cross-Site Request Forgery (CSRF) is a type of attack that occurs when a malicious Web site,
email, blog, instant message, or program causes a users Web browser to perform an unwanted
action on a trusted site for which the user is currently authenticated. 

The impact of a successful cross-site request forgery attack is limited to the 
capabilities exposed by the vulnerable application. For example, this attack could result 
in a transfer of funds, changing a password, or purchasing an item in the users context. 
In effect, CSRF attacks are used by an attacker to make a target system perform a 
function (funds Transfer, form submission etc.) via the targets browser without 
knowledge of the target user at least until the unauthorized function has been committed.



**Solution:**

To arm an application against automated attacks and tooling you need to use unique tokens 
who are included into the forms of an application, API calls or AJAX requests.  
Any state changing operation requires a secure random token (e.g CSRF token) to prevent 
against CSRF attacks. Characteristics of a CSRF Token are Unique and is a large random 
value generated by a cryptographically secure random number generator. 

The CSRF token is then added as a hidden field for forms or within the URL if the state 
changing operation if this occurs via a GET. The server need to reject the requested 
action if the CSRF token fails validation, for example missing or incorrect token.

	