from enum import Enum

class PrinterProcessingStateDetail(str, Enum):
    Paused = "paused",
    MediaJam = "mediaJam",
    MediaNeeded = "mediaNeeded",
    MediaLow = "mediaLow",
    MediaEmpty = "mediaEmpty",
    CoverOpen = "coverOpen",
    InterlockOpen = "interlockOpen",
    OutputTrayMissing = "outputTrayMissing",
    OutputAreaFull = "outputAreaFull",
    MarkerSupplyLow = "markerSupplyLow",
    MarkerSupplyEmpty = "markerSupplyEmpty",
    InputTrayMissing = "inputTrayMissing",
    OutputAreaAlmostFull = "outputAreaAlmostFull",
    MarkerWasteAlmostFull = "markerWasteAlmostFull",
    MarkerWasteFull = "markerWasteFull",
    FuserOverTemp = "fuserOverTemp",
    FuserUnderTemp = "fuserUnderTemp",
    Other = "other",
    None_ = "none",
    MovingToPaused = "movingToPaused",
    Shutdown = "shutdown",
    ConnectingToDevice = "connectingToDevice",
    TimedOut = "timedOut",
    Stopping = "stopping",
    StoppedPartially = "stoppedPartially",
    TonerLow = "tonerLow",
    TonerEmpty = "tonerEmpty",
    SpoolAreaFull = "spoolAreaFull",
    DoorOpen = "doorOpen",
    OpticalPhotoConductorNearEndOfLife = "opticalPhotoConductorNearEndOfLife",
    OpticalPhotoConductorLifeOver = "opticalPhotoConductorLifeOver",
    DeveloperLow = "developerLow",
    DeveloperEmpty = "developerEmpty",
    InterpreterResourceUnavailable = "interpreterResourceUnavailable",
    UnknownFutureValue = "unknownFutureValue",
    AlertRemovalOfBinaryChangeEntry = "alertRemovalOfBinaryChangeEntry",
    BanderAdded = "banderAdded",
    BanderAlmostEmpty = "banderAlmostEmpty",
    BanderAlmostFull = "banderAlmostFull",
    BanderAtLimit = "banderAtLimit",
    BanderClosed = "banderClosed",
    BanderConfigurationChange = "banderConfigurationChange",
    BanderCoverClosed = "banderCoverClosed",
    BanderCoverOpen = "banderCoverOpen",
    BanderEmpty = "banderEmpty",
    BanderFull = "banderFull",
    BanderInterlockClosed = "banderInterlockClosed",
    BanderInterlockOpen = "banderInterlockOpen",
    BanderJam = "banderJam",
    BanderLifeAlmostOver = "banderLifeAlmostOver",
    BanderLifeOver = "banderLifeOver",
    BanderMemoryExhausted = "banderMemoryExhausted",
    BanderMissing = "banderMissing",
    BanderMotorFailure = "banderMotorFailure",
    BanderNearLimit = "banderNearLimit",
    BanderOffline = "banderOffline",
    BanderOpened = "banderOpened",
    BanderOverTemperature = "banderOverTemperature",
    BanderPowerSaver = "banderPowerSaver",
    BanderRecoverableFailure = "banderRecoverableFailure",
    BanderRecoverableStorage = "banderRecoverableStorage",
    BanderRemoved = "banderRemoved",
    BanderResourceAdded = "banderResourceAdded",
    BanderResourceRemoved = "banderResourceRemoved",
    BanderThermistorFailure = "banderThermistorFailure",
    BanderTimingFailure = "banderTimingFailure",
    BanderTurnedOff = "banderTurnedOff",
    BanderTurnedOn = "banderTurnedOn",
    BanderUnderTemperature = "banderUnderTemperature",
    BanderUnrecoverableFailure = "banderUnrecoverableFailure",
    BanderUnrecoverableStorageError = "banderUnrecoverableStorageError",
    BanderWarmingUp = "banderWarmingUp",
    BinderAdded = "binderAdded",
    BinderAlmostEmpty = "binderAlmostEmpty",
    BinderAlmostFull = "binderAlmostFull",
    BinderAtLimit = "binderAtLimit",
    BinderClosed = "binderClosed",
    BinderConfigurationChange = "binderConfigurationChange",
    BinderCoverClosed = "binderCoverClosed",
    BinderCoverOpen = "binderCoverOpen",
    BinderEmpty = "binderEmpty",
    BinderFull = "binderFull",
    BinderInterlockClosed = "binderInterlockClosed",
    BinderInterlockOpen = "binderInterlockOpen",
    BinderJam = "binderJam",
    BinderLifeAlmostOver = "binderLifeAlmostOver",
    BinderLifeOver = "binderLifeOver",
    BinderMemoryExhausted = "binderMemoryExhausted",
    BinderMissing = "binderMissing",
    BinderMotorFailure = "binderMotorFailure",
    BinderNearLimit = "binderNearLimit",
    BinderOffline = "binderOffline",
    BinderOpened = "binderOpened",
    BinderOverTemperature = "binderOverTemperature",
    BinderPowerSaver = "binderPowerSaver",
    BinderRecoverableFailure = "binderRecoverableFailure",
    BinderRecoverableStorage = "binderRecoverableStorage",
    BinderRemoved = "binderRemoved",
    BinderResourceAdded = "binderResourceAdded",
    BinderResourceRemoved = "binderResourceRemoved",
    BinderThermistorFailure = "binderThermistorFailure",
    BinderTimingFailure = "binderTimingFailure",
    BinderTurnedOff = "binderTurnedOff",
    BinderTurnedOn = "binderTurnedOn",
    BinderUnderTemperature = "binderUnderTemperature",
    BinderUnrecoverableFailure = "binderUnrecoverableFailure",
    BinderUnrecoverableStorageError = "binderUnrecoverableStorageError",
    BinderWarmingUp = "binderWarmingUp",
    CameraFailure = "cameraFailure",
    ChamberCooling = "chamberCooling",
    ChamberFailure = "chamberFailure",
    ChamberHeating = "chamberHeating",
    ChamberTemperatureHigh = "chamberTemperatureHigh",
    ChamberTemperatureLow = "chamberTemperatureLow",
    CleanerLifeAlmostOver = "cleanerLifeAlmostOver",
    CleanerLifeOver = "cleanerLifeOver",
    ConfigurationChange = "configurationChange",
    Deactivated = "deactivated",
    Deleted = "deleted",
    DieCutterAdded = "dieCutterAdded",
    DieCutterAlmostEmpty = "dieCutterAlmostEmpty",
    DieCutterAlmostFull = "dieCutterAlmostFull",
    DieCutterAtLimit = "dieCutterAtLimit",
    DieCutterClosed = "dieCutterClosed",
    DieCutterConfigurationChange = "dieCutterConfigurationChange",
    DieCutterCoverClosed = "dieCutterCoverClosed",
    DieCutterCoverOpen = "dieCutterCoverOpen",
    DieCutterEmpty = "dieCutterEmpty",
    DieCutterFull = "dieCutterFull",
    DieCutterInterlockClosed = "dieCutterInterlockClosed",
    DieCutterInterlockOpen = "dieCutterInterlockOpen",
    DieCutterJam = "dieCutterJam",
    DieCutterLifeAlmostOver = "dieCutterLifeAlmostOver",
    DieCutterLifeOver = "dieCutterLifeOver",
    DieCutterMemoryExhausted = "dieCutterMemoryExhausted",
    DieCutterMissing = "dieCutterMissing",
    DieCutterMotorFailure = "dieCutterMotorFailure",
    DieCutterNearLimit = "dieCutterNearLimit",
    DieCutterOffline = "dieCutterOffline",
    DieCutterOpened = "dieCutterOpened",
    DieCutterOverTemperature = "dieCutterOverTemperature",
    DieCutterPowerSaver = "dieCutterPowerSaver",
    DieCutterRecoverableFailure = "dieCutterRecoverableFailure",
    DieCutterRecoverableStorage = "dieCutterRecoverableStorage",
    DieCutterRemoved = "dieCutterRemoved",
    DieCutterResourceAdded = "dieCutterResourceAdded",
    DieCutterResourceRemoved = "dieCutterResourceRemoved",
    DieCutterThermistorFailure = "dieCutterThermistorFailure",
    DieCutterTimingFailure = "dieCutterTimingFailure",
    DieCutterTurnedOff = "dieCutterTurnedOff",
    DieCutterTurnedOn = "dieCutterTurnedOn",
    DieCutterUnderTemperature = "dieCutterUnderTemperature",
    DieCutterUnrecoverableFailure = "dieCutterUnrecoverableFailure",
    DieCutterUnrecoverableStorageError = "dieCutterUnrecoverableStorageError",
    DieCutterWarmingUp = "dieCutterWarmingUp",
    ExtruderCooling = "extruderCooling",
    ExtruderFailure = "extruderFailure",
    ExtruderHeating = "extruderHeating",
    ExtruderJam = "extruderJam",
    ExtruderTemperatureHigh = "extruderTemperatureHigh",
    ExtruderTemperatureLow = "extruderTemperatureLow",
    FanFailure = "fanFailure",
    FaxModemLifeAlmostOver = "faxModemLifeAlmostOver",
    FaxModemLifeOver = "faxModemLifeOver",
    FaxModemMissing = "faxModemMissing",
    FaxModemTurnedOff = "faxModemTurnedOff",
    FaxModemTurnedOn = "faxModemTurnedOn",
    FolderAdded = "folderAdded",
    FolderAlmostEmpty = "folderAlmostEmpty",
    FolderAlmostFull = "folderAlmostFull",
    FolderAtLimit = "folderAtLimit",
    FolderClosed = "folderClosed",
    FolderConfigurationChange = "folderConfigurationChange",
    FolderCoverClosed = "folderCoverClosed",
    FolderCoverOpen = "folderCoverOpen",
    FolderEmpty = "folderEmpty",
    FolderFull = "folderFull",
    FolderInterlockClosed = "folderInterlockClosed",
    FolderInterlockOpen = "folderInterlockOpen",
    FolderJam = "folderJam",
    FolderLifeAlmostOver = "folderLifeAlmostOver",
    FolderLifeOver = "folderLifeOver",
    FolderMemoryExhausted = "folderMemoryExhausted",
    FolderMissing = "folderMissing",
    FolderMotorFailure = "folderMotorFailure",
    FolderNearLimit = "folderNearLimit",
    FolderOffline = "folderOffline",
    FolderOpened = "folderOpened",
    FolderOverTemperature = "folderOverTemperature",
    FolderPowerSaver = "folderPowerSaver",
    FolderRecoverableFailure = "folderRecoverableFailure",
    FolderRecoverableStorage = "folderRecoverableStorage",
    FolderRemoved = "folderRemoved",
    FolderResourceAdded = "folderResourceAdded",
    FolderResourceRemoved = "folderResourceRemoved",
    FolderThermistorFailure = "folderThermistorFailure",
    FolderTimingFailure = "folderTimingFailure",
    FolderTurnedOff = "folderTurnedOff",
    FolderTurnedOn = "folderTurnedOn",
    FolderUnderTemperature = "folderUnderTemperature",
    FolderUnrecoverableFailure = "folderUnrecoverableFailure",
    FolderUnrecoverableStorageError = "folderUnrecoverableStorageError",
    FolderWarmingUp = "folderWarmingUp",
    Hibernate = "hibernate",
    HoldNewJobs = "holdNewJobs",
    IdentifyPrinterRequested = "identifyPrinterRequested",
    ImprinterAdded = "imprinterAdded",
    ImprinterAlmostEmpty = "imprinterAlmostEmpty",
    ImprinterAlmostFull = "imprinterAlmostFull",
    ImprinterAtLimit = "imprinterAtLimit",
    ImprinterClosed = "imprinterClosed",
    ImprinterConfigurationChange = "imprinterConfigurationChange",
    ImprinterCoverClosed = "imprinterCoverClosed",
    ImprinterCoverOpen = "imprinterCoverOpen",
    ImprinterEmpty = "imprinterEmpty",
    ImprinterFull = "imprinterFull",
    ImprinterInterlockClosed = "imprinterInterlockClosed",
    ImprinterInterlockOpen = "imprinterInterlockOpen",
    ImprinterJam = "imprinterJam",
    ImprinterLifeAlmostOver = "imprinterLifeAlmostOver",
    ImprinterLifeOver = "imprinterLifeOver",
    ImprinterMemoryExhausted = "imprinterMemoryExhausted",
    ImprinterMissing = "imprinterMissing",
    ImprinterMotorFailure = "imprinterMotorFailure",
    ImprinterNearLimit = "imprinterNearLimit",
    ImprinterOffline = "imprinterOffline",
    ImprinterOpened = "imprinterOpened",
    ImprinterOverTemperature = "imprinterOverTemperature",
    ImprinterPowerSaver = "imprinterPowerSaver",
    ImprinterRecoverableFailure = "imprinterRecoverableFailure",
    ImprinterRecoverableStorage = "imprinterRecoverableStorage",
    ImprinterRemoved = "imprinterRemoved",
    ImprinterResourceAdded = "imprinterResourceAdded",
    ImprinterResourceRemoved = "imprinterResourceRemoved",
    ImprinterThermistorFailure = "imprinterThermistorFailure",
    ImprinterTimingFailure = "imprinterTimingFailure",
    ImprinterTurnedOff = "imprinterTurnedOff",
    ImprinterTurnedOn = "imprinterTurnedOn",
    ImprinterUnderTemperature = "imprinterUnderTemperature",
    ImprinterUnrecoverableFailure = "imprinterUnrecoverableFailure",
    ImprinterUnrecoverableStorageError = "imprinterUnrecoverableStorageError",
    ImprinterWarmingUp = "imprinterWarmingUp",
    InputCannotFeedSizeSelected = "inputCannotFeedSizeSelected",
    InputManualInputRequest = "inputManualInputRequest",
    InputMediaColorChange = "inputMediaColorChange",
    InputMediaFormPartsChange = "inputMediaFormPartsChange",
    InputMediaSizeChange = "inputMediaSizeChange",
    InputMediaTrayFailure = "inputMediaTrayFailure",
    InputMediaTrayFeedError = "inputMediaTrayFeedError",
    InputMediaTrayJam = "inputMediaTrayJam",
    InputMediaTypeChange = "inputMediaTypeChange",
    InputMediaWeightChange = "inputMediaWeightChange",
    InputPickRollerFailure = "inputPickRollerFailure",
    InputPickRollerLifeOver = "inputPickRollerLifeOver",
    InputPickRollerLifeWarn = "inputPickRollerLifeWarn",
    InputPickRollerMissing = "inputPickRollerMissing",
    InputTrayElevationFailure = "inputTrayElevationFailure",
    InputTrayPositionFailure = "inputTrayPositionFailure",
    InserterAdded = "inserterAdded",
    InserterAlmostEmpty = "inserterAlmostEmpty",
    InserterAlmostFull = "inserterAlmostFull",
    InserterAtLimit = "inserterAtLimit",
    InserterClosed = "inserterClosed",
    InserterConfigurationChange = "inserterConfigurationChange",
    InserterCoverClosed = "inserterCoverClosed",
    InserterCoverOpen = "inserterCoverOpen",
    InserterEmpty = "inserterEmpty",
    InserterFull = "inserterFull",
    InserterInterlockClosed = "inserterInterlockClosed",
    InserterInterlockOpen = "inserterInterlockOpen",
    InserterJam = "inserterJam",
    InserterLifeAlmostOver = "inserterLifeAlmostOver",
    InserterLifeOver = "inserterLifeOver",
    InserterMemoryExhausted = "inserterMemoryExhausted",
    InserterMissing = "inserterMissing",
    InserterMotorFailure = "inserterMotorFailure",
    InserterNearLimit = "inserterNearLimit",
    InserterOffline = "inserterOffline",
    InserterOpened = "inserterOpened",
    InserterOverTemperature = "inserterOverTemperature",
    InserterPowerSaver = "inserterPowerSaver",
    InserterRecoverableFailure = "inserterRecoverableFailure",
    InserterRecoverableStorage = "inserterRecoverableStorage",
    InserterRemoved = "inserterRemoved",
    InserterResourceAdded = "inserterResourceAdded",
    InserterResourceRemoved = "inserterResourceRemoved",
    InserterThermistorFailure = "inserterThermistorFailure",
    InserterTimingFailure = "inserterTimingFailure",
    InserterTurnedOff = "inserterTurnedOff",
    InserterTurnedOn = "inserterTurnedOn",
    InserterUnderTemperature = "inserterUnderTemperature",
    InserterUnrecoverableFailure = "inserterUnrecoverableFailure",
    InserterUnrecoverableStorageError = "inserterUnrecoverableStorageError",
    InserterWarmingUp = "inserterWarmingUp",
    InterlockClosed = "interlockClosed",
    InterpreterCartridgeAdded = "interpreterCartridgeAdded",
    InterpreterCartridgeDeleted = "interpreterCartridgeDeleted",
    InterpreterComplexPageEncountered = "interpreterComplexPageEncountered",
    InterpreterMemoryDecrease = "interpreterMemoryDecrease",
    InterpreterMemoryIncrease = "interpreterMemoryIncrease",
    InterpreterResourceAdded = "interpreterResourceAdded",
    InterpreterResourceDeleted = "interpreterResourceDeleted",
    LampAtEol = "lampAtEol",
    LampFailure = "lampFailure",
    LampNearEol = "lampNearEol",
    LaserAtEol = "laserAtEol",
    LaserFailure = "laserFailure",
    LaserNearEol = "laserNearEol",
    MakeEnvelopeAdded = "makeEnvelopeAdded",
    MakeEnvelopeAlmostEmpty = "makeEnvelopeAlmostEmpty",
    MakeEnvelopeAlmostFull = "makeEnvelopeAlmostFull",
    MakeEnvelopeAtLimit = "makeEnvelopeAtLimit",
    MakeEnvelopeClosed = "makeEnvelopeClosed",
    MakeEnvelopeConfigurationChange = "makeEnvelopeConfigurationChange",
    MakeEnvelopeCoverClosed = "makeEnvelopeCoverClosed",
    MakeEnvelopeCoverOpen = "makeEnvelopeCoverOpen",
    MakeEnvelopeEmpty = "makeEnvelopeEmpty",
    MakeEnvelopeFull = "makeEnvelopeFull",
    MakeEnvelopeInterlockClosed = "makeEnvelopeInterlockClosed",
    MakeEnvelopeInterlockOpen = "makeEnvelopeInterlockOpen",
    MakeEnvelopeJam = "makeEnvelopeJam",
    MakeEnvelopeLifeAlmostOver = "makeEnvelopeLifeAlmostOver",
    MakeEnvelopeLifeOver = "makeEnvelopeLifeOver",
    MakeEnvelopeMemoryExhausted = "makeEnvelopeMemoryExhausted",
    MakeEnvelopeMissing = "makeEnvelopeMissing",
    MakeEnvelopeMotorFailure = "makeEnvelopeMotorFailure",
    MakeEnvelopeNearLimit = "makeEnvelopeNearLimit",
    MakeEnvelopeOffline = "makeEnvelopeOffline",
    MakeEnvelopeOpened = "makeEnvelopeOpened",
    MakeEnvelopeOverTemperature = "makeEnvelopeOverTemperature",
    MakeEnvelopePowerSaver = "makeEnvelopePowerSaver",
    MakeEnvelopeRecoverableFailure = "makeEnvelopeRecoverableFailure",
    MakeEnvelopeRecoverableStorage = "makeEnvelopeRecoverableStorage",
    MakeEnvelopeRemoved = "makeEnvelopeRemoved",
    MakeEnvelopeResourceAdded = "makeEnvelopeResourceAdded",
    MakeEnvelopeResourceRemoved = "makeEnvelopeResourceRemoved",
    MakeEnvelopeThermistorFailure = "makeEnvelopeThermistorFailure",
    MakeEnvelopeTimingFailure = "makeEnvelopeTimingFailure",
    MakeEnvelopeTurnedOff = "makeEnvelopeTurnedOff",
    MakeEnvelopeTurnedOn = "makeEnvelopeTurnedOn",
    MakeEnvelopeUnderTemperature = "makeEnvelopeUnderTemperature",
    MakeEnvelopeUnrecoverableFailure = "makeEnvelopeUnrecoverableFailure",
    MakeEnvelopeUnrecoverableStorageError = "makeEnvelopeUnrecoverableStorageError",
    MakeEnvelopeWarmingUp = "makeEnvelopeWarmingUp",
    MarkerAdjustingPrintQuality = "markerAdjustingPrintQuality",
    MarkerCleanerMissing = "markerCleanerMissing",
    MarkerDeveloperAlmostEmpty = "markerDeveloperAlmostEmpty",
    MarkerDeveloperEmpty = "markerDeveloperEmpty",
    MarkerDeveloperMissing = "markerDeveloperMissing",
    MarkerFuserMissing = "markerFuserMissing",
    MarkerFuserThermistorFailure = "markerFuserThermistorFailure",
    MarkerFuserTimingFailure = "markerFuserTimingFailure",
    MarkerInkAlmostEmpty = "markerInkAlmostEmpty",
    MarkerInkEmpty = "markerInkEmpty",
    MarkerInkMissing = "markerInkMissing",
    MarkerOpcMissing = "markerOpcMissing",
    MarkerPrintRibbonAlmostEmpty = "markerPrintRibbonAlmostEmpty",
    MarkerPrintRibbonEmpty = "markerPrintRibbonEmpty",
    MarkerPrintRibbonMissing = "markerPrintRibbonMissing",
    MarkerSupplyAlmostEmpty = "markerSupplyAlmostEmpty",
    MarkerSupplyMissing = "markerSupplyMissing",
    MarkerTonerCartridgeMissing = "markerTonerCartridgeMissing",
    MarkerTonerMissing = "markerTonerMissing",
    MarkerWasteInkReceptacleAlmostFull = "markerWasteInkReceptacleAlmostFull",
    MarkerWasteInkReceptacleFull = "markerWasteInkReceptacleFull",
    MarkerWasteInkReceptacleMissing = "markerWasteInkReceptacleMissing",
    MarkerWasteMissing = "markerWasteMissing",
    MarkerWasteTonerReceptacleAlmostFull = "markerWasteTonerReceptacleAlmostFull",
    MarkerWasteTonerReceptacleFull = "markerWasteTonerReceptacleFull",
    MarkerWasteTonerReceptacleMissing = "markerWasteTonerReceptacleMissing",
    MaterialEmpty = "materialEmpty",
    MaterialLow = "materialLow",
    MaterialNeeded = "materialNeeded",
    MediaDrying = "mediaDrying",
    MediaPathCannotDuplexMediaSelected = "mediaPathCannotDuplexMediaSelected",
    MediaPathFailure = "mediaPathFailure",
    MediaPathInputEmpty = "mediaPathInputEmpty",
    MediaPathInputFeedError = "mediaPathInputFeedError",
    MediaPathInputJam = "mediaPathInputJam",
    MediaPathInputRequest = "mediaPathInputRequest",
    MediaPathJam = "mediaPathJam",
    MediaPathMediaTrayAlmostFull = "mediaPathMediaTrayAlmostFull",
    MediaPathMediaTrayFull = "mediaPathMediaTrayFull",
    MediaPathMediaTrayMissing = "mediaPathMediaTrayMissing",
    MediaPathOutputFeedError = "mediaPathOutputFeedError",
    MediaPathOutputFull = "mediaPathOutputFull",
    MediaPathOutputJam = "mediaPathOutputJam",
    MediaPathPickRollerFailure = "mediaPathPickRollerFailure",
    MediaPathPickRollerLifeOver = "mediaPathPickRollerLifeOver",
    MediaPathPickRollerLifeWarn = "mediaPathPickRollerLifeWarn",
    MediaPathPickRollerMissing = "mediaPathPickRollerMissing",
    MotorFailure = "motorFailure",
    OutputMailboxSelectFailure = "outputMailboxSelectFailure",
    OutputMediaTrayFailure = "outputMediaTrayFailure",
    OutputMediaTrayFeedError = "outputMediaTrayFeedError",
    OutputMediaTrayJam = "outputMediaTrayJam",
    PerforaterAdded = "perforaterAdded",
    PerforaterAlmostEmpty = "perforaterAlmostEmpty",
    PerforaterAlmostFull = "perforaterAlmostFull",
    PerforaterAtLimit = "perforaterAtLimit",
    PerforaterClosed = "perforaterClosed",
    PerforaterConfigurationChange = "perforaterConfigurationChange",
    PerforaterCoverClosed = "perforaterCoverClosed",
    PerforaterCoverOpen = "perforaterCoverOpen",
    PerforaterEmpty = "perforaterEmpty",
    PerforaterFull = "perforaterFull",
    PerforaterInterlockClosed = "perforaterInterlockClosed",
    PerforaterInterlockOpen = "perforaterInterlockOpen",
    PerforaterJam = "perforaterJam",
    PerforaterLifeAlmostOver = "perforaterLifeAlmostOver",
    PerforaterLifeOver = "perforaterLifeOver",
    PerforaterMemoryExhausted = "perforaterMemoryExhausted",
    PerforaterMissing = "perforaterMissing",
    PerforaterMotorFailure = "perforaterMotorFailure",
    PerforaterNearLimit = "perforaterNearLimit",
    PerforaterOffline = "perforaterOffline",
    PerforaterOpened = "perforaterOpened",
    PerforaterOverTemperature = "perforaterOverTemperature",
    PerforaterPowerSaver = "perforaterPowerSaver",
    PerforaterRecoverableFailure = "perforaterRecoverableFailure",
    PerforaterRecoverableStorage = "perforaterRecoverableStorage",
    PerforaterRemoved = "perforaterRemoved",
    PerforaterResourceAdded = "perforaterResourceAdded",
    PerforaterResourceRemoved = "perforaterResourceRemoved",
    PerforaterThermistorFailure = "perforaterThermistorFailure",
    PerforaterTimingFailure = "perforaterTimingFailure",
    PerforaterTurnedOff = "perforaterTurnedOff",
    PerforaterTurnedOn = "perforaterTurnedOn",
    PerforaterUnderTemperature = "perforaterUnderTemperature",
    PerforaterUnrecoverableFailure = "perforaterUnrecoverableFailure",
    PerforaterUnrecoverableStorageError = "perforaterUnrecoverableStorageError",
    PerforaterWarmingUp = "perforaterWarmingUp",
    PlatformCooling = "platformCooling",
    PlatformFailure = "platformFailure",
    PlatformHeating = "platformHeating",
    PlatformTemperatureHigh = "platformTemperatureHigh",
    PlatformTemperatureLow = "platformTemperatureLow",
    PowerDown = "powerDown",
    PowerUp = "powerUp",
    PrinterManualReset = "printerManualReset",
    PrinterNmsReset = "printerNmsReset",
    PrinterReadyToPrint = "printerReadyToPrint",
    PuncherAdded = "puncherAdded",
    PuncherAlmostEmpty = "puncherAlmostEmpty",
    PuncherAlmostFull = "puncherAlmostFull",
    PuncherAtLimit = "puncherAtLimit",
    PuncherClosed = "puncherClosed",
    PuncherConfigurationChange = "puncherConfigurationChange",
    PuncherCoverClosed = "puncherCoverClosed",
    PuncherCoverOpen = "puncherCoverOpen",
    PuncherEmpty = "puncherEmpty",
    PuncherFull = "puncherFull",
    PuncherInterlockClosed = "puncherInterlockClosed",
    PuncherInterlockOpen = "puncherInterlockOpen",
    PuncherJam = "puncherJam",
    PuncherLifeAlmostOver = "puncherLifeAlmostOver",
    PuncherLifeOver = "puncherLifeOver",
    PuncherMemoryExhausted = "puncherMemoryExhausted",
    PuncherMissing = "puncherMissing",
    PuncherMotorFailure = "puncherMotorFailure",
    PuncherNearLimit = "puncherNearLimit",
    PuncherOffline = "puncherOffline",
    PuncherOpened = "puncherOpened",
    PuncherOverTemperature = "puncherOverTemperature",
    PuncherPowerSaver = "puncherPowerSaver",
    PuncherRecoverableFailure = "puncherRecoverableFailure",
    PuncherRecoverableStorage = "puncherRecoverableStorage",
    PuncherRemoved = "puncherRemoved",
    PuncherResourceAdded = "puncherResourceAdded",
    PuncherResourceRemoved = "puncherResourceRemoved",
    PuncherThermistorFailure = "puncherThermistorFailure",
    PuncherTimingFailure = "puncherTimingFailure",
    PuncherTurnedOff = "puncherTurnedOff",
    PuncherTurnedOn = "puncherTurnedOn",
    PuncherUnderTemperature = "puncherUnderTemperature",
    PuncherUnrecoverableFailure = "puncherUnrecoverableFailure",
    PuncherUnrecoverableStorageError = "puncherUnrecoverableStorageError",
    PuncherWarmingUp = "puncherWarmingUp",
    Resuming = "resuming",
    ScanMediaPathFailure = "scanMediaPathFailure",
    ScanMediaPathInputEmpty = "scanMediaPathInputEmpty",
    ScanMediaPathInputFeedError = "scanMediaPathInputFeedError",
    ScanMediaPathInputJam = "scanMediaPathInputJam",
    ScanMediaPathInputRequest = "scanMediaPathInputRequest",
    ScanMediaPathJam = "scanMediaPathJam",
    ScanMediaPathOutputFeedError = "scanMediaPathOutputFeedError",
    ScanMediaPathOutputFull = "scanMediaPathOutputFull",
    ScanMediaPathOutputJam = "scanMediaPathOutputJam",
    ScanMediaPathPickRollerFailure = "scanMediaPathPickRollerFailure",
    ScanMediaPathPickRollerLifeOver = "scanMediaPathPickRollerLifeOver",
    ScanMediaPathPickRollerLifeWarn = "scanMediaPathPickRollerLifeWarn",
    ScanMediaPathPickRollerMissing = "scanMediaPathPickRollerMissing",
    ScanMediaPathTrayAlmostFull = "scanMediaPathTrayAlmostFull",
    ScanMediaPathTrayFull = "scanMediaPathTrayFull",
    ScanMediaPathTrayMissing = "scanMediaPathTrayMissing",
    ScannerLightFailure = "scannerLightFailure",
    ScannerLightLifeAlmostOver = "scannerLightLifeAlmostOver",
    ScannerLightLifeOver = "scannerLightLifeOver",
    ScannerLightMissing = "scannerLightMissing",
    ScannerSensorFailure = "scannerSensorFailure",
    ScannerSensorLifeAlmostOver = "scannerSensorLifeAlmostOver",
    ScannerSensorLifeOver = "scannerSensorLifeOver",
    ScannerSensorMissing = "scannerSensorMissing",
    SeparationCutterAdded = "separationCutterAdded",
    SeparationCutterAlmostEmpty = "separationCutterAlmostEmpty",
    SeparationCutterAlmostFull = "separationCutterAlmostFull",
    SeparationCutterAtLimit = "separationCutterAtLimit",
    SeparationCutterClosed = "separationCutterClosed",
    SeparationCutterConfigurationChange = "separationCutterConfigurationChange",
    SeparationCutterCoverClosed = "separationCutterCoverClosed",
    SeparationCutterCoverOpen = "separationCutterCoverOpen",
    SeparationCutterEmpty = "separationCutterEmpty",
    SeparationCutterFull = "separationCutterFull",
    SeparationCutterInterlockClosed = "separationCutterInterlockClosed",
    SeparationCutterInterlockOpen = "separationCutterInterlockOpen",
    SeparationCutterJam = "separationCutterJam",
    SeparationCutterLifeAlmostOver = "separationCutterLifeAlmostOver",
    SeparationCutterLifeOver = "separationCutterLifeOver",
    SeparationCutterMemoryExhausted = "separationCutterMemoryExhausted",
    SeparationCutterMissing = "separationCutterMissing",
    SeparationCutterMotorFailure = "separationCutterMotorFailure",
    SeparationCutterNearLimit = "separationCutterNearLimit",
    SeparationCutterOffline = "separationCutterOffline",
    SeparationCutterOpened = "separationCutterOpened",
    SeparationCutterOverTemperature = "separationCutterOverTemperature",
    SeparationCutterPowerSaver = "separationCutterPowerSaver",
    SeparationCutterRecoverableFailure = "separationCutterRecoverableFailure",
    SeparationCutterRecoverableStorage = "separationCutterRecoverableStorage",
    SeparationCutterRemoved = "separationCutterRemoved",
    SeparationCutterResourceAdded = "separationCutterResourceAdded",
    SeparationCutterResourceRemoved = "separationCutterResourceRemoved",
    SeparationCutterThermistorFailure = "separationCutterThermistorFailure",
    SeparationCutterTimingFailure = "separationCutterTimingFailure",
    SeparationCutterTurnedOff = "separationCutterTurnedOff",
    SeparationCutterTurnedOn = "separationCutterTurnedOn",
    SeparationCutterUnderTemperature = "separationCutterUnderTemperature",
    SeparationCutterUnrecoverableFailure = "separationCutterUnrecoverableFailure",
    SeparationCutterUnrecoverableStorageError = "separationCutterUnrecoverableStorageError",
    SeparationCutterWarmingUp = "separationCutterWarmingUp",
    SheetRotatorAdded = "sheetRotatorAdded",
    SheetRotatorAlmostEmpty = "sheetRotatorAlmostEmpty",
    SheetRotatorAlmostFull = "sheetRotatorAlmostFull",
    SheetRotatorAtLimit = "sheetRotatorAtLimit",
    SheetRotatorClosed = "sheetRotatorClosed",
    SheetRotatorConfigurationChange = "sheetRotatorConfigurationChange",
    SheetRotatorCoverClosed = "sheetRotatorCoverClosed",
    SheetRotatorCoverOpen = "sheetRotatorCoverOpen",
    SheetRotatorEmpty = "sheetRotatorEmpty",
    SheetRotatorFull = "sheetRotatorFull",
    SheetRotatorInterlockClosed = "sheetRotatorInterlockClosed",
    SheetRotatorInterlockOpen = "sheetRotatorInterlockOpen",
    SheetRotatorJam = "sheetRotatorJam",
    SheetRotatorLifeAlmostOver = "sheetRotatorLifeAlmostOver",
    SheetRotatorLifeOver = "sheetRotatorLifeOver",
    SheetRotatorMemoryExhausted = "sheetRotatorMemoryExhausted",
    SheetRotatorMissing = "sheetRotatorMissing",
    SheetRotatorMotorFailure = "sheetRotatorMotorFailure",
    SheetRotatorNearLimit = "sheetRotatorNearLimit",
    SheetRotatorOffline = "sheetRotatorOffline",
    SheetRotatorOpened = "sheetRotatorOpened",
    SheetRotatorOverTemperature = "sheetRotatorOverTemperature",
    SheetRotatorPowerSaver = "sheetRotatorPowerSaver",
    SheetRotatorRecoverableFailure = "sheetRotatorRecoverableFailure",
    SheetRotatorRecoverableStorage = "sheetRotatorRecoverableStorage",
    SheetRotatorRemoved = "sheetRotatorRemoved",
    SheetRotatorResourceAdded = "sheetRotatorResourceAdded",
    SheetRotatorResourceRemoved = "sheetRotatorResourceRemoved",
    SheetRotatorThermistorFailure = "sheetRotatorThermistorFailure",
    SheetRotatorTimingFailure = "sheetRotatorTimingFailure",
    SheetRotatorTurnedOff = "sheetRotatorTurnedOff",
    SheetRotatorTurnedOn = "sheetRotatorTurnedOn",
    SheetRotatorUnderTemperature = "sheetRotatorUnderTemperature",
    SheetRotatorUnrecoverableFailure = "sheetRotatorUnrecoverableFailure",
    SheetRotatorUnrecoverableStorageError = "sheetRotatorUnrecoverableStorageError",
    SheetRotatorWarmingUp = "sheetRotatorWarmingUp",
    SlitterAdded = "slitterAdded",
    SlitterAlmostEmpty = "slitterAlmostEmpty",
    SlitterAlmostFull = "slitterAlmostFull",
    SlitterAtLimit = "slitterAtLimit",
    SlitterClosed = "slitterClosed",
    SlitterConfigurationChange = "slitterConfigurationChange",
    SlitterCoverClosed = "slitterCoverClosed",
    SlitterCoverOpen = "slitterCoverOpen",
    SlitterEmpty = "slitterEmpty",
    SlitterFull = "slitterFull",
    SlitterInterlockClosed = "slitterInterlockClosed",
    SlitterInterlockOpen = "slitterInterlockOpen",
    SlitterJam = "slitterJam",
    SlitterLifeAlmostOver = "slitterLifeAlmostOver",
    SlitterLifeOver = "slitterLifeOver",
    SlitterMemoryExhausted = "slitterMemoryExhausted",
    SlitterMissing = "slitterMissing",
    SlitterMotorFailure = "slitterMotorFailure",
    SlitterNearLimit = "slitterNearLimit",
    SlitterOffline = "slitterOffline",
    SlitterOpened = "slitterOpened",
    SlitterOverTemperature = "slitterOverTemperature",
    SlitterPowerSaver = "slitterPowerSaver",
    SlitterRecoverableFailure = "slitterRecoverableFailure",
    SlitterRecoverableStorage = "slitterRecoverableStorage",
    SlitterRemoved = "slitterRemoved",
    SlitterResourceAdded = "slitterResourceAdded",
    SlitterResourceRemoved = "slitterResourceRemoved",
    SlitterThermistorFailure = "slitterThermistorFailure",
    SlitterTimingFailure = "slitterTimingFailure",
    SlitterTurnedOff = "slitterTurnedOff",
    SlitterTurnedOn = "slitterTurnedOn",
    SlitterUnderTemperature = "slitterUnderTemperature",
    SlitterUnrecoverableFailure = "slitterUnrecoverableFailure",
    SlitterUnrecoverableStorageError = "slitterUnrecoverableStorageError",
    SlitterWarmingUp = "slitterWarmingUp",
    StackerAdded = "stackerAdded",
    StackerAlmostEmpty = "stackerAlmostEmpty",
    StackerAlmostFull = "stackerAlmostFull",
    StackerAtLimit = "stackerAtLimit",
    StackerClosed = "stackerClosed",
    StackerConfigurationChange = "stackerConfigurationChange",
    StackerCoverClosed = "stackerCoverClosed",
    StackerCoverOpen = "stackerCoverOpen",
    StackerEmpty = "stackerEmpty",
    StackerFull = "stackerFull",
    StackerInterlockClosed = "stackerInterlockClosed",
    StackerInterlockOpen = "stackerInterlockOpen",
    StackerJam = "stackerJam",
    StackerLifeAlmostOver = "stackerLifeAlmostOver",
    StackerLifeOver = "stackerLifeOver",
    StackerMemoryExhausted = "stackerMemoryExhausted",
    StackerMissing = "stackerMissing",
    StackerMotorFailure = "stackerMotorFailure",
    StackerNearLimit = "stackerNearLimit",
    StackerOffline = "stackerOffline",
    StackerOpened = "stackerOpened",
    StackerOverTemperature = "stackerOverTemperature",
    StackerPowerSaver = "stackerPowerSaver",
    StackerRecoverableFailure = "stackerRecoverableFailure",
    StackerRecoverableStorage = "stackerRecoverableStorage",
    StackerRemoved = "stackerRemoved",
    StackerResourceAdded = "stackerResourceAdded",
    StackerResourceRemoved = "stackerResourceRemoved",
    StackerThermistorFailure = "stackerThermistorFailure",
    StackerTimingFailure = "stackerTimingFailure",
    StackerTurnedOff = "stackerTurnedOff",
    StackerTurnedOn = "stackerTurnedOn",
    StackerUnderTemperature = "stackerUnderTemperature",
    StackerUnrecoverableFailure = "stackerUnrecoverableFailure",
    StackerUnrecoverableStorageError = "stackerUnrecoverableStorageError",
    StackerWarmingUp = "stackerWarmingUp",
    Standby = "standby",
    StaplerAdded = "staplerAdded",
    StaplerAlmostEmpty = "staplerAlmostEmpty",
    StaplerAlmostFull = "staplerAlmostFull",
    StaplerAtLimit = "staplerAtLimit",
    StaplerClosed = "staplerClosed",
    StaplerConfigurationChange = "staplerConfigurationChange",
    StaplerCoverClosed = "staplerCoverClosed",
    StaplerCoverOpen = "staplerCoverOpen",
    StaplerEmpty = "staplerEmpty",
    StaplerFull = "staplerFull",
    StaplerInterlockClosed = "staplerInterlockClosed",
    StaplerInterlockOpen = "staplerInterlockOpen",
    StaplerJam = "staplerJam",
    StaplerLifeAlmostOver = "staplerLifeAlmostOver",
    StaplerLifeOver = "staplerLifeOver",
    StaplerMemoryExhausted = "staplerMemoryExhausted",
    StaplerMissing = "staplerMissing",
    StaplerMotorFailure = "staplerMotorFailure",
    StaplerNearLimit = "staplerNearLimit",
    StaplerOffline = "staplerOffline",
    StaplerOpened = "staplerOpened",
    StaplerOverTemperature = "staplerOverTemperature",
    StaplerPowerSaver = "staplerPowerSaver",
    StaplerRecoverableFailure = "staplerRecoverableFailure",
    StaplerRecoverableStorage = "staplerRecoverableStorage",
    StaplerRemoved = "staplerRemoved",
    StaplerResourceAdded = "staplerResourceAdded",
    StaplerResourceRemoved = "staplerResourceRemoved",
    StaplerThermistorFailure = "staplerThermistorFailure",
    StaplerTimingFailure = "staplerTimingFailure",
    StaplerTurnedOff = "staplerTurnedOff",
    StaplerTurnedOn = "staplerTurnedOn",
    StaplerUnderTemperature = "staplerUnderTemperature",
    StaplerUnrecoverableFailure = "staplerUnrecoverableFailure",
    StaplerUnrecoverableStorageError = "staplerUnrecoverableStorageError",
    StaplerWarmingUp = "staplerWarmingUp",
    StitcherAdded = "stitcherAdded",
    StitcherAlmostEmpty = "stitcherAlmostEmpty",
    StitcherAlmostFull = "stitcherAlmostFull",
    StitcherAtLimit = "stitcherAtLimit",
    StitcherClosed = "stitcherClosed",
    StitcherConfigurationChange = "stitcherConfigurationChange",
    StitcherCoverClosed = "stitcherCoverClosed",
    StitcherCoverOpen = "stitcherCoverOpen",
    StitcherEmpty = "stitcherEmpty",
    StitcherFull = "stitcherFull",
    StitcherInterlockClosed = "stitcherInterlockClosed",
    StitcherInterlockOpen = "stitcherInterlockOpen",
    StitcherJam = "stitcherJam",
    StitcherLifeAlmostOver = "stitcherLifeAlmostOver",
    StitcherLifeOver = "stitcherLifeOver",
    StitcherMemoryExhausted = "stitcherMemoryExhausted",
    StitcherMissing = "stitcherMissing",
    StitcherMotorFailure = "stitcherMotorFailure",
    StitcherNearLimit = "stitcherNearLimit",
    StitcherOffline = "stitcherOffline",
    StitcherOpened = "stitcherOpened",
    StitcherOverTemperature = "stitcherOverTemperature",
    StitcherPowerSaver = "stitcherPowerSaver",
    StitcherRecoverableFailure = "stitcherRecoverableFailure",
    StitcherRecoverableStorage = "stitcherRecoverableStorage",
    StitcherRemoved = "stitcherRemoved",
    StitcherResourceAdded = "stitcherResourceAdded",
    StitcherResourceRemoved = "stitcherResourceRemoved",
    StitcherThermistorFailure = "stitcherThermistorFailure",
    StitcherTimingFailure = "stitcherTimingFailure",
    StitcherTurnedOff = "stitcherTurnedOff",
    StitcherTurnedOn = "stitcherTurnedOn",
    StitcherUnderTemperature = "stitcherUnderTemperature",
    StitcherUnrecoverableFailure = "stitcherUnrecoverableFailure",
    StitcherUnrecoverableStorageError = "stitcherUnrecoverableStorageError",
    StitcherWarmingUp = "stitcherWarmingUp",
    SubunitAdded = "subunitAdded",
    SubunitAlmostEmpty = "subunitAlmostEmpty",
    SubunitAlmostFull = "subunitAlmostFull",
    SubunitAtLimit = "subunitAtLimit",
    SubunitClosed = "subunitClosed",
    SubunitCoolingDown = "subunitCoolingDown",
    SubunitEmpty = "subunitEmpty",
    SubunitFull = "subunitFull",
    SubunitLifeAlmostOver = "subunitLifeAlmostOver",
    SubunitLifeOver = "subunitLifeOver",
    SubunitMemoryExhausted = "subunitMemoryExhausted",
    SubunitMissing = "subunitMissing",
    SubunitMotorFailure = "subunitMotorFailure",
    SubunitNearLimit = "subunitNearLimit",
    SubunitOffline = "subunitOffline",
    SubunitOpened = "subunitOpened",
    SubunitOverTemperature = "subunitOverTemperature",
    SubunitPowerSaver = "subunitPowerSaver",
    SubunitRecoverableFailure = "subunitRecoverableFailure",
    SubunitRecoverableStorage = "subunitRecoverableStorage",
    SubunitRemoved = "subunitRemoved",
    SubunitResourceAdded = "subunitResourceAdded",
    SubunitResourceRemoved = "subunitResourceRemoved",
    SubunitThermistorFailure = "subunitThermistorFailure",
    SubunitTimingFailure = "subunitTimingFailure",
    SubunitTurnedOff = "subunitTurnedOff",
    SubunitTurnedOn = "subunitTurnedOn",
    SubunitUnderTemperature = "subunitUnderTemperature",
    SubunitUnrecoverableFailure = "subunitUnrecoverableFailure",
    SubunitUnrecoverableStorage = "subunitUnrecoverableStorage",
    SubunitWarmingUp = "subunitWarmingUp",
    Suspend = "suspend",
    Testing = "testing",
    TrimmerAdded = "trimmerAdded",
    TrimmerAlmostEmpty = "trimmerAlmostEmpty",
    TrimmerAlmostFull = "trimmerAlmostFull",
    TrimmerAtLimit = "trimmerAtLimit",
    TrimmerClosed = "trimmerClosed",
    TrimmerConfigurationChange = "trimmerConfigurationChange",
    TrimmerCoverClosed = "trimmerCoverClosed",
    TrimmerCoverOpen = "trimmerCoverOpen",
    TrimmerEmpty = "trimmerEmpty",
    TrimmerFull = "trimmerFull",
    TrimmerInterlockClosed = "trimmerInterlockClosed",
    TrimmerInterlockOpen = "trimmerInterlockOpen",
    TrimmerJam = "trimmerJam",
    TrimmerLifeAlmostOver = "trimmerLifeAlmostOver",
    TrimmerLifeOver = "trimmerLifeOver",
    TrimmerMemoryExhausted = "trimmerMemoryExhausted",
    TrimmerMissing = "trimmerMissing",
    TrimmerMotorFailure = "trimmerMotorFailure",
    TrimmerNearLimit = "trimmerNearLimit",
    TrimmerOffline = "trimmerOffline",
    TrimmerOpened = "trimmerOpened",
    TrimmerOverTemperature = "trimmerOverTemperature",
    TrimmerPowerSaver = "trimmerPowerSaver",
    TrimmerRecoverableFailure = "trimmerRecoverableFailure",
    TrimmerRecoverableStorage = "trimmerRecoverableStorage",
    TrimmerRemoved = "trimmerRemoved",
    TrimmerResourceAdded = "trimmerResourceAdded",
    TrimmerResourceRemoved = "trimmerResourceRemoved",
    TrimmerThermistorFailure = "trimmerThermistorFailure",
    TrimmerTimingFailure = "trimmerTimingFailure",
    TrimmerTurnedOff = "trimmerTurnedOff",
    TrimmerTurnedOn = "trimmerTurnedOn",
    TrimmerUnderTemperature = "trimmerUnderTemperature",
    TrimmerUnrecoverableFailure = "trimmerUnrecoverableFailure",
    TrimmerUnrecoverableStorageError = "trimmerUnrecoverableStorageError",
    TrimmerWarmingUp = "trimmerWarmingUp",
    Unknown = "unknown",
    WrapperAdded = "wrapperAdded",
    WrapperAlmostEmpty = "wrapperAlmostEmpty",
    WrapperAlmostFull = "wrapperAlmostFull",
    WrapperAtLimit = "wrapperAtLimit",
    WrapperClosed = "wrapperClosed",
    WrapperConfigurationChange = "wrapperConfigurationChange",
    WrapperCoverClosed = "wrapperCoverClosed",
    WrapperCoverOpen = "wrapperCoverOpen",
    WrapperEmpty = "wrapperEmpty",
    WrapperFull = "wrapperFull",
    WrapperInterlockClosed = "wrapperInterlockClosed",
    WrapperInterlockOpen = "wrapperInterlockOpen",
    WrapperJam = "wrapperJam",
    WrapperLifeAlmostOver = "wrapperLifeAlmostOver",
    WrapperLifeOver = "wrapperLifeOver",
    WrapperMemoryExhausted = "wrapperMemoryExhausted",
    WrapperMissing = "wrapperMissing",
    WrapperMotorFailure = "wrapperMotorFailure",
    WrapperNearLimit = "wrapperNearLimit",
    WrapperOffline = "wrapperOffline",
    WrapperOpened = "wrapperOpened",
    WrapperOverTemperature = "wrapperOverTemperature",
    WrapperPowerSaver = "wrapperPowerSaver",
    WrapperRecoverableFailure = "wrapperRecoverableFailure",
    WrapperRecoverableStorage = "wrapperRecoverableStorage",
    WrapperRemoved = "wrapperRemoved",
    WrapperResourceAdded = "wrapperResourceAdded",
    WrapperResourceRemoved = "wrapperResourceRemoved",
    WrapperThermistorFailure = "wrapperThermistorFailure",
    WrapperTimingFailure = "wrapperTimingFailure",
    WrapperTurnedOff = "wrapperTurnedOff",
    WrapperTurnedOn = "wrapperTurnedOn",
    WrapperUnderTemperature = "wrapperUnderTemperature",
    WrapperUnrecoverableFailure = "wrapperUnrecoverableFailure",
    WrapperUnrecoverableStorageError = "wrapperUnrecoverableStorageError",
    WrapperWarmingUp = "wrapperWarmingUp",

