import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "cdk-eks-container-insight",
    "version": "0.0.7",
    "description": "CDK construct library that allows you enable an AWS EKS cluster for CloudWatch Container Insight",
    "license": "Apache-2.0",
    "url": "https://github.com/aws-samples/cdk-eks-container-insight.git",
    "long_description_content_type": "text/markdown",
    "author": "Greg Huang<huadebin@amazon.com>",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/aws-samples/cdk-eks-container-insight.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "cdk_eks_container_insight",
        "cdk_eks_container_insight._jsii"
    ],
    "package_data": {
        "cdk_eks_container_insight._jsii": [
            "cdk-eks-container-insight@0.0.7.jsii.tgz"
        ],
        "cdk_eks_container_insight": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.7",
    "install_requires": [
        "aws-cdk-lib>=2.61.1, <3.0.0",
        "constructs>=10.0.5, <11.0.0",
        "jsii>=1.79.0, <2.0.0",
        "publication>=0.0.3",
        "typeguard~=2.13.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Typing :: Typed",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
