"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerInsight = exports.FargateSupportMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const yaml_1 = require("yaml");
var FargateSupportMode;
(function (FargateSupportMode) {
    /**
     * No support for Fargate profile only support EC2
     */
    FargateSupportMode["NO"] = "NO";
    /**
     * Only support for Fargate profile no EC2
     */
    FargateSupportMode["ONLY"] = "ONLY";
    /**
     * Both support Fargate profile and EC2
     */
    FargateSupportMode["BOTH"] = "BOTH";
})(FargateSupportMode = exports.FargateSupportMode || (exports.FargateSupportMode = {}));
class ContainerInsight extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.cluster = props.cluster;
        this.adotNamespace = props.adotNamespace ?? 'amazon-metrics';
        this.cloudwatchNamespace = props.cloudwatchNamespace ?? 'amazon-cloudwatch';
        this.fargateSupportMode = props.fargateSupportMode ?? 'NO';
        this.fargateNamespace = props.fargateNamespace ?? 'fargate-container-insights';
        if (this.fargateSupportMode === 'ONLY' || this.fargateSupportMode === 'BOTH') {
            this.deployAllMainfest(this.fargateNamespace, 'fargate');
        }
        if (this.fargateSupportMode === 'NO' || this.fargateSupportMode === 'BOTH') {
            this.deployAllMainfest(this.adotNamespace, 'adot');
            this.deployAllMainfest(this.cloudwatchNamespace, 'fluent');
        }
    }
    deployAllMainfest(namespaceName, deployType) {
        const namespace = this.cluster.addManifest(`${deployType}-namespace`, {
            apiVersion: 'v1',
            kind: 'Namespace',
            metadata: {
                name: namespaceName,
            },
        });
        var serviceAccountName, deployFile;
        if (deployType === 'adot') {
            serviceAccountName = 'aws-otel-sa';
            deployFile = path.join(__dirname, '../manifest/otel-container-insights-infra.yaml');
        }
        else if (deployType === 'fluent') {
            serviceAccountName = 'fluent-bit';
            deployFile = path.join(__dirname, '../manifest/fluent-bit.yaml');
            const configmap = this.cluster.addManifest('fluent-bit-config', {
                apiVersion: 'v1',
                kind: 'ConfigMap',
                data: {
                    'cluster.name': this.cluster.clusterName,
                    'http.port': '2020',
                    'http.server': 'On',
                    'logs.region': aws_cdk_lib_1.Aws.REGION,
                    'read.head': 'Off',
                    'read.tail': 'On',
                },
                metadata: {
                    name: 'fluent-bit-cluster-info',
                    namespace: namespaceName,
                },
            });
            configmap.node.addDependency(namespace);
        }
        else {
            serviceAccountName = 'adot-collector';
            deployFile = path.join(__dirname, '../manifest/otel-fargate-container-insights.yaml');
            this.cluster.addFargateProfile('FargateContainerInsight', {
                selectors: [{ namespace: namespaceName }],
            });
        }
        const serviceAccount = this.cluster.addServiceAccount(deployType, {
            namespace: namespaceName,
            name: serviceAccountName,
        });
        serviceAccount.role.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('CloudWatchAgentServerPolicy'));
        serviceAccount.node.addDependency(namespace);
        const data = fs.readFileSync(deployFile, { encoding: 'utf8', flag: 'r' });
        if (deployType === 'fargate') {
            data.replace('us-east-1', aws_cdk_lib_1.Aws.REGION).replace('YOUR-EKS-CLUSTER-NAME', this.cluster.clusterName);
        }
        const deploy = yaml_1.parseAllDocuments(data);
        for (var d in deploy) {
            const doc = deploy[d].toJS();
            if (doc !== null) {
                if (doc.kind !== 'Namespace' && doc.kind !== 'ServiceAccount') {
                    if (doc.metadata.namespace)
                        doc.metadata.namespace = namespaceName;
                    if (doc.subjects && doc.subjects[0].namespace) {
                        doc.subjects[0].namespace = namespaceName;
                    }
                    const mf = this.cluster.addManifest(`${deployType}-${doc.kind}`, doc);
                    mf.node.addDependency(namespace);
                }
            }
        }
    }
}
exports.ContainerInsight = ContainerInsight;
_a = JSII_RTTI_SYMBOL_1;
ContainerInsight[_a] = { fqn: "cdk-eks-container-insight.ContainerInsight", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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