import { Cluster } from 'aws-cdk-lib/aws-eks';
import { Construct } from 'constructs';
export declare enum FargateSupportMode {
    /**
     * No support for Fargate profile only support EC2
     */
    NO = "NO",
    /**
     * Only support for Fargate profile no EC2
     */
    ONLY = "ONLY",
    /**
     * Both support Fargate profile and EC2
     */
    BOTH = "BOTH"
}
export interface ContainerInsightProps {
    /**
     * The EKS Cluster to attach to
     */
    readonly cluster: Cluster;
    /**
     * The Kubernetes namespace to install ADOT to
     *
     * @default amazon-metrics
     */
    readonly adotNamespace?: string;
    /**
     * The Kubernetes namespace to install CloudWatch agent to
     *
     * @default - amazon-cloudwatch
     */
    readonly cloudwatchNamespace?: string;
    /**
     * Fargate support mode for NO/ONLY/BOTH
     *
     * @default - NO
     */
    readonly fargateSupportMode?: FargateSupportMode;
    /**
     * Fargate container insight namepsace
     *
     * @default - fargate-container-insights
     */
    readonly fargateNamespace?: string;
}
export declare class ContainerInsight extends Construct {
    readonly cluster: Cluster;
    readonly adotNamespace?: string;
    readonly cloudwatchNamespace?: string;
    readonly fargateSupportMode?: string;
    readonly fargateNamespace?: string;
    constructor(scope: Construct, id: string, props: ContainerInsightProps);
    private deployAllMainfest;
}
