# anclib: python library for analyzing ancestral reconstructions of sequences on phylogenies

[![PyPI downloads](https://static.pepy.tech/personalized-badge/anclib?period=total&units=none&left_color=black&right_color=blue&left_text=downloads&service=github)](https://pepy.tech/project/anclib)
![](https://img.shields.io/badge/version-0.1.0-blue)

Using classes and methods in anclib.py it is possible to parse and analyze text files containing results related to ancestral reconstruction of DNA or protein sequences. (Rudimentary - beginning of project)

## Availability

The anclib.py source code is available on GitHub: https://github.com/agormp/anclib and can be installed from PyPI: https://pypi.org/project/anclib/


## Installation

```
python3 -m pip install anclib
```

Upgrading to latest version:

```
python3 -m pip install --upgrade anclib
```

## Dependencies

### Python
The anclib library depends on these other python modules, which are automatically included when using pip to install:

* [phylotreelib library](https://github.com/agormp/phylotreelib)
* [sequencelib library](https://github.com/agormp/sequencelib)
* [NumPy package](https://numpy.org)
* [pandas library](https://pandas.pydata.org)
* [rpy2 package](https://rpy2.github.io)
* [Levenshtein Python C extension module](https://pypi.org/project/Levenshtein/)

### R
The anclib.py library requires R to be installed, along with the following R-packages:

* [tidyverse](https://cran.r-project.org/web/packages/tidyverse/index.html)
* [ape](https://cran.r-project.org/web/packages/ape/index.html)
* [tidytree](https://cran.r-project.org/web/packages/tidytree/index.html)

## Highlights

To be written