/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;

public final class SubstituteForwards
extends MatrixOperation {
    public static final SubstituteForwards SETUP = new SubstituteForwards();
    public static int THRESHOLD = 64;

    public static void invoke(double[] data, int structure, int first, int limit, Access2D<Double> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        double[] tmpBodyRow = new double[tmpDiagDim];
        for (int i = 0; i < tmpDiagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                tmpBodyRow[j] = conjugated ? body.doubleValue(j, i) : body.doubleValue(i, j);
            }
            for (int s = first; s < limit; ++s) {
                int j;
                int tmpColBaseIndex = s * structure;
                double tmpVal = PrimitiveMath.ZERO;
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal += tmpBodyRow[j] * data[j + tmpColBaseIndex];
                    ++j;
                }
                tmpVal = identity ? (i == s ? PrimitiveMath.ONE - tmpVal : -tmpVal) : data[i + tmpColBaseIndex] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= tmpBodyRow[i];
                }
                data[i + tmpColBaseIndex] = tmpVal;
            }
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int first, int limit, Access2D<N> body, boolean unitDiagonal, boolean conjugated, boolean identity, Scalar.Factory<N> scalar) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        Number[] tmpBodyRow = scalar.newArrayInstance(tmpDiagDim);
        for (int i = 0; i < tmpDiagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                tmpBodyRow[j] = conjugated ? ((Scalar)((VectorSpace)body.get(j, i)).conjugate()).get() : body.get(i, j);
            }
            for (int s = first; s < limit; ++s) {
                int j;
                int tmpColBaseIndex = s * structure;
                Scalar<N> tmpVal = scalar.zero();
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal = tmpVal.add((Scalar)((ScalarOperation.Multiplication)((Object)tmpBodyRow[j])).multiply(data[j + tmpColBaseIndex]));
                    ++j;
                }
                tmpVal = identity ? (i == s ? scalar.one().subtract(tmpVal) : (Scalar<N>)tmpVal.negate()) : ((Scalar)data[i + tmpColBaseIndex]).subtract(tmpVal);
                if (!unitDiagonal) {
                    tmpVal = (Scalar<N>)((Object)tmpVal.divide(tmpBodyRow[i]));
                }
                data[i + tmpColBaseIndex] = tmpVal.get();
            }
        }
    }

    private SubstituteForwards() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

