/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class HermitianRank2Update
extends MatrixOperation {
    public static final HermitianRank2Update SETUP = new HermitianRank2Update();
    public static int THRESHOLD = 256;

    public static void invoke(double[] data, int firstColumn, int columnLimit, double[] vector1, double[] vector2) {
        int structure = vector1.length;
        for (int j = firstColumn; j < columnLimit; ++j) {
            double tmpVal1j = vector1[j];
            double tmpVal2j = vector2[j];
            int tmpIndex = j + j * structure;
            for (int i = j; i < structure; ++i) {
                int n = tmpIndex++;
                data[n] = data[n] - (vector2[i] * tmpVal1j + vector1[i] * tmpVal2j);
            }
        }
    }

    public static <N extends Number> void invoke(N[] data, int firstColumn, int columnLimit, N[] vector1, N[] vector2) {
        int structure = vector1.length;
        for (int j = firstColumn; j < columnLimit; ++j) {
            Scalar tmpVal1j = (Scalar)((VectorSpace)vector1[j]).conjugate();
            Scalar tmpVal2j = (Scalar)((VectorSpace)vector2[j]).conjugate();
            int tmpIndex = j + j * structure;
            for (int i = j; i < structure; ++i) {
                data[tmpIndex] = ((Scalar)data[tmpIndex]).subtract(((Scalar)vector2[i]).multiply(tmpVal1j).add(((Scalar)vector1[i]).multiply(tmpVal2j))).get();
                ++tmpIndex;
            }
        }
    }

    private HermitianRank2Update() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

