/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.Future;
import org.ojalgo.ProgrammingError;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.matrix.store.AbstractStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access1D;

abstract class LogicalStore<N extends Number>
extends AbstractStore<N> {
    private MatrixStore<N> myBase;

    private LogicalStore(int rowsCount, int columnsCount) {
        this(null, rowsCount, columnsCount);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected LogicalStore(MatrixStore<N> base, int rowsCount, int columnsCount) {
        super(rowsCount, columnsCount);
        this.myBase = base;
        if (this.myBase == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot have a null 'base'!");
        }
    }

    @Override
    public final PhysicalStore.Factory<N, ?> physical() {
        return this.myBase.physical();
    }

    protected final Future<?> executeMultiply(Access1D<N> right, ElementsConsumer<N> target) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply(right, target));
    }

    protected final Future<MatrixStore<N>> executeMultiply(double scalar) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply(scalar));
    }

    protected final Future<MatrixStore<N>> executeMultiply(MatrixStore<N> right) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply(right));
    }

    protected final Future<MatrixStore<N>> executeMultiply(N scalar) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiply((Number)scalar));
    }

    protected final Future<N> executeMultiplyBoth(Access1D<N> leftAndRight) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.multiplyBoth(leftAndRight));
    }

    protected final Future<ElementsSupplier<N>> executePremultiply(Access1D<N> left) {
        return DaemonPoolExecutor.invoke(() -> this.myBase.premultiply(left));
    }

    protected final MatrixStore<N> getBase() {
        return this.myBase;
    }
}

