/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.blas;

import java.math.BigDecimal;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.array.blas.BLAS1;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public abstract class DOT
implements BLAS1 {
    public static BigDecimal invoke(BigDecimal[] array1, int offset1, BigDecimal[] array2, int offset2, int first, int limit) {
        BigDecimal retVal = BigMath.ZERO;
        for (int i = first; i < limit; ++i) {
            retVal = retVal.add(array1[offset1 + i].multiply(array2[offset2 + i]));
        }
        return retVal;
    }

    public static ComplexNumber invoke(ComplexNumber[] array1, int offset1, ComplexNumber[] array2, int offset2, int first, int limit) {
        ComplexNumber retVal = ComplexNumber.ZERO;
        for (int i = first; i < limit; ++i) {
            retVal = retVal.add(array1[offset1 + i].multiply(array2[offset2 + i]));
        }
        return retVal;
    }

    public static double invoke(double[] array1, int offset1, double[] array2, int offset2, int first, int limit) {
        double retVal = PrimitiveMath.ZERO;
        for (int i = first; i < limit; ++i) {
            retVal += array1[offset1 + i] * array2[offset2 + i];
        }
        return retVal;
    }

    public static <N extends Number> N invoke(N[] array1, int offset1, N[] array2, int offset2, int first, int limit, Scalar.Factory<N> factory) {
        Scalar<N> retVal = factory.zero();
        for (int i = first; i < limit; ++i) {
            retVal = retVal.add((Scalar)((ScalarOperation.Multiplication)array1[offset1 + i]).multiply(array2[offset2 + i]));
        }
        return retVal.get();
    }

    public static double invoke2(double[] array1, int offset1, double[] array2, int offset2, int first, int limit) {
        double m6;
        double m5;
        double m4;
        double m3;
        double m2;
        double m1;
        double m0;
        int base2;
        int base1;
        double retVal = PrimitiveMath.ZERO;
        int i = first;
        while (i + 8 < limit) {
            base1 = offset1 + i;
            base2 = offset2 + i;
            m0 = array1[base1] * array2[base2];
            m1 = array1[base1 + 1] * array2[base2 + 1];
            m2 = array1[base1 + 2] * array2[base2 + 2];
            m3 = array1[base1 + 3] * array2[base2 + 3];
            m4 = array1[base1 + 4] * array2[base2 + 4];
            m5 = array1[base1 + 5] * array2[base2 + 5];
            m6 = array1[base1 + 6] * array2[base2 + 6];
            double m7 = array1[base1 + 7] * array2[base2 + 7];
            double s0 = m0 + m1;
            double s1 = m2 + m3;
            double s2 = m4 + m5;
            double s3 = m6 + m7;
            double a0 = s0 + s1;
            double a1 = s2 + s3;
            retVal += a0 + a1;
            i += 8;
        }
        switch ((limit - first) % 8) {
            case 7: {
                base1 = offset1 + i;
                base2 = offset2 + i;
                m0 = array1[base1] * array2[base2];
                m1 = array1[base1 + 1] * array2[base2 + 1];
                m2 = array1[base1 + 2] * array2[base2 + 2];
                m3 = array1[base1 + 3] * array2[base2 + 3];
                m4 = array1[base1 + 4] * array2[base2 + 4];
                m5 = array1[base1 + 5] * array2[base2 + 5];
                m6 = array1[base1 + 6] * array2[base2 + 6];
                double s0 = m0 + m1;
                double s1 = m2 + m3;
                double s2 = m4 + m5;
                double s3 = m6;
                double a0 = s0 + s1;
                double a1 = s2 + s3;
                retVal += a0 + a1;
                break;
            }
            case 6: {
                base1 = offset1 + i;
                base2 = offset2 + i;
                m0 = array1[base1] * array2[base2];
                m1 = array1[base1 + 1] * array2[base2 + 1];
                m2 = array1[base1 + 2] * array2[base2 + 2];
                m3 = array1[base1 + 3] * array2[base2 + 3];
                m4 = array1[base1 + 4] * array2[base2 + 4];
                m5 = array1[base1 + 5] * array2[base2 + 5];
                double s0 = m0 + m1;
                double s1 = m2 + m3;
                double s2 = m4 + m5;
                double a0 = s0 + s1;
                double a1 = s2;
                retVal += a0 + a1;
                break;
            }
            case 5: {
                base1 = offset1 + i;
                base2 = offset2 + i;
                m0 = array1[base1] * array2[base2];
                m1 = array1[base1 + 1] * array2[base2 + 1];
                m2 = array1[base1 + 2] * array2[base2 + 2];
                m3 = array1[base1 + 3] * array2[base2 + 3];
                m4 = array1[base1 + 4] * array2[base2 + 4];
                double s0 = m0 + m1;
                double s1 = m2 + m3;
                double s2 = m4;
                double a0 = s0 + s1;
                double a1 = s2;
                retVal += a0 + a1;
                break;
            }
            case 4: {
                base1 = offset1 + i;
                base2 = offset2 + i;
                m0 = array1[base1] * array2[base2];
                m1 = array1[base1 + 1] * array2[base2 + 1];
                m2 = array1[base1 + 2] * array2[base2 + 2];
                m3 = array1[base1 + 3] * array2[base2 + 3];
                double s0 = m0 + m1;
                double s1 = m2 + m3;
                double a0 = s0 + s1;
                retVal += a0;
                break;
            }
            case 3: {
                base1 = offset1 + i;
                base2 = offset2 + i;
                m0 = array1[base1] * array2[base2];
                m1 = array1[base1 + 1] * array2[base2 + 1];
                m2 = array1[base1 + 2] * array2[base2 + 2];
                double s0 = m0 + m1;
                double s1 = m2;
                double a0 = s0 + s1;
                retVal += a0;
                break;
            }
            case 2: {
                double s0;
                base1 = offset1 + i;
                base2 = offset2 + i;
                m0 = array1[base1] * array2[base2];
                m1 = array1[base1 + 1] * array2[base2 + 1];
                double a0 = s0 = m0 + m1;
                retVal += a0;
                break;
            }
            case 1: {
                double s0;
                base1 = offset1 + i;
                base2 = offset2 + i;
                double a0 = s0 = (m0 = array1[base1] * array2[base2]);
                retVal += a0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return retVal;
    }
}

