/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning.modifier;

import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.modifier.ZoningModifier;
import org.goplanit.utils.zoning.modifier.event.ZoningModificationEvent;
import org.goplanit.utils.zoning.modifier.event.ZoningModifierEventType;
import org.goplanit.utils.zoning.modifier.event.ZoningModifierListener;
import org.goplanit.zoning.ConnectoidsImpl;
import org.goplanit.zoning.TransferZoneGroupsImpl;
import org.goplanit.zoning.Zoning;
import org.goplanit.zoning.modifier.event.ModifiedZoneIdsEvent;

public class ZoningModifierImpl
extends EventProducerImpl
implements ZoningModifier {
    private static final Logger LOGGER = Logger.getLogger(ZoningModifierImpl.class.getCanonicalName());
    protected final Zoning zoning;

    private void addInternalEventListeners() {
        this.addListener((ConnectoidsImpl)((Object)this.zoning.odConnectoids));
        this.addListener((ConnectoidsImpl)((Object)this.zoning.transferConnectoids));
        this.addListener((TransferZoneGroupsImpl)this.zoning.transferZoneGroups);
    }

    @Override
    protected void fireEvent(EventListener eventListener, Event event) {
        ((ZoningModifierListener)eventListener).onZoningModifierEvent((ZoningModificationEvent)event);
    }

    protected void removeZone(Zone toRemove) {
        if (toRemove instanceof OdZone) {
            this.zoning.odZones.remove((OdZone)toRemove);
        } else if (toRemove instanceof TransferZone) {
            this.zoning.transferZones.remove((TransferZone)toRemove);
        } else {
            LOGGER.severe(String.format("unsupported zone %s to be removed by zoning modifier, ignored", Zone.class.getCanonicalName()));
        }
    }

    public ZoningModifierImpl(Zoning zoning) {
        this.zoning = zoning;
        this.addInternalEventListeners();
    }

    @Override
    public void recreateConnectoidIds() {
        boolean recreateManagedIdClass = true;
        this.zoning.odConnectoids.recreateIds(recreateManagedIdClass);
        recreateManagedIdClass = false;
        this.zoning.transferConnectoids.recreateIds(recreateManagedIdClass);
    }

    @Override
    public void recreateZoneIds() {
        boolean resetManagedIdClass = true;
        this.zoning.odZones.recreateIds(resetManagedIdClass);
        resetManagedIdClass = false;
        this.zoning.transferZones.recreateIds(resetManagedIdClass);
        this.fireEvent(new ModifiedZoneIdsEvent(this, this.zoning));
    }

    @Override
    public void recreateTransferZoneGroupIds() {
        this.zoning.transferZoneGroups.recreateIds();
    }

    @Override
    public void removeDanglingZones() {
        HashSet danglingZones = new HashSet(this.zoning.odZones.toCollection());
        danglingZones.addAll(this.zoning.transferZones.toCollection());
        this.zoning.odConnectoids.forEach(connectoid -> danglingZones.removeAll(connectoid.getAccessZones()));
        this.zoning.transferConnectoids.forEach(connectoid -> danglingZones.removeAll(connectoid.getAccessZones()));
        if (!danglingZones.isEmpty()) {
            for (Zone danglingZone : danglingZones) {
                this.removeZone(danglingZone);
                if (!(danglingZone instanceof TransferZone)) continue;
                ((TransferZone)danglingZone).removeFromAllTransferZoneGroups();
            }
            this.recreateZoneIds();
        }
    }

    @Override
    public void removeDanglingTransferZoneGroups() {
        boolean groupRemoved = false;
        Iterator iterator = this.zoning.transferZoneGroups.iterator();
        while (iterator.hasNext()) {
            TransferZoneGroup group = (TransferZoneGroup)iterator.next();
            if (!group.isEmpty()) continue;
            iterator.remove();
            groupRemoved = true;
        }
        if (groupRemoved) {
            this.recreateTransferZoneGroupIds();
        }
    }

    @Override
    public void addListener(ZoningModifierListener listener, ZoningModifierEventType eventType) {
        super.addListener((EventListener)listener, eventType);
    }

    @Override
    public void removeListener(ZoningModifierListener listener, ZoningModifierEventType eventType) {
        super.removeListener(listener, eventType);
    }

    @Override
    public void removeListener(ZoningModifierListener listener) {
        super.removeListener(listener);
    }
}

