/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.HashMap;
import java.util.Map;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Geometry;

public abstract class ZoneImpl
extends ExternalIdAbleImpl
implements Zone {
    protected String name;
    protected Map<String, Object> inputProperties = null;
    protected Centroid centroid;
    protected Geometry geometry = null;

    protected static long generateZoneId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Zone.ZONE_ID_CLASS);
    }

    protected void setCentroid(Centroid centroid) {
        this.centroid = centroid;
    }

    @Override
    protected void setId(long id) {
        super.setId(id);
    }

    public ZoneImpl(IdGroupingToken tokenId) {
        super(ZoneImpl.generateZoneId(tokenId));
    }

    public ZoneImpl(ZoneImpl other) {
        super(other);
        this.name = other.name;
        if (other.inputProperties != null) {
            this.inputProperties = new HashMap<String, Object>(other.inputProperties);
        }
        this.centroid = other.centroid;
        this.geometry = other.geometry;
    }

    @Override
    public Centroid getCentroid() {
        return this.centroid;
    }

    @Override
    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    @Override
    public Object getInputProperty(String key) {
        if (this.inputProperties != null) {
            return this.inputProperties.get(key);
        }
        return null;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = ZoneImpl.generateZoneId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public abstract ZoneImpl clone();

    public String toString() {
        return String.format("id: %d, Xmlid: %s name:%s", this.getId(), this.getXmlId(), this.getName());
    }
}

