/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.logging.Logger;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.ConnectoidImpl;

public class DirectedConnectoidImpl
extends ConnectoidImpl
implements DirectedConnectoid {
    private static final Logger LOGGER = Logger.getLogger(DirectedConnectoidImpl.class.getCanonicalName());
    protected long directedConnectoidId;
    protected LinkSegment accessEdgeSegment;
    protected boolean nodeAccessDownstream = true;

    protected static long generateDirectedConnectoidId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, DirectedConnectoid.DIRECTED_CONNECTOID_ID_CLASS);
    }

    protected void setDirectedConnectoidId(long directedConnectoidId) {
        this.directedConnectoidId = directedConnectoidId;
    }

    protected void setAccessLinkSegment(LinkSegment accessEdgeSegment) {
        this.accessEdgeSegment = accessEdgeSegment;
    }

    protected DirectedConnectoidImpl(IdGroupingToken idToken, LinkSegment accessLinkSegment, Zone accessZone, double length) {
        super(idToken, accessZone, length);
        this.setDirectedConnectoidId(DirectedConnectoidImpl.generateDirectedConnectoidId(idToken));
        this.setAccessLinkSegment(accessLinkSegment);
    }

    public DirectedConnectoidImpl(IdGroupingToken idToken, LinkSegment accessEdgeSegment) {
        super(idToken);
        this.setDirectedConnectoidId(DirectedConnectoidImpl.generateDirectedConnectoidId(idToken));
        this.setAccessLinkSegment(accessEdgeSegment);
    }

    protected DirectedConnectoidImpl(DirectedConnectoidImpl connectoidImpl) {
        super(connectoidImpl);
        this.setDirectedConnectoidId(connectoidImpl.getDirectedConnectoidId());
        this.setAccessLinkSegment(connectoidImpl.getAccessLinkSegment());
        this.setNodeAccessDownstream(connectoidImpl.isNodeAccessDownstream());
    }

    @Override
    public long getDirectedConnectoidId() {
        return this.directedConnectoidId;
    }

    @Override
    public LinkSegment getAccessLinkSegment() {
        return this.accessEdgeSegment;
    }

    @Override
    public void replaceAccessLinkSegment(EdgeSegment exitEdgeSegment) {
        this.setAccessLinkSegment(this.accessEdgeSegment);
    }

    @Override
    public boolean isNodeAccessDownstream() {
        return this.nodeAccessDownstream;
    }

    @Override
    public void setNodeAccessDownstream(boolean nodeAccessDownstream) {
        this.nodeAccessDownstream = nodeAccessDownstream;
    }

    @Override
    public DirectedVertex getAccessVertex() {
        return this.isNodeAccessDownstream() ? this.getAccessLinkSegment().getDownstreamVertex() : this.getAccessLinkSegment().getUpstreamVertex();
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.setDirectedConnectoidId(DirectedConnectoidImpl.generateDirectedConnectoidId(tokenId));
        return super.recreateManagedIds(tokenId);
    }

    @Override
    public DirectedConnectoidImpl clone() {
        return new DirectedConnectoidImpl(this);
    }
}

