/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntityFactoryImpl;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.DirectedConnectoidFactory;
import org.goplanit.utils.zoning.DirectedConnectoids;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.DirectedConnectoidImpl;

public class DirectedConnectoidFactoryImpl
extends ManagedIdEntityFactoryImpl<DirectedConnectoid>
implements DirectedConnectoidFactory {
    protected final DirectedConnectoids directedConnectoids;

    protected DirectedConnectoidFactoryImpl(IdGroupingToken groupId, DirectedConnectoids directedConnectoids) {
        super(groupId);
        this.directedConnectoids = directedConnectoids;
    }

    @Override
    public DirectedConnectoid registerNew(LinkSegment accessLinkSegment, Zone parentZone, double length) throws PlanItException {
        DirectedConnectoid newConnectoid = this.registerNew(accessLinkSegment);
        newConnectoid.addAccessZone(parentZone);
        newConnectoid.setLength(parentZone, length);
        this.directedConnectoids.register(newConnectoid);
        return newConnectoid;
    }

    @Override
    public DirectedConnectoid registerNew(LinkSegment accessLinkSegment, Zone parentZone) throws PlanItException {
        return this.registerNew(accessLinkSegment, parentZone, 0.0);
    }

    @Override
    public DirectedConnectoid registerNew(LinkSegment accessLinkSegment) throws PlanItException {
        DirectedConnectoidImpl newConnectoid = new DirectedConnectoidImpl(this.getIdGroupingToken(), accessLinkSegment);
        this.directedConnectoids.register(newConnectoid);
        return newConnectoid;
    }
}

