/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.wrapper;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.goplanit.utils.wrapper.MapWrapper;

public class MapWrapperImpl<K, V>
implements MapWrapper<K, V> {
    private static final Logger LOGGER = Logger.getLogger(MapWrapperImpl.class.getCanonicalName());
    private Map<K, V> theMap;
    private final Function<V, K> valueToKey;

    protected static <U, L> Map<U, L> createEmptyInstance(Map<U, L> mapToCopy) {
        try {
            return (Map)mapToCopy.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warning("Unable to instantiate new instance of map signature in map wrapper in copy constructor");
            return null;
        }
    }

    public Function<V, K> getValueToKey() {
        return this.valueToKey;
    }

    protected Map<K, V> getMap() {
        return this.theMap;
    }

    protected void setMap(Map<K, V> replacement) {
        this.theMap = replacement;
    }

    public MapWrapperImpl(Map<K, V> mapToWrap, Function<V, K> valueToKey) {
        this.theMap = mapToWrap;
        this.valueToKey = valueToKey;
    }

    public MapWrapperImpl(Map<K, V> mapToWrap, Function<V, K> valueToKey, Collection<V> populateWith) {
        this.theMap = mapToWrap;
        this.valueToKey = valueToKey;
        populateWith.forEach(value -> this.register(value));
    }

    public <U> MapWrapperImpl(Map<K, V> mapToWrap, Function<V, K> valueToKey, MapWrapper<U, V> populateWith) {
        this.theMap = mapToWrap;
        this.valueToKey = valueToKey;
        populateWith.forEach(value -> this.register(value));
    }

    public MapWrapperImpl(MapWrapperImpl<K, V> other) {
        this.valueToKey = other.valueToKey;
        Map<K, V> newMap = MapWrapperImpl.createEmptyInstance(this.theMap);
        if (newMap != null) {
            newMap.putAll(other.getMap());
            this.theMap = newMap;
        }
    }

    @Override
    public Iterator<V> iterator() {
        return this.theMap.values().iterator();
    }

    @Override
    public V register(V value) {
        return this.theMap.put(this.getKeyByValue(value), value);
    }

    @Override
    public V remove(V value) {
        return this.theMap.remove(this.getKeyByValue(value));
    }

    @Override
    public V get(K key) {
        return this.theMap.get(key);
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public Collection<V> toCollection() {
        return Collections.unmodifiableCollection(this.theMap.values());
    }

    @Override
    public Set<V> valuesAsNewSet() {
        return Set.copyOf(this.theMap.values());
    }

    @Override
    public V findFirst(Predicate<V> valuePredicate) {
        for (V value : this) {
            if (!valuePredicate.test(value)) continue;
            return value;
        }
        return null;
    }

    @Override
    public MapWrapperImpl<K, V> clone() {
        return new MapWrapperImpl<K, V>(this);
    }

    @Override
    public boolean contains(V value) {
        return this.getMap().containsKey(this.getKeyByValue(value));
    }

    @Override
    public K getKeyByValue(V value) {
        return this.valueToKey.apply(value);
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }
}

