/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.time;

import java.util.Comparator;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.time.TimePeriod;

public class TimePeriodUtils {
    private static final Logger LOGGER = Logger.getLogger(TimePeriodUtils.class.getCanonicalName());

    public static Comparator<TimePeriod> comparatorByStartTime() {
        Comparator<TimePeriod> sortOnStartTime = new Comparator<TimePeriod>(){

            @Override
            public int compare(TimePeriod o1, TimePeriod o2) {
                long startTimeDiff = o1.getStartTimeSeconds() - o2.getStartTimeSeconds();
                if (startTimeDiff != 0L) {
                    return (int)startTimeDiff;
                }
                return (int)(o1.getDurationSeconds() - o2.getDurationSeconds());
            }
        };
        return sortOnStartTime;
    }

    public static long convertHoursToSeconds(String fourDigitHour) throws PlanItException {
        long startTime;
        PlanItException.throwIf(fourDigitHour.length() != 4, "Start time must contain exactly four digits", new Object[0]);
        try {
            startTime = Integer.parseInt(fourDigitHour);
        }
        catch (NumberFormatException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Start time must contain exactly four digits", e);
        }
        PlanItException.throwIf(startTime < 0L, "Start time cannot be negative", new Object[0]);
        PlanItException.throwIf(startTime > 2400L, "Start time cannot be later than 2400", new Object[0]);
        long startTimeHrs = startTime / 100L;
        long startTimeMins = startTime % 100L;
        PlanItException.throwIf(startTimeMins > 59L, "Last two digits of start time cannot exceed 59", new Object[0]);
        return startTimeHrs * 3600L + startTimeMins * 60L;
    }

    public static long convertHoursToSeconds(double hoursFromMidnight) {
        return Math.round(hoursFromMidnight * 3600.0);
    }

    public static float convertSecondsToHours(int secondsFromMidnight) {
        return (float)secondsFromMidnight / 3600.0f;
    }
}

