/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import org.goplanit.utils.time.TimePeriod;

public class LoggingUtils {
    public static String surroundwithBrackets(String message) {
        return String.format("[%s] ", message);
    }

    public static String createRunIdPrefix(long runId) {
        return LoggingUtils.surroundwithBrackets(String.format("run id: %d", runId));
    }

    public static String createProjectPrefix(long projectId) {
        return LoggingUtils.surroundwithBrackets(String.format("project id: %d", projectId));
    }

    public static String createNetworkPrefix(long networkId) {
        return LoggingUtils.surroundwithBrackets(String.format("network id: %d", networkId));
    }

    public static String createZoningPrefix(long zoningId) {
        return LoggingUtils.surroundwithBrackets(String.format("zoning id: %d", zoningId));
    }

    public static String createDemandsPrefix(long demandsId) {
        return LoggingUtils.surroundwithBrackets(String.format("demands id: %d", demandsId));
    }

    public static String createServiceNetworkPrefix(long serviceNetworkId) {
        return LoggingUtils.surroundwithBrackets(String.format("services network id: %d", serviceNetworkId));
    }

    public static String createRoutedServicesPrefix(long routedServicesId) {
        return LoggingUtils.surroundwithBrackets(String.format("routed services id: %d", routedServicesId));
    }

    public static String createOdPathSetsPrefix(long odPathSetsId) {
        return LoggingUtils.surroundwithBrackets(String.format("od path sets id: %d", odPathSetsId));
    }

    public static String createOutputFormatterPrefix(long outputFormatterId) {
        return LoggingUtils.surroundwithBrackets(String.format("output formatter id: %d", outputFormatterId));
    }

    public static String createTimePeriodPrefix(TimePeriod timePeriod) {
        Object timePeriodReference = timePeriod.hasExternalId() ? "external id: " + timePeriod.getExternalId() : (timePeriod.hasXmlId() ? "xml id: " + timePeriod.getXmlId() : "");
        return LoggingUtils.surroundwithBrackets(String.format("time period: %s (id %d)", timePeriodReference, timePeriod.getId()));
    }

    public static String createIterationPrefix(int iterationIndex) {
        return LoggingUtils.surroundwithBrackets(String.format("iteration: %d", iterationIndex));
    }

    public static String logActiveStateByClassName(Object item, boolean activate) {
        return (activate ? "activated: " : "deactivated :") + item.getClass().getSimpleName();
    }

    public static String getClassNameWithBrackets(Object item) {
        return LoggingUtils.surroundwithBrackets(item.getClass().getSimpleName());
    }
}

