/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.Collection;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.ItemVisitor;

public abstract class PlanitJtsItemVisitor<T>
implements ItemVisitor {
    private Collection<T> filteredResultToPopulate;
    private Polygon geometryFilter;

    protected abstract Geometry getGeometry(T var1);

    public PlanitJtsItemVisitor(Polygon geometryFilter, Collection<T> filteredResultToPopulate) {
        this.geometryFilter = geometryFilter;
        this.filteredResultToPopulate = filteredResultToPopulate;
    }

    @Override
    public void visitItem(Object planitEntity) {
        if (this.getGeometry(planitEntity).intersects(this.geometryFilter)) {
            this.filteredResultToPopulate.add(planitEntity);
        }
    }

    public Collection<T> getResult() {
        return this.filteredResultToPopulate;
    }
}

