/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.awt.geom.Point2D;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Vertex;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitJtsCrsUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitJtsCrsUtils.class.getCanonicalName());
    protected final CoordinateReferenceSystem crs;
    protected final GeodeticCalculator geoCalculator;
    protected static final GeometryFactory jtsGeometryFactory;
    public static final DefaultGeographicCRS DEFAULT_GEOGRAPHIC_CRS;
    public static final CoordinateReferenceSystem CARTESIANCRS;

    public PlanitJtsCrsUtils() {
        this(DEFAULT_GEOGRAPHIC_CRS);
    }

    public PlanitJtsCrsUtils(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
        this.geoCalculator = !coordinateReferenceSystem.equals(CARTESIANCRS) ? new GeodeticCalculator(this.getCoordinateReferenceSystem()) : null;
    }

    public double getClosestExistingCoordinateDistanceInMeters(Point point, Geometry geometry) throws PlanItException {
        if (geometry != null) {
            return this.getDistanceInMetres(this.getClosestExistingCoordinateToPoint(point, geometry), point.getCoordinate());
        }
        return Double.POSITIVE_INFINITY;
    }

    public Coordinate getClosestExistingCoordinateToPoint(Point point, Geometry geometry) throws PlanItException {
        double minDistanceMetersToCoordinate = Double.POSITIVE_INFINITY;
        Coordinate closestCoordinate = null;
        if (geometry != null) {
            Coordinate referenceCoordinate = point.getCoordinate();
            Coordinate[] coordinates = geometry.getCoordinates();
            for (int index = 0; index < coordinates.length; ++index) {
                Coordinate coordinate = coordinates[index];
                double distanceMeters = this.getDistanceInMetres(referenceCoordinate, coordinate);
                if (!(minDistanceMetersToCoordinate > distanceMeters)) continue;
                minDistanceMetersToCoordinate = distanceMeters;
                closestCoordinate = coordinate;
            }
        }
        return closestCoordinate;
    }

    public <T extends LineString> Coordinate getClosestExistingLineStringCoordinateToGeometry(Geometry referenceGeometry, T lineString) throws PlanItException {
        double minDistanceMetersToCoordinate = Double.POSITIVE_INFINITY;
        Coordinate closestCoordinate = null;
        for (int index = 0; index < lineString.getNumPoints(); ++index) {
            Coordinate coordinate = lineString.getCoordinateN(index);
            Coordinate closestProjectedReferenceCoordinate = this.getClosestProjectedCoordinateOnGeometry(PlanitJtsUtils.createPoint(coordinate), referenceGeometry);
            double distanceMeters = this.getDistanceInMetres(closestProjectedReferenceCoordinate, coordinate);
            if (!(minDistanceMetersToCoordinate > distanceMeters)) continue;
            minDistanceMetersToCoordinate = distanceMeters;
            closestCoordinate = coordinate;
        }
        return closestCoordinate;
    }

    private Coordinate getClosestExistingPolygonCoordinateToGeometry(Geometry referenceGeometry, Polygon polygon) throws PlanItException {
        LinearRing exteriorGeometry = polygon.getExteriorRing();
        return this.getClosestExistingLineStringCoordinateToGeometry(referenceGeometry, exteriorGeometry);
    }

    public LinearLocation getClosestProjectedLinearLocationOnGeometry(Point referencePoint, Geometry geometry) throws PlanItException {
        if (geometry instanceof Point) {
            throw new PlanItException("Cannot create linear Location from a single point");
        }
        if (geometry instanceof LineString) {
            return this.getClosestProjectedLinearLocationOnLineString(referencePoint.getCoordinate(), (LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.getClosestProjectedLinearLocationOnPolygon(referencePoint.getCoordinate(), (Polygon)geometry);
        }
        throw new PlanItException("Method getClosestLinearLocationOnGeometry not supported for provided geometry type %s", geometry.getClass().getName());
    }

    public LinearLocation getClosestProjectedLinearLocationOnLineString(Coordinate referenceCoordinate, LineString lineString) throws PlanItException {
        LocationIndexedLine locIndexedLine = new LocationIndexedLine(lineString);
        return locIndexedLine.project(referenceCoordinate);
    }

    public LinearLocation getClosestProjectedLinearLocationOnPolygon(Coordinate referenceCoordinate, Polygon polygon) throws PlanItException {
        PlanItException.throwIfNull(referenceCoordinate, "Provided coordinate is null when computing closest location to given coordinate");
        PlanItException.throwIfNull(polygon, "Provided polygon is null when computing closest location to given coordinate");
        PlanItException.throwIfNull(polygon.getNumPoints() < 2, "Provided polygon has too few coordinates");
        double minDistanceMeters = Double.POSITIVE_INFINITY;
        LinearLocation closestLinearLocation = null;
        Coordinate[] polygonCoordinates = polygon.getExteriorRing().getCoordinates();
        Coordinate prevCoordinate = polygonCoordinates[0];
        for (int index = 1; index < polygonCoordinates.length; ++index) {
            Coordinate currCoordinate = polygonCoordinates[index];
            Coordinate[] coordinateArray = new Coordinate[]{prevCoordinate, currCoordinate};
            LineString lineString = jtsGeometryFactory.createLineString(coordinateArray);
            LinearLocation linearLocation = this.getClosestProjectedLinearLocationOnLineString(referenceCoordinate, lineString);
            double distanceMeters = this.getDistanceInMetres(linearLocation.getCoordinate(lineString), referenceCoordinate);
            if (!(distanceMeters < minDistanceMeters)) continue;
            minDistanceMeters = distanceMeters;
            closestLinearLocation = linearLocation;
        }
        return closestLinearLocation;
    }

    public LinearLocation getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(Geometry referenceGeometry, LineString linearGeometry) throws PlanItException {
        double minDistanceMetersToCoordinate = Double.POSITIVE_INFINITY;
        LinearLocation closestLocation = null;
        Coordinate[] referenceGeometryCoordinates = referenceGeometry.getCoordinates();
        for (int index = 0; index < referenceGeometry.getNumPoints(); ++index) {
            Coordinate referenceCoordinate = referenceGeometryCoordinates[index];
            LinearLocation location = this.getClosestProjectedLinearLocationOnLineString(referenceCoordinate, linearGeometry);
            double distanceMeters = this.getDistanceInMetres(location.getCoordinate(linearGeometry), referenceCoordinate);
            if (!(minDistanceMetersToCoordinate > distanceMeters)) continue;
            minDistanceMetersToCoordinate = distanceMeters;
            closestLocation = location;
        }
        return closestLocation;
    }

    public Coordinate getClosestProjectedCoordinateOnGeometry(Point referencePoint, Geometry geometry) throws PlanItException {
        if (geometry instanceof Point) {
            return ((Point)geometry).getCoordinate();
        }
        if (geometry instanceof LineString) {
            return this.getClosestProjectedCoordinateOnLineString(referencePoint, (LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.getClosestPojectedCoordinateOnPolygon(referencePoint, (Polygon)geometry);
        }
        throw new PlanItException("Method getClosestProjectedCoordinateTo not supported for provided geometry type %s", geometry.getClass().getName());
    }

    public Coordinate getClosestProjectedCoordinateOnLineString(Point referencePoint, LineString lineString) throws PlanItException {
        return this.getClosestProjectedLinearLocationOnGeometry(referencePoint, lineString).getCoordinate(lineString);
    }

    public Coordinate getClosestPojectedCoordinateOnPolygon(Point referencePoint, Polygon polygon) throws PlanItException {
        LinearLocation linearLocation = this.getClosestProjectedLinearLocationOnPolygon(referencePoint.getCoordinate(), polygon);
        int lineSegmentIndex = linearLocation.getSegmentIndex();
        return linearLocation.getCoordinate(PlanitJtsUtils.createLineString(polygon.getCoordinates()[lineSegmentIndex], polygon.getCoordinates()[lineSegmentIndex + 1]));
    }

    public double getClosestProjectedDistanceInMetersToLineString(Point referencePoint, LineString geometry) throws PlanItException {
        return this.getDistanceInMetres(referencePoint.getCoordinate(), this.getClosestProjectedCoordinateOnLineString(referencePoint, geometry));
    }

    public double getClosestDistanceInMetersMultiLineString(Point referencePoint, MultiLineString geometry) throws PlanItException {
        double minDistanceInMetersForLineSegment = Double.POSITIVE_INFINITY;
        for (int index = 0; index < geometry.getNumGeometries(); ++index) {
            LineString currLineString = (LineString)geometry.getGeometryN(index);
            minDistanceInMetersForLineSegment = Math.min(minDistanceInMetersForLineSegment, this.getClosestProjectedDistanceInMetersToLineString(referencePoint, currLineString));
        }
        return minDistanceInMetersForLineSegment;
    }

    public double getClosestDistanceInMetersToPolygon(Point referencePoint, Polygon geometry) throws PlanItException {
        double minDistanceInMetersForLineSegment = Double.POSITIVE_INFINITY;
        Coordinate[] coords = geometry.getCoordinates();
        if (coords != null) {
            Coordinate prevCoord = coords[0];
            for (int index = 1; index < coords.length; ++index) {
                Coordinate currCoord = coords[index];
                LineString lineSegment = PlanitJtsUtils.createLineString(prevCoord, currCoord);
                minDistanceInMetersForLineSegment = Math.min(minDistanceInMetersForLineSegment, this.getClosestDistanceInMeters(referencePoint, lineSegment));
                prevCoord = currCoord;
            }
        }
        return minDistanceInMetersForLineSegment;
    }

    public double getClosestDistanceInMeters(Point referencePoint, Geometry geometry) throws PlanItException {
        if (geometry instanceof Point) {
            return this.getClosestExistingCoordinateDistanceInMeters(referencePoint, geometry);
        }
        if (geometry instanceof LineString) {
            return this.getClosestProjectedDistanceInMetersToLineString(referencePoint, (LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.getClosestDistanceInMetersMultiLineString(referencePoint, (MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.getClosestDistanceInMetersToPolygon(referencePoint, (Polygon)geometry);
        }
        throw new PlanItException("unsupported geometry provided for fiding closest distance to point");
    }

    public double getDistanceInMetres(Point startPosition, Point endPosition) throws PlanItException {
        return this.getDistanceInMetres(startPosition.getCoordinate(), endPosition.getCoordinate());
    }

    public double getDistanceInMetres(Coordinate startCoordinate, Coordinate endCoordinate) throws PlanItException {
        try {
            if (this.crs.equals(CARTESIANCRS)) {
                double deltaCoordinate0 = startCoordinate.x - endCoordinate.x;
                double deltaCoordinate1 = startCoordinate.y - endCoordinate.y;
                return Math.sqrt(Math.pow(deltaCoordinate0, 2.0) + Math.pow(deltaCoordinate1, 2.0));
            }
            return JTS.orthodromicDistance(startCoordinate, endCoordinate, this.crs);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when computing distance in meters between two Positions in JtsUtils", e);
        }
    }

    public double getDistanceInKilometres(Point startPosition, Point endPosition) throws PlanItException {
        return this.getDistanceInMetres(startPosition, endPosition) / 1000.0;
    }

    public double getDistanceInKilometres(Vertex vertex1, Vertex vertex2) throws PlanItException {
        return this.getDistanceInKilometres(vertex1.getPosition(), vertex2.getPosition());
    }

    public Envelope createBoundingBox(double centrePointX, double centrePointY, double lengthMeters) {
        if (this.geoCalculator == null) {
            return new Envelope(centrePointX - lengthMeters, centrePointX + lengthMeters, centrePointY - lengthMeters, centrePointY + lengthMeters);
        }
        this.geoCalculator.setStartingGeographicPoint(centrePointX, centrePointY);
        this.geoCalculator.setDirection(0.0, lengthMeters);
        Point2D north = this.geoCalculator.getDestinationGeographicPoint();
        this.geoCalculator.setDirection(90.0, lengthMeters);
        Point2D east = this.geoCalculator.getDestinationGeographicPoint();
        this.geoCalculator.setDirection(180.0, lengthMeters);
        Point2D south = this.geoCalculator.getDestinationGeographicPoint();
        this.geoCalculator.setDirection(-90.0, lengthMeters);
        Point2D west = this.geoCalculator.getDestinationGeographicPoint();
        double y1 = north.getY();
        double y2 = south.getY();
        double x1 = west.getX();
        double x2 = east.getX();
        return new Envelope(x1, x2, y2, y1);
    }

    public Envelope createBoundingBox(Envelope boundingBox, double lengthMeters) {
        return this.createBoundingBox(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMaxX(), boundingBox.getMaxY(), lengthMeters);
    }

    public Envelope createBoundingBox(double minX, double minY, double maxX, double maxY, double lengthMeters) {
        Envelope localExtremeBoundingBox1 = this.createBoundingBox(minX, minY, lengthMeters);
        Envelope localExtremeBoundingBox2 = this.createBoundingBox(maxX, maxY, lengthMeters);
        localExtremeBoundingBox1.expandToInclude(localExtremeBoundingBox2.getMaxX(), localExtremeBoundingBox2.getMaxY());
        localExtremeBoundingBox1.expandToInclude(localExtremeBoundingBox2.getMinX(), localExtremeBoundingBox2.getMinY());
        return localExtremeBoundingBox1;
    }

    public double getDistanceInKilometres(LineString geometry) throws PlanItException {
        Coordinate[] coordinates = geometry.getCoordinates();
        int numberOfCoords = coordinates.length;
        if (numberOfCoords > 1) {
            double computedLengthInMetres = 0.0;
            Coordinate previousCoordinate = coordinates[0];
            for (int index = 1; index < numberOfCoords; ++index) {
                Coordinate currentCoordinate = coordinates[index];
                computedLengthInMetres += this.getDistanceInMetres(previousCoordinate, currentCoordinate);
                previousCoordinate = currentCoordinate;
            }
            return computedLengthInMetres / 1000.0;
        }
        throw new PlanItException("unable to compute distance for less than two points");
    }

    public LineSegment createExtendedLineSegment(LineSegment source, double extensionInMeters, boolean extendStart, boolean extendEnd) throws PlanItException {
        DirectPosition newStartPosition = null;
        if (extendStart) {
            newStartPosition = this.createPositionInDirection(source.p0, this.getAzimuthInDegrees(source.p1, source.p0), extensionInMeters);
        }
        DirectPosition newEndPosition = null;
        if (extendEnd) {
            newEndPosition = this.createPositionInDirection(source.p1, this.getAzimuthInDegrees(source.p0, source.p1), extensionInMeters);
        }
        Coordinate startCoordinate = newStartPosition != null ? PlanitJtsUtils.createCoordinate(newStartPosition) : source.p0;
        Coordinate endCoordinate = newEndPosition != null ? PlanitJtsUtils.createCoordinate(newEndPosition) : source.p1;
        return PlanitJtsUtils.createLineSegment(startCoordinate, endCoordinate);
    }

    private DirectPosition createPositionInDirection(Coordinate start, double azimuthInDegrees, double distanceInMeters) throws PlanItException {
        try {
            this.geoCalculator.setStartingGeographicPoint(start.x, start.y);
            this.geoCalculator.setDirection(azimuthInDegrees, distanceInMeters);
            return this.geoCalculator.getDestinationPosition();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Unable to create a position in the desired direction", e);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double getAzimuthInDegrees(Coordinate coordinate1, Coordinate coordinate2) {
        this.geoCalculator.setStartingGeographicPoint(coordinate1.getX(), coordinate1.getY());
        this.geoCalculator.setDestinationGeographicPoint(coordinate2.getX(), coordinate2.getY());
        return this.geoCalculator.getAzimuth();
    }

    public boolean isGeometryLeftOf(Geometry geometry, Coordinate coordA, Coordinate coordB) throws PlanItException {
        Coordinate transferZoneReferenceCoordinate = null;
        transferZoneReferenceCoordinate = geometry instanceof Point ? ((Point)geometry).getCoordinate() : this.getClosestProjectedCoordinateOnGeometry(PlanitJtsUtils.createPoint(coordB), geometry);
        return PlanitJtsUtils.isCoordinateLeftOf(transferZoneReferenceCoordinate, coordA, coordB);
    }

    public boolean isGeometryNearBoundingBox(Geometry geometry, Envelope boundingBox, double maxDistanceMeters) throws PlanItException {
        Polygon boundingBoxGeometry = PlanitJtsUtils.create2DPolygon(boundingBox);
        double distanceMeters = Double.POSITIVE_INFINITY;
        if (geometry instanceof Point) {
            distanceMeters = this.getClosestDistanceInMetersToPolygon((Point)Point.class.cast(geometry), boundingBoxGeometry);
        } else if (geometry instanceof LineString) {
            Coordinate closestCoordinate = this.getClosestExistingLineStringCoordinateToGeometry(boundingBoxGeometry, (LineString)LineString.class.cast(geometry));
            distanceMeters = this.getClosestDistanceInMetersToPolygon(PlanitJtsUtils.createPoint(closestCoordinate), boundingBoxGeometry);
        } else if (geometry instanceof Polygon) {
            Coordinate closestCoordinate = this.getClosestExistingPolygonCoordinateToGeometry(boundingBoxGeometry, (Polygon)Polygon.class.cast(geometry));
            distanceMeters = this.getClosestDistanceInMeters(PlanitJtsUtils.createPoint(closestCoordinate), boundingBoxGeometry);
        } else {
            throw new PlanItException("Unsupported geometry type provided when checking if it is near bounding box");
        }
        return distanceMeters + 1.0E-6 <= maxDistanceMeters;
    }

    static {
        PlanitCrsUtils.silenceHsqlLogging();
        jtsGeometryFactory = JTSFactoryFinder.getGeometryFactory();
        DEFAULT_GEOGRAPHIC_CRS = DefaultGeographicCRS.WGS84;
        CARTESIANCRS = CartesianAuthorityFactory.GENERIC_2D;
    }
}

