/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;

public class Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(Configurator.class.getCanonicalName());
    private final Class<T> configuratorClassType;
    protected final Map<String, List<Object[]>> delayedMethodCalls;

    protected Class<?>[] collectParameterTypes(Object ... parameters) throws PlanItException {
        PlanItException.throwIf(parameters == null, "The parameters to collect signature for are null", new Object[0]);
        Class[] parameterTypes = new Class[parameters.length];
        for (int index = 0; index < parameters.length; ++index) {
            parameterTypes[index] = parameters[index].getClass();
        }
        return parameterTypes;
    }

    protected void callVoidMethod(T instance, String methodName, Object ... parameters) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, PlanItException, NoSuchMethodException, SecurityException {
        PlanItException.throwIf(instance == null, "The instance to configure by calling " + methodName + " is not available", new Object[0]);
        boolean matches = false;
        for (Method method : instance.getClass().getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != parameters.length) continue;
            boolean parametersMatch = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<Object> manuallyBoxedParameter = parameterTypes[i];
                if (parameterTypes[i].isPrimitive()) {
                    switch (parameterTypes[i].getName()) {
                        case "double": {
                            manuallyBoxedParameter = Double.class;
                            break;
                        }
                        case "int": {
                            manuallyBoxedParameter = Integer.class;
                            break;
                        }
                        case "byte": {
                            manuallyBoxedParameter = Byte.class;
                            break;
                        }
                        case "short": {
                            manuallyBoxedParameter = Short.class;
                            break;
                        }
                        case "long": {
                            manuallyBoxedParameter = Long.class;
                            break;
                        }
                        case "float": {
                            manuallyBoxedParameter = Float.class;
                            break;
                        }
                        case "char": {
                            manuallyBoxedParameter = Character.class;
                            break;
                        }
                        case "boolean": {
                            manuallyBoxedParameter = Boolean.class;
                            break;
                        }
                    }
                    if (!manuallyBoxedParameter.isAssignableFrom(parameters[i].getClass())) {
                        parametersMatch = false;
                        break;
                    }
                }
                matches = parametersMatch;
            }
            if (!matches) continue;
            method.invoke(instance, parameters);
            break;
        }
        PlanItException.throwIf(!matches, String.format("unable to call registered method call %s no match found (or invalid argument list) on instance of type %s", methodName, instance.getClass().getCanonicalName()), new Object[0]);
    }

    protected void registerDelayedMethodCall(String methodName, Object ... parameters) {
        List<Object[]> parametersPerCall = this.delayedMethodCalls.get(methodName);
        if (parametersPerCall == null) {
            parametersPerCall = new ArrayList<Object[]>();
            this.delayedMethodCalls.put(methodName, parametersPerCall);
        }
        parametersPerCall.add(parameters);
    }

    protected Object getFirstParameterOfDelayedMethodCall(String methodName) {
        Object[] parametersOfLastCall;
        List<Object[]> parametersPerCall = this.delayedMethodCalls.get(methodName);
        if (parametersPerCall != null && (parametersOfLastCall = parametersPerCall.get(parametersPerCall.size() - 1)).length >= 1) {
            return parametersOfLastCall[0];
        }
        return null;
    }

    public Configurator(Class<T> instanceType) {
        this.configuratorClassType = instanceType;
        this.delayedMethodCalls = new HashMap<String, List<Object[]>>();
    }

    public Class<T> getClassTypeToConfigure() {
        return this.configuratorClassType;
    }

    public void configure(T toConfigureInstance) throws PlanItException {
        for (Map.Entry<String, List<Object[]>> methodCall : this.delayedMethodCalls.entrySet()) {
            try {
                for (Object[] parametersOfCall : methodCall.getValue()) {
                    this.callVoidMethod(toConfigureInstance, methodCall.getKey(), parametersOfCall);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.severe(e.getMessage());
                throw new PlanItException("could not call configurator delayed method call to " + methodCall.getKey() + " on class " + toConfigureInstance.getClass().getCanonicalName());
            }
        }
    }
}

