/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.time;

import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.time.TimePeriod;

public class TimePeriodImpl
extends ExternalIdAbleImpl
implements TimePeriod {
    private static final Logger LOGGER = Logger.getLogger(TimePeriodImpl.class.getCanonicalName());
    private final long startTimeSeconds;
    private final long durationSeconds;
    private final String description;

    public TimePeriodImpl(IdGroupingToken groupId, long startTimeSeconds, long durationSeconds) throws PlanItException {
        super(IdGenerator.generateId(groupId, TimePeriod.class));
        PlanItException.throwIf((double)durationSeconds > 86400.0, "Duration more than 24 hours", new Object[0]);
        PlanItException.throwIf((double)startTimeSeconds > 86400.0, "Start time later than 24 hours", new Object[0]);
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = null;
    }

    public TimePeriodImpl(IdGroupingToken groupId, String description, long startTimeSeconds, long durationSeconds) throws PlanItException {
        super(IdGenerator.generateId(groupId, TimePeriod.class));
        PlanItException.throwIf((double)durationSeconds > 86400.0, "Duration more than 24 hours", new Object[0]);
        PlanItException.throwIf((double)startTimeSeconds > 86400.0, "Start time later than 24 hours", new Object[0]);
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = description;
    }

    public TimePeriodImpl(TimePeriodImpl timePeriodImpl) {
        super(timePeriodImpl);
        this.startTimeSeconds = timePeriodImpl.startTimeSeconds;
        this.durationSeconds = timePeriodImpl.durationSeconds;
        this.description = timePeriodImpl.description;
    }

    @Override
    public long getStartTimeSeconds() {
        return this.startTimeSeconds;
    }

    @Override
    public long getDurationSeconds() {
        return this.durationSeconds;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public TimePeriodImpl clone() {
        return new TimePeriodImpl(this);
    }

    public String toString() {
        long endTime = this.startTimeSeconds + this.durationSeconds;
        return String.format("start time: %02d:%02d ", this.startTimeSeconds / 3600L, this.startTimeSeconds % 3600L / 60L) + String.format("- end time: %02d:%02d", endTime / 3600L, endTime % 3600L / 60L);
    }
}

