/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.supply.fundamentaldiagram;

import java.text.NumberFormat;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramBranch;
import org.goplanit.utils.misc.HashUtils;

public class LinearFundamentalDiagramBranch
implements FundamentalDiagramBranch {
    double characteristicWaveSpeedKmHour;
    double densityAtZeroFlowPcuKm;

    protected void setCharacteristicWaveSpeedKmHour(double characteristicWaveSpeedKmHour) {
        this.characteristicWaveSpeedKmHour = characteristicWaveSpeedKmHour;
    }

    protected void setDensityAtZeroFlow(double densityAtZeroFlowPcuKm) {
        this.densityAtZeroFlowPcuKm = densityAtZeroFlowPcuKm;
    }

    public LinearFundamentalDiagramBranch(double characteristicWaveSpeedKmHour, double densityAtZeroFlowPcuKm) {
        this.characteristicWaveSpeedKmHour = characteristicWaveSpeedKmHour;
        this.densityAtZeroFlowPcuKm = densityAtZeroFlowPcuKm;
    }

    public LinearFundamentalDiagramBranch(LinearFundamentalDiagramBranch linearFundamentalDiagramBranch) {
        this.characteristicWaveSpeedKmHour = linearFundamentalDiagramBranch.characteristicWaveSpeedKmHour;
        this.densityAtZeroFlowPcuKm = linearFundamentalDiagramBranch.densityAtZeroFlowPcuKm;
    }

    @Override
    public double getFlowPcuHour(double densityPcuKm) {
        return (densityPcuKm - this.densityAtZeroFlowPcuKm) * this.getCharateristicWaveSpeedKmHour();
    }

    @Override
    public double getDensityPcuKm(double flowPcuHour) {
        return this.densityAtZeroFlowPcuKm + flowPcuHour / this.getCharateristicWaveSpeedKmHour();
    }

    @Override
    public double getFlowTangent(double flowPcuHour) {
        return this.getCharateristicWaveSpeedKmHour();
    }

    public double getCharateristicWaveSpeedKmHour() {
        return this.characteristicWaveSpeedKmHour;
    }

    @Override
    public int relaxedHashCode(int scale) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(scale);
        return HashUtils.createCombinedHashCode(nf.format(this.characteristicWaveSpeedKmHour), nf.format(this.densityAtZeroFlowPcuKm));
    }

    @Override
    public LinearFundamentalDiagramBranch clone() {
        return new LinearFundamentalDiagramBranch(this);
    }

    @Override
    public double getSpeedKmHourAtZeroFlow() {
        return this.getCharateristicWaveSpeedKmHour();
    }

    @Override
    public double getSpeedKmHourAtZeroDensity() {
        return this.getCharateristicWaveSpeedKmHour();
    }

    @Override
    public boolean isLinear() {
        return true;
    }
}

