/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.service.routed.RoutedModeServices;
import org.goplanit.service.routed.RoutedModeServicesImpl;
import org.goplanit.service.routed.RoutedServicesLayer;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;

public class RoutedServicesLayerImpl
extends ExternalIdAbleImpl
implements RoutedServicesLayer {
    private static final Logger LOGGER = Logger.getLogger(RoutedServicesLayerImpl.class.getCanonicalName());
    private final IdGroupingToken tokenId;
    private final ServiceNetworkLayer parentLayer;
    private final Map<Mode, RoutedModeServices> routedServicesByMode;

    private static RoutedModeServicesImpl createRoutedModeServices(IdGroupingToken tokenId, Mode mode) {
        return new RoutedModeServicesImpl(tokenId, mode);
    }

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId(tokenId, RoutedServicesLayer.ROUTED_SERVICES_LAYER_ID_CLASS);
    }

    public RoutedServicesLayerImpl(IdGroupingToken tokenId, ServiceNetworkLayer parentLayer) {
        super(RoutedServicesLayerImpl.generateId(tokenId));
        this.tokenId = tokenId;
        this.parentLayer = parentLayer;
        this.routedServicesByMode = new HashMap<Mode, RoutedModeServices>();
    }

    public RoutedServicesLayerImpl(RoutedServicesLayerImpl routedServicesLayerImpl) {
        super(routedServicesLayerImpl);
        this.tokenId = routedServicesLayerImpl.tokenId;
        this.parentLayer = routedServicesLayerImpl.parentLayer;
        this.routedServicesByMode = new HashMap<Mode, RoutedModeServices>();
        routedServicesLayerImpl.routedServicesByMode.values().forEach(modeServices -> this.routedServicesByMode.put(modeServices.getMode(), (RoutedModeServices)modeServices));
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedServicesLayerImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public RoutedServicesLayerImpl clone() {
        return new RoutedServicesLayerImpl(this);
    }

    @Override
    public final ServiceNetworkLayer getParentLayer() {
        return this.parentLayer;
    }

    @Override
    public RoutedModeServices getServicesByMode(Mode mode) {
        if (!this.routedServicesByMode.containsKey(mode)) {
            this.routedServicesByMode.put(mode, RoutedServicesLayerImpl.createRoutedModeServices(this.tokenId, mode));
        }
        return this.routedServicesByMode.get(mode);
    }

    @Override
    public Iterator<RoutedModeServices> iterator() {
        return this.routedServicesByMode.values().iterator();
    }

    @Override
    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s [layer: %s]", prefix, this.getXmlId()));
        for (RoutedModeServices modeServices : this) {
            LOGGER.info(String.format("%s [layer: %s] [mode: %s] #routedServices: %d", prefix, this.getXmlId(), modeServices.getMode().getXmlId(), modeServices.size()));
        }
    }
}

