/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.path;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.path.DirectedPath;

public class DirectedPathImpl
extends ExternalIdAbleImpl
implements DirectedPath {
    private static final Logger LOGGER = Logger.getLogger(DirectedPathImpl.class.getCanonicalName());
    private final Deque<EdgeSegment> path;

    protected static long generateId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, DirectedPath.PATH_ID_CLASS);
    }

    protected DirectedPathImpl(IdGroupingToken groupId) {
        super(DirectedPathImpl.generateId(groupId));
        this.path = new ArrayDeque<EdgeSegment>();
    }

    protected DirectedPathImpl(IdGroupingToken groupId, Deque<? extends EdgeSegment> pathEdgeSegments) {
        super(DirectedPathImpl.generateId(groupId));
        this.path = pathEdgeSegments;
    }

    @Override
    public Iterator<EdgeSegment> iterator() {
        return this.path.iterator();
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = DirectedPathImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public long size() {
        return this.path.size();
    }

    @Override
    public boolean containsSubPath(Collection<? extends EdgeSegment> subPath) {
        if (subPath == null || subPath.isEmpty()) {
            return false;
        }
        Iterator<? extends EdgeSegment> subPathIter = subPath.iterator();
        EdgeSegment subPathSegment = subPathIter.next();
        boolean started = false;
        for (EdgeSegment edgeSegment : this.path) {
            if (edgeSegment.idEquals(subPathSegment)) {
                started = true;
                if (!subPathIter.hasNext()) break;
                subPathSegment = subPathIter.next();
                continue;
            }
            if (!started || !subPathIter.hasNext()) continue;
            return false;
        }
        return started;
    }
}

